/*
 * Decompiled with CFR 0.152.
 */
package com.initech.asn1.useful;

import com.initech.asn1.ASN1Decoder;
import com.initech.asn1.ASN1Encoder;
import com.initech.asn1.ASN1Exception;
import com.initech.asn1.ASN1Tag;
import com.initech.asn1.ASN1Type;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class Time
implements ASN1Type {
    private static final long serialVersionUID = 3553848921544273606L;
    private static Date utcLimit;
    private Date value;
    private boolean forceGeneralizedTime;
    private static final int[] taglist;

    public Time() {
        this.value = new Date();
    }

    public Time(Date v) {
        this.value = new Date(v.getTime());
    }

    public void setTime(Date v) {
        this.value = new Date(v.getTime());
    }

    public Date getTime() {
        return new Date(this.value.getTime());
    }

    public void setForceGeneralizedTime(boolean f) {
        this.forceGeneralizedTime = f;
    }

    public void decode(ASN1Decoder dec) throws ASN1Exception {
        int tag = dec.decodeChoice(taglist);
        if (tag == 23) {
            this.value = dec.decodeUTCTime();
        } else if (tag == 24) {
            this.value = dec.decodeGeneralizedTime();
        } else {
            throw new ASN1Exception("Unexpected tag: " + ASN1Tag.tagToString(tag));
        }
    }

    public void encode(ASN1Encoder enc) throws ASN1Exception {
        enc.encodeChoice(0, taglist);
        if (this.forceGeneralizedTime) {
            enc.encodeGeneralizedTime(this.value);
        } else if (this.value.before(utcLimit)) {
            enc.encodeUTCTime(this.value);
        } else {
            enc.encodeGeneralizedTime(this.value);
        }
    }

    public String toString() {
        return this.value.toString();
    }

    static {
        taglist = new int[]{23, 24};
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        cal.set(2049, 11, 31, 23, 59, 59);
        utcLimit = cal.getTime();
    }
}

