/*
 * Decompiled with CFR 0.152.
 */
package com.initech.asn1.useful;

import com.initech.asn1.ASN1Decoder;
import com.initech.asn1.ASN1Encoder;
import com.initech.asn1.ASN1Exception;
import com.initech.asn1.useful.DNSName;
import com.initech.asn1.useful.GeneralNameInterface;
import com.initech.asn1.useful.IPAddressName;
import java.io.UnsupportedEncodingException;

public class URIName
implements GeneralNameInterface {
    private static final long serialVersionUID = 652726976534981602L;
    private String name;
    private String scheme;
    private String host;
    private int port;
    private String remainder;
    private String path;
    private String query;
    private IPAddressName hostIP;
    private DNSName hostDNS;
    private static byte[] hex = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 0, 0, 0, 0, 0, 0, 0, 10, 11, 12, 13, 14, 15, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 11, 12, 13, 14, 15, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};

    URIName(ASN1Decoder dec) throws ASN1Exception {
        this.decode(dec);
    }

    public URIName(String s) throws IllegalArgumentException {
        if (s == null || s.length() != 0) {
            this.parseName(s);
        }
        this.name = s;
    }

    public void parseName(String s) throws IllegalArgumentException {
        int p;
        char c;
        int j1;
        int i1;
        int sp = -1;
        if (s == null || s.length() == 0) {
            throw new IllegalArgumentException("URI name must not be null");
        }
        int i = s.indexOf(58);
        if (i < 0) {
            throw new IllegalArgumentException("Name " + s + " does not include a <scheme>");
        }
        int j = s.indexOf("//", i);
        if (j != i + 1) {
            throw new IllegalArgumentException("name does not include scheme-specific portion starting with host");
        }
        int k = j + 2;
        if (k == s.length()) {
            throw new IllegalArgumentException("Name " + s + " doesn't include a <host>");
        }
        int l = s.indexOf(93, k);
        if (l >= 0) {
            k = l;
        }
        if ((i1 = s.indexOf(47, k)) < 0) {
            i1 = s.length();
        }
        if ((j1 = s.indexOf(64, j + 2) + 1) <= 0 || j1 >= i1) {
            j1 = j + 2;
        }
        int he = -1;
        if (s.charAt(j1) == '[') {
            he = s.indexOf(93, j1);
            if (he < 0) {
                throw new IllegalArgumentException("Invalid IPv6 address as host: missing ]");
            }
            if (he < s.length() - 1) {
                c = s.charAt(he + 1);
                if (c != ':' && c != '/') {
                    throw new IllegalArgumentException("Invalid host[:port][/] boundary");
                }
                if (c == ':') {
                    p = s.indexOf(47, he + 1);
                    if (p < 0) {
                        this.port = Integer.parseInt(s.substring(he + 1), 10);
                    } else {
                        this.port = Integer.parseInt(s.substring(he + 1, p), 10);
                        sp = p;
                    }
                } else {
                    sp = he + 1;
                }
                ++he;
            } else {
                he = i1;
            }
        } else {
            he = s.indexOf(58, j1);
            if (he < 0 || he >= i1) {
                he = i1;
            }
            if (he + 1 < s.length()) {
                c = s.charAt(he);
                if (c != ':' && c != '/') {
                    throw new IllegalArgumentException("Invalid host[:port][/] boundary");
                }
                if (c == ':') {
                    p = s.indexOf(47, he + 1);
                    if (p < 0) {
                        this.port = Integer.parseInt(s.substring(he + 1), 10);
                    } else {
                        this.port = Integer.parseInt(s.substring(he + 1, p), 10);
                        sp = p;
                    }
                } else {
                    sp = he;
                }
            }
        }
        this.scheme = s.substring(0, i);
        this.host = s.substring(j1, he);
        if (this.host.length() == 0) {
            this.hostDNS = null;
            this.hostIP = null;
        } else {
            if (this.host.charAt(0) == '[') {
                String ip = this.host.substring(1, this.host.length() - 1);
                try {
                    this.hostIP = new IPAddressName(ip);
                }
                catch (IllegalArgumentException ex) {
                    throw new IllegalArgumentException("Host portion is not a valid IPv6 address: " + ex.getMessage());
                }
            }
            try {
                this.hostDNS = this.host.charAt(0) == '.' ? new DNSName(this.host.substring(1)) : new DNSName(this.host);
            }
            catch (Exception ex) {
                try {
                    this.hostIP = new IPAddressName(this.host);
                }
                catch (IllegalArgumentException iaex) {
                    throw new IllegalArgumentException("Host portion is not a valid DNS name, IPv4 address, or IPv6 address");
                }
            }
        }
        this.remainder = s.substring(i, j1);
        if (he < s.length()) {
            this.remainder = this.remainder + s.substring(he);
        }
        if (sp > 0 && sp + 1 < s.length()) {
            String path_query = s.substring(sp + 1);
            int pi = path_query.indexOf(63);
            if (pi < 0) {
                this.path = path_query;
            } else {
                this.path = path_query.substring(0, pi);
                this.query = path_query.substring(pi + 1);
            }
        }
        if (this.port == 0) {
            if (this.scheme.equalsIgnoreCase("HTTP")) {
                this.port = 80;
            } else if (this.scheme.equalsIgnoreCase("LDAP")) {
                this.port = 389;
            } else if (this.scheme.equalsIgnoreCase("HTTPS")) {
                this.port = 443;
            }
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof URIName)) {
            return false;
        }
        URIName other = (URIName)o;
        if (this.name.equalsIgnoreCase(other.getName())) {
            String s;
            if (this.remainder == null ^ (s = other.getRemainder()) == null) {
                return false;
            }
            if (this.remainder != null && s != null) {
                return this.remainder.equals(s);
            }
            return true;
        }
        return false;
    }

    public int getType() {
        return 6;
    }

    public String getName() {
        return this.name;
    }

    public String getScheme() {
        return this.scheme;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public Object getHostObject() {
        if (this.hostIP != null) {
            return this.hostIP;
        }
        return this.hostDNS;
    }

    public String getRemainder() {
        return this.remainder;
    }

    public String getPath() {
        return this.path;
    }

    public String getQuery() {
        return this.query;
    }

    public int hashCode() {
        return this.name.toUpperCase().hashCode();
    }

    public int constrains(GeneralNameInterface gni) throws UnsupportedOperationException {
        int ret;
        if (gni == null) {
            ret = -1;
        } else if (gni.getType() != 6) {
            ret = -1;
        } else {
            URIName other = (URIName)gni;
            if (this.name.length() == 0 || other.getName().length() == 0) {
                int ret2 = this.name.length() == 0 && other.getName().length() == 0 ? 0 : (this.name.length() == 0 ? 2 : 1);
                return ret2;
            }
            String o_scheme = other.getScheme();
            String o_host = other.getHost();
            if (!this.scheme.equalsIgnoreCase(o_scheme)) {
                ret = 3;
            } else if (o_host.equalsIgnoreCase(this.host)) {
                ret = 0;
            } else {
                if (other.getHostObject() instanceof IPAddressName && this.hostIP != null) {
                    return this.hostIP.constrains((IPAddressName)other.getHostObject());
                }
                if (o_host.length() == 0 || this.host.length() == 0) {
                    ret = 3;
                } else if (o_host.charAt(0) == '.' || this.host.charAt(0) == '.') {
                    try {
                        DNSName my_dns = this.host.charAt(0) == '.' ? new DNSName(this.host.substring(1)) : new DNSName(this.host);
                        DNSName other_dns = o_host.charAt(0) == '.' ? new DNSName(o_host.substring(1)) : new DNSName(o_host);
                        ret = my_dns.constrains(other_dns);
                    }
                    catch (IllegalArgumentException ex) {
                        ret = 3;
                    }
                    catch (UnsupportedOperationException ex) {
                        ret = 3;
                    }
                } else {
                    ret = 3;
                }
            }
        }
        return ret;
    }

    public int subtreeDepth() throws UnsupportedOperationException {
        DNSName dns = null;
        try {
            dns = new DNSName(this.host);
        }
        catch (IllegalArgumentException ex) {
            throw new UnsupportedOperationException(ex.getMessage());
        }
        return dns.subtreeDepth();
    }

    public String toString() {
        return this.toString(false, false);
    }

    public String toString(boolean can) {
        return this.toString(can, false);
    }

    public String toString(boolean can, boolean withType) {
        String ret = can ? this.name.toLowerCase() : this.name.toString();
        if (withType) {
            ret = "URI: " + ret;
        }
        return ret;
    }

    public void encode(ASN1Encoder enc) throws ASN1Exception {
        enc.encodeIA5String(this.name);
    }

    public void decode(ASN1Decoder dec) throws ASN1Exception {
        this.name = dec.decodeIA5String();
        this.parseName(this.name);
    }

    public static String unescape(String s, String enc) throws UnsupportedEncodingException {
        byte[] src = s.getBytes("ISO8859_1");
        byte[] dest = new byte[src.length];
        int i = 0;
        int j = 0;
        while (i < src.length) {
            switch (src[i]) {
                case 37: {
                    if (i + 2 < src.length) {
                        dest[j] = (byte)(hex[src[i + 1]] << 4 | hex[src[i + 2]] << 0);
                        i += 2;
                        break;
                    }
                    throw new IllegalArgumentException();
                }
                default: {
                    dest[j] = src[i];
                }
            }
            ++i;
            ++j;
        }
        return new String(dest, 0, j, enc);
    }
}

