/*
 * Decompiled with CFR 0.152.
 */
package com.initech.asn1.useful;

import com.initech.asn1.ASN1Decoder;
import com.initech.asn1.ASN1Encoder;
import com.initech.asn1.ASN1Exception;
import com.initech.asn1.ASN1Tag;
import com.initech.asn1.ASN1Type;
import com.initech.asn1.DERDecoder;
import com.initech.asn1.DEREncoder;
import com.initech.asn1.useful.AlgorithmID;
import com.initech.asn1.useful.HashContent;
import com.initech.provider.crypto.InitechProvider;
import java.security.DigestException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;

public class VID
implements ASN1Type {
    private static final long serialVersionUID = -3363097876787286751L;
    private static AlgorithmID DEFAULT_HASH_ALG;
    private static int HASH_COUNT;
    private AlgorithmID hashAlg = new AlgorithmID();
    private byte[] vid;

    public VID() {
    }

    public VID(AlgorithmID algorithmid) {
        this.hashAlg = algorithmid;
    }

    public VID(String s) {
        this.hashAlg = new AlgorithmID(s);
    }

    public VID(byte[] abyte0) throws ASN1Exception {
        DERDecoder derdecoder = new DERDecoder(abyte0);
        this.decode(derdecoder);
    }

    public void decode(ASN1Decoder asn1decoder) throws ASN1Exception {
        int i = asn1decoder.decodeSequence();
        this.hashAlg.decode(asn1decoder);
        int j = asn1decoder.decodeExplicit(ASN1Tag.makeContextTag(0));
        this.vid = asn1decoder.decodeOctetString();
        asn1decoder.endOf(j);
        asn1decoder.endOf(i);
    }

    public void encode(ASN1Encoder asn1encoder) throws ASN1Exception {
        int i = asn1encoder.encodeSequence();
        this.hashAlg.encode(asn1encoder);
        int j = asn1encoder.encodeExplicit(ASN1Tag.makeContextTag(0));
        asn1encoder.encodeOctetString(this.vid, 0, this.vid.length);
        asn1encoder.endOf(j);
        asn1encoder.endOf(i);
    }

    public byte[] getEncoded() throws ASN1Exception {
        DEREncoder derencoder = new DEREncoder();
        this.encode(derencoder);
        return derencoder.toByteArray();
    }

    public AlgorithmID getHashAlg() {
        return this.hashAlg;
    }

    public byte[] getVID() {
        return this.vid != null ? (byte[])this.vid.clone() : null;
    }

    private void makeVID(HashContent hashcontent) throws NoSuchAlgorithmException, DigestException, ASN1Exception, NoSuchProviderException {
        if (this.hashAlg == null) {
            this.hashAlg = DEFAULT_HASH_ALG;
        }
        MessageDigest messagedigest = MessageDigest.getInstance(this.hashAlg.getAlgName(), InitechProvider.NAME);
        byte[] abyte0 = messagedigest.digest(hashcontent.getEncoded());
        this.vid = messagedigest.digest(abyte0);
    }

    public void set(AlgorithmID algorithmid, HashContent hashcontent) throws NoSuchAlgorithmException, DigestException, ASN1Exception, NoSuchProviderException {
        this.hashAlg = algorithmid;
        this.makeVID(hashcontent);
    }

    public void set(String s, HashContent hashcontent) throws NoSuchAlgorithmException, DigestException, ASN1Exception, NoSuchProviderException {
        this.hashAlg = new AlgorithmID(s);
        this.set(this.hashAlg, hashcontent);
    }

    public void setHashAlg(AlgorithmID algorithmid) {
        this.hashAlg = algorithmid;
    }

    public void setHashAlg(String s) {
        this.hashAlg = new AlgorithmID(s);
    }

    public void setVID(HashContent hashcontent) throws NoSuchAlgorithmException, DigestException, ASN1Exception, NoSuchProviderException {
        this.makeVID(hashcontent);
    }

    static {
        HASH_COUNT = 2;
        DEFAULT_HASH_ALG = AlgorithmID.SHA1;
    }
}

