/*
 * Decompiled with CFR 0.152.
 */
package com.initech.asn1.useful;

import com.initech.asn1.ASN1Decoder;
import com.initech.asn1.ASN1Encoder;
import com.initech.asn1.ASN1Exception;
import com.initech.asn1.useful.GeneralNameInterface;
import com.initech.cryptox.util.Hex;
import java.util.Arrays;

public class X400Address
implements GeneralNameInterface {
    private static final long serialVersionUID = -4507180319143752284L;
    byte[] name;

    public X400Address() {
    }

    X400Address(ASN1Decoder dec) throws ASN1Exception {
        this.decode(dec);
    }

    public X400Address(byte[] b) throws ASN1Exception {
        this.name = b;
    }

    public int getType() {
        return 3;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof X400Address)) {
            return false;
        }
        X400Address other = (X400Address)obj;
        return Arrays.equals(this.name, other.name);
    }

    public int constrains(GeneralNameInterface gni) throws UnsupportedOperationException {
        int ret;
        if (gni == null) {
            ret = -1;
        } else if (gni.getType() != 3) {
            ret = -1;
        } else {
            throw new UnsupportedOperationException("Narrowing, widening and matching are not supported for X400Address");
        }
        return ret;
    }

    public int subtreeDepth() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("subtreeDepth() not defined for X400Address");
    }

    public String toString() {
        return this.toString(false, false);
    }

    public String toString(boolean can) {
        return this.toString(can, false);
    }

    public String toString(boolean can, boolean withType) {
        String ret = Hex.prettyDump(this.name, 48, ' ');
        if (withType) {
            ret = "X400Address: " + ret;
        }
        return ret;
    }

    public void encode(ASN1Encoder enc) throws ASN1Exception {
        enc.encodeAny(this.name);
    }

    public void decode(ASN1Decoder dec) throws ASN1Exception {
        this.name = dec.decodeAnyAsByteArray();
    }
}

