/*
 * Decompiled with CFR 0.152.
 */
package com.initech.asn1.util;

import com.initech.asn1.util.ASN1ByteArrayOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class CaptureInputStream
extends FilterInputStream {
    protected ASN1ByteArrayOutputStream buf = new ASN1ByteArrayOutputStream(1024);
    private boolean capture = false;

    public CaptureInputStream(InputStream in) {
        super(in);
    }

    public int read() throws IOException {
        int i = this.in.read();
        if (i < 0) {
            return -1;
        }
        if (this.capture) {
            this.buf.write(i);
        }
        return i;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int l = this.in.read(b, off, len);
        if (l < 0) {
            return -1;
        }
        if (this.capture) {
            this.buf.write(b, off, l);
        }
        return l;
    }

    public int available() throws IOException {
        return this.in.available();
    }

    public long skip(long n) throws IOException {
        return this.in.skip(n);
    }

    public boolean markSupported() {
        return false;
    }

    public void close() throws IOException {
        this.buf.close();
    }

    public void startCapture() {
        this.capture = true;
        this.buf.reset();
    }

    public void endCapture() {
        this.capture = false;
    }

    public byte[] getCapturedData() {
        return this.buf.toByteArray();
    }
}

