/*
 * Decompiled with CFR 0.152.
 */
package com.initech.cryptox;

import com.initech.cryptox.BadPaddingException;
import com.initech.cryptox.CipherSpi;
import com.initech.cryptox.IllegalBlockSizeException;
import com.initech.cryptox.NoSuchPaddingException;
import com.initech.cryptox.NullCipher;
import com.initech.provider.crypto.InitechProvider;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.ShortBufferException;

public class Cipher {
    public static final int ENCRYPT_MODE = 1;
    public static final int DECRYPT_MODE = 2;
    public static final int WRAP_MODE = 3;
    public static final int UNWRAP_MODE = 4;
    public static final int PUBLIC_KEY = 1;
    public static final int PRIVATE_KEY = 2;
    public static final int SECRET_KEY = 3;
    public boolean isInit;
    public int opMode;
    public String transformation;
    public static String modeName;
    public CipherSpi cipherSpi;
    public Provider provider;

    protected Cipher(CipherSpi cipherSpi, Provider provider, String transformation) {
        this.cipherSpi = cipherSpi;
        this.provider = provider;
        this.transformation = transformation;
        this.isInit = false;
    }

    private static final Cipher getInstance(String transformation, Provider provider) throws NoSuchAlgorithmException, NoSuchPaddingException {
        Object cSpi;
        if (transformation == null) {
            throw new NoSuchPaddingException("No transform given");
        }
        boolean numToken = false;
        String[] ctoken = new String[3];
        boolean isSetPadding = false;
        boolean isSetMode = false;
        int firstIndex = transformation.indexOf(47);
        int lastIndex = transformation.lastIndexOf(47);
        if (firstIndex != -1) {
            if (lastIndex == -1) {
                throw new NoSuchAlgorithmException("Wrong transformation format");
            }
            ctoken[0] = transformation.substring(0, firstIndex);
            ctoken[1] = firstIndex + 1 <= lastIndex ? transformation.substring(firstIndex + 1, lastIndex) : "";
            ctoken[2] = lastIndex + 1 <= transformation.length() ? transformation.substring(lastIndex + 1, transformation.length()) : "";
            try {
                cSpi = InitechProvider.getImplementation(transformation, "Cipher", provider);
            }
            catch (NoSuchAlgorithmException e3) {
                try {
                    cSpi = InitechProvider.getImplementation(ctoken[0] + "/" + ctoken[1], "Cipher", provider);
                    isSetPadding = true;
                }
                catch (NoSuchAlgorithmException e2) {
                    try {
                        cSpi = InitechProvider.getImplementation(ctoken[0] + "//" + ctoken[2], "Cipher", provider);
                        isSetMode = true;
                    }
                    catch (NoSuchAlgorithmException e1) {
                        cSpi = InitechProvider.getImplementation(ctoken[0], "Cipher", provider);
                        isSetMode = true;
                        isSetPadding = true;
                    }
                }
            }
        } else {
            cSpi = InitechProvider.getImplementation(transformation, "Cipher", provider);
        }
        Cipher cipher = new Cipher((CipherSpi)cSpi, provider, transformation);
        if (isSetMode) {
            cipher.cipherSpi.engineSetMode(ctoken[1]);
        }
        if (isSetPadding) {
            cipher.cipherSpi.engineSetPadding(ctoken[2]);
        }
        modeName = ctoken[1];
        return cipher;
    }

    public static final Cipher getInstance(String transformation) throws NoSuchAlgorithmException, NoSuchPaddingException {
        Provider[] providers = Security.getProviders();
        for (int i = 0; i < providers.length; ++i) {
            try {
                return Cipher.getInstance(transformation, providers[i]);
            }
            catch (Exception exception) {
                continue;
            }
        }
        throw new NoSuchAlgorithmException(transformation);
    }

    public static final Cipher getInstance(String transformation, String providerName) throws NoSuchAlgorithmException, NoSuchPaddingException, NoSuchProviderException {
        Provider provider = InitechProvider.checkProviderObject(providerName);
        if (provider == null) {
            throw new NoSuchProviderException(transformation + " for " + providerName);
        }
        return Cipher.getInstance(transformation, provider);
    }

    public final String getAlgorithm() {
        return this.transformation;
    }

    public final int getBlockSize() throws IllegalStateException {
        if (!this.isInit) {
            throw new IllegalStateException();
        }
        return this.cipherSpi.engineGetBlockSize();
    }

    public final byte[] getIV() {
        return this.cipherSpi.engineGetIV();
    }

    public final int getOutputSize(int inputLen) {
        return this.cipherSpi.engineGetOutputSize(inputLen);
    }

    public final AlgorithmParameters getParameters() {
        return this.cipherSpi.engineGetParameters();
    }

    public final Provider getProvider() {
        return this.provider;
    }

    public final void init(int opmode, Key key) throws InvalidKeyException {
        this.cipherSpi.engineInit(opmode, key, new SecureRandom());
        this.opMode = opmode;
        this.isInit = true;
    }

    public final void init(int opmode, Key key, SecureRandom random) throws InvalidKeyException {
        this.cipherSpi.engineInit(opmode, key, random);
        this.opMode = opmode;
        this.isInit = true;
    }

    public final void init(int opmode, Key key, AlgorithmParameterSpec params) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.cipherSpi.engineInit(opmode, key, params, new SecureRandom());
        this.opMode = opmode;
        this.isInit = true;
    }

    public final void init(int opmode, Key key, AlgorithmParameterSpec params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.cipherSpi.engineInit(opmode, key, params, random);
        this.opMode = opmode;
        this.isInit = true;
    }

    public final void init(int opmode, Key key, AlgorithmParameters params) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.cipherSpi.engineInit(opmode, key, params, new SecureRandom());
        this.opMode = opmode;
        this.isInit = true;
    }

    public final void init(int opmode, Key key, AlgorithmParameters params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.cipherSpi.engineInit(opmode, key, params, random);
        this.opMode = opmode;
        this.isInit = true;
    }

    public final byte[] update(byte[] input) throws IllegalStateException {
        if (!this.isInit) {
            throw new IllegalStateException("Cipher is not initialized");
        }
        if (input == null) {
            throw new IllegalArgumentException("input is null");
        }
        return this.cipherSpi.engineUpdate(input, 0, input.length);
    }

    public final byte[] update(byte[] input, int inputOffset, int inputLen) throws IllegalStateException {
        if (!this.isInit) {
            throw new IllegalStateException("Cipher is not initialized");
        }
        if (input == null) {
            throw new IllegalArgumentException("input is null");
        }
        if (inputOffset < 0) {
            throw new IllegalArgumentException("input offset is negative");
        }
        if (inputOffset + inputLen > input.length) {
            throw new IllegalArgumentException("inputLength is too big");
        }
        return this.cipherSpi.engineUpdate(input, inputOffset, inputLen);
    }

    public final int update(byte[] input, int inputOffset, int inputLen, byte[] output) throws IllegalArgumentException, ShortBufferException {
        if (!this.isInit) {
            throw new IllegalStateException("Cipher is not initialized");
        }
        if (input == null) {
            throw new IllegalArgumentException("input is null");
        }
        if (inputOffset < 0) {
            throw new IllegalArgumentException("input offset is negative");
        }
        if (inputOffset + inputLen > input.length) {
            throw new IllegalArgumentException("inputLength is too big");
        }
        return this.cipherSpi.engineUpdate(input, inputOffset, inputLen, output, 0);
    }

    public final int update(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) throws IllegalArgumentException, ShortBufferException {
        if (!this.isInit) {
            throw new IllegalStateException("Cipher is not initialized");
        }
        if (input == null) {
            throw new IllegalArgumentException("input is null");
        }
        if (inputOffset < 0) {
            throw new IllegalArgumentException("input offset is negative");
        }
        if (inputOffset + inputLen > input.length) {
            throw new IllegalArgumentException("inputLength is too big");
        }
        if (outputOffset < 0) {
            throw new IllegalArgumentException("update2:output offset is negative");
        }
        int outputSize = this.getOutputSize(inputLen);
        return this.cipherSpi.engineUpdate(input, inputOffset, inputLen, output, outputOffset);
    }

    public final byte[] doFinal() throws IllegalStateException, IllegalBlockSizeException, BadPaddingException {
        if (!this.isInit) {
            throw new IllegalStateException("Cipher is not initialized");
        }
        return this.cipherSpi.engineDoFinal(null, 0, 0);
    }

    public final int doFinal(byte[] output, int outputOffset) throws IllegalStateException, BadPaddingException, ShortBufferException, IllegalBlockSizeException {
        if (!this.isInit) {
            throw new IllegalStateException("Cipher is not initialized");
        }
        if (outputOffset < 0) {
            throw new IllegalArgumentException("output offset is negative");
        }
        return this.cipherSpi.engineDoFinal(null, 0, 0, output, outputOffset);
    }

    public final byte[] doFinal(byte[] input) throws IllegalStateException, BadPaddingException, IllegalBlockSizeException {
        if (!this.isInit) {
            throw new IllegalStateException("Cipher is not initialized");
        }
        if (input == null) {
            throw new IllegalArgumentException("input is null");
        }
        byte[] ret = this.cipherSpi.engineDoFinal(input, 0, input.length);
        return ret;
    }

    public final byte[] doFinal(byte[] input, int inputOffset, int inputLen) throws IllegalStateException, BadPaddingException, IllegalBlockSizeException {
        if (!this.isInit) {
            throw new IllegalStateException("Cipher is not initialized");
        }
        if (input == null) {
            throw new IllegalArgumentException("input is null");
        }
        if (inputOffset < 0) {
            throw new IllegalArgumentException("input offset is negative");
        }
        if (inputOffset + inputLen > input.length) {
            throw new IllegalArgumentException("inputLength is too big");
        }
        return this.cipherSpi.engineDoFinal(input, inputOffset, inputLen);
    }

    public final int doFinal(byte[] input, int inputOffset, int inputLen, byte[] output) throws IllegalArgumentException, ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        if (!this.isInit) {
            throw new IllegalStateException("Cipher is not initialized");
        }
        if (input == null) {
            throw new IllegalArgumentException("input is null");
        }
        if (inputOffset < 0) {
            throw new IllegalArgumentException("input offset is negative");
        }
        if (inputOffset + inputLen > input.length) {
            throw new IllegalArgumentException("inputLength is too big");
        }
        return this.cipherSpi.engineDoFinal(input, inputOffset, inputLen, output, 0);
    }

    public final int doFinal(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) throws IllegalArgumentException, ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        if (!this.isInit) {
            throw new IllegalStateException("Cipher is not initialized");
        }
        if (input == null) {
            throw new IllegalArgumentException("input is null");
        }
        if (inputOffset < 0) {
            throw new IllegalArgumentException("input offset is negative");
        }
        if (inputOffset + inputLen > input.length) {
            throw new IllegalArgumentException("inputLength is too big");
        }
        if (outputOffset < 0) {
            throw new IllegalArgumentException("output offset is negative");
        }
        return this.cipherSpi.engineDoFinal(input, inputOffset, inputLen, output, outputOffset);
    }

    public final byte[] wrap(Key key) throws IllegalBlockSizeException, IllegalStateException, InvalidKeyException, NoSuchAlgorithmException {
        if (!this.isInit && !(this instanceof NullCipher)) {
            throw new IllegalStateException("Cipher not initialized");
        }
        if (this.opMode != 3) {
            throw new IllegalStateException("Cipher not initiailzed for wrapping keys");
        }
        return this.cipherSpi.engineWrap(key);
    }

    public final Key unwrap(byte[] wrappedKey, String wrappedKeyAlgorithm, int wrappedKeyType) throws IllegalStateException, InvalidKeyException, NoSuchAlgorithmException {
        if (!this.isInit && !(this instanceof NullCipher)) {
            throw new IllegalStateException("Cipher not initialized");
        }
        if (this.opMode != 4) {
            throw new IllegalStateException("Cipher not initiailzed for unwrapping keys");
        }
        if (wrappedKeyType != 3 && wrappedKeyType != 2 && wrappedKeyType != 1) {
            throw new InvalidParameterException("Invalid key type");
        }
        return this.cipherSpi.engineUnwrap(wrappedKey, wrappedKeyAlgorithm, wrappedKeyType);
    }
}

