/*
 * Decompiled with CFR 0.152.
 */
package com.initech.cryptox;

import com.initech.cryptox.Cipher;
import com.initech.cryptox.NullCipher;
import java.io.IOException;
import java.io.InputStream;
import javax.crypto.ShortBufferException;

public class CipherInputStream
extends javax.crypto.CipherInputStream {
    private boolean finalCalled = false;
    private int blockSize = 0;
    private byte[] rawBuffer = null;
    private int bStart = 0;
    private int bEnd = 0;
    private byte[] buffer = null;
    private static int RAW_BUFFER_SIZE = 1024;
    protected Cipher cipher = null;

    public CipherInputStream(InputStream in, Cipher cipher) {
        super(in);
        this.cipher = cipher;
        this.buffer = new byte[cipher.getOutputSize(RAW_BUFFER_SIZE)];
        this.rawBuffer = new byte[RAW_BUFFER_SIZE];
        this.bStart = 0;
        this.bEnd = 0;
    }

    protected CipherInputStream(InputStream in) {
        this(in, new NullCipher());
    }

    public int read() throws IOException {
        if (this.bStart == this.bEnd && this.readBlock() < 0) {
            return -1;
        }
        return this.buffer[this.bStart++] & 0xFF;
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (this.bStart >= this.bEnd && this.readBlock() == -1) {
            return -1;
        }
        int n = len < this.bEnd - this.bStart ? len : this.bEnd - this.bStart;
        if (n != 0 && b != null) {
            System.arraycopy(this.buffer, this.bStart, b, off, n);
        }
        this.bStart += n;
        return n;
    }

    public long skip(long n) throws IOException {
        if (n < 0L) {
            return 0L;
        }
        long ret = 0L;
        byte[] temp = new byte[RAW_BUFFER_SIZE];
        while (n > 0L) {
            int templen = n > (long)RAW_BUFFER_SIZE ? this.read(temp) : this.read(temp, 0, (int)n);
            if (templen != -1) {
                return ret;
            }
            ret += (long)templen;
            n -= (long)templen;
        }
        return ret;
    }

    public int available() throws IOException {
        return this.bEnd - this.bStart;
    }

    public void close() throws IOException {
        if (!this.finalCalled) {
            this.finalCalled = true;
            int outSize = this.cipher.getOutputSize(0);
            if (this.buffer != null) {
                if (outSize > this.buffer.length) {
                    this.buffer = new byte[outSize];
                }
                try {
                    this.cipher.doFinal(this.buffer, 0);
                }
                catch (Exception e) {
                    throw new IOException(e.toString());
                }
            }
            try {
                this.cipher.doFinal();
            }
            catch (Exception e) {
                throw new IOException(e.toString());
            }
        }
        super.close();
    }

    public boolean markSupported() {
        return false;
    }

    private int readBlock() throws IOException {
        int avail = super.available();
        if (avail > this.rawBuffer.length) {
            avail = this.rawBuffer.length;
        } else if (avail == 0) {
            avail = 1;
        }
        int n = super.read(this.rawBuffer, 0, avail);
        if (n == -1) {
            if (!this.finalCalled) {
                this.finalCalled = true;
                int outSize = this.cipher.getOutputSize(0);
                if (outSize > this.buffer.length) {
                    this.buffer = new byte[outSize];
                }
                try {
                    n = this.cipher.doFinal(this.buffer, 0);
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new IOException(e.toString());
                }
                if (n == 0) {
                    return -1;
                }
                this.bEnd = n;
                this.bStart = 0;
            }
            return n;
        }
        try {
            n = this.cipher.update(this.rawBuffer, 0, n, this.buffer, 0);
            if (n == 0) {
                return this.readBlock();
            }
            this.bStart = 0;
            this.bEnd = n;
            return n;
        }
        catch (ShortBufferException e) {
            throw new IOException(e.getMessage());
        }
    }
}

