/*
 * Decompiled with CFR 0.152.
 */
package com.initech.cryptox;

import com.initech.cryptox.Cipher;
import com.initech.cryptox.NullCipher;
import java.io.IOException;
import java.io.OutputStream;

public class CipherOutputStream
extends javax.crypto.CipherOutputStream {
    protected Cipher cipher = null;
    boolean flushed = false;
    byte[] oneByte = new byte[1];

    public CipherOutputStream(OutputStream out, Cipher cipher) {
        super(out);
        this.cipher = cipher;
    }

    public CipherOutputStream(OutputStream out) {
        this(out, new NullCipher());
    }

    public void write(int b) throws IOException {
        this.oneByte[0] = (byte)b;
        this.write(this.oneByte, 0, 1);
    }

    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        byte[] enc = this.cipher.update(b, off, len);
        if (enc != null) {
            this.out.write(enc, 0, enc.length);
        }
    }

    public void flush() throws IOException {
        super.flush();
    }

    public void close() throws IOException {
        try {
            byte[] enc = this.cipher.doFinal();
            if (enc != null) {
                this.out.write(enc, 0, enc.length);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IOException(e.getMessage());
        }
        this.flush();
        super.close();
    }
}

