/*
 * Decompiled with CFR 0.152.
 */
package com.initech.cryptox;

import com.initech.cryptox.KeyAgreementSpi;
import com.initech.cryptox.ShortBufferException;
import com.initech.provider.crypto.InitechProvider;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.SecretKey;

public class KeyAgreement {
    private KeyAgreementSpi keyAgreementSpi;
    private Provider provider;
    private String algorithm;
    private boolean isInit;

    protected KeyAgreement(KeyAgreementSpi keyAgreementSpi, Provider provider, String algorithm) {
        this.keyAgreementSpi = keyAgreementSpi;
        this.provider = provider;
        this.algorithm = algorithm;
        this.isInit = false;
    }

    public static final KeyAgreement getInstance(String algorithm) throws NoSuchAlgorithmException {
        Provider[] providers = Security.getProviders();
        for (int i = 0; i < providers.length; ++i) {
            try {
                String className = providers[i].getProperty("KeyAgreement." + algorithm);
                KeyAgreementSpi spi = (KeyAgreementSpi)Class.forName(className).newInstance();
                return new KeyAgreement(spi, providers[i], algorithm);
            }
            catch (Exception e) {
                continue;
            }
        }
        throw new NoSuchAlgorithmException("No Such KeyAgreement algorithm");
    }

    public static final KeyAgreement getInstance(String algorithm, String provider) throws NoSuchAlgorithmException, NoSuchProviderException {
        Provider prov = InitechProvider.checkProviderObject(provider);
        if (prov == null) {
            throw new NoSuchProviderException("No Such Provider");
        }
        try {
            String className = prov.getProperty("KeyAgreement." + algorithm);
            KeyAgreementSpi spi = (KeyAgreementSpi)Class.forName(className).newInstance();
            return new KeyAgreement(spi, prov, algorithm);
        }
        catch (Exception e) {
            throw new NoSuchAlgorithmException("No Such KeyAgreement algorithm");
        }
    }

    public final Provider getProvider() {
        return this.provider;
    }

    public final String getAlgorithm() {
        return this.algorithm;
    }

    public final void init(Key key) throws InvalidKeyException {
        this.isInit = true;
        this.keyAgreementSpi.engineInit(key, new SecureRandom());
    }

    public final void init(Key key, SecureRandom random) throws InvalidKeyException {
        this.isInit = true;
        this.keyAgreementSpi.engineInit(key, random);
    }

    public final void init(Key key, AlgorithmParameterSpec params) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.isInit = true;
        this.keyAgreementSpi.engineInit(key, params, new SecureRandom());
    }

    public final void init(Key key, AlgorithmParameterSpec params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.isInit = true;
        this.keyAgreementSpi.engineInit(key, params, random);
    }

    public final Key doPhase(Key key, boolean lastPhase) throws InvalidKeyException, IllegalStateException {
        if (!this.isInit) {
            throw new IllegalStateException("KeyAgreement is not initialized");
        }
        return this.keyAgreementSpi.engineDoPhase(key, lastPhase);
    }

    public final byte[] generateSecret() throws IllegalStateException {
        if (!this.isInit) {
            throw new IllegalStateException("KeyAgreement is not initialized");
        }
        return this.keyAgreementSpi.engineGenerateSecret();
    }

    public final int generateSecret(byte[] sharedSecret, int offset) throws IllegalStateException, ShortBufferException {
        if (!this.isInit) {
            throw new IllegalStateException("KeyAgreement is not initialized");
        }
        return this.keyAgreementSpi.engineGenerateSecret(sharedSecret, offset);
    }

    public final SecretKey generateSecret(String algorithm) throws IllegalStateException, NoSuchAlgorithmException, InvalidKeyException {
        if (!this.isInit) {
            throw new IllegalStateException("KeyAgreement is not initialized");
        }
        return this.keyAgreementSpi.engineGenerateSecret(algorithm);
    }
}

