/*
 * Decompiled with CFR 0.152.
 */
package com.initech.cryptox;

import com.initech.cryptox.KeyGeneratorSpi;
import com.initech.provider.crypto.InitechProvider;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.SecretKey;

public class KeyGenerator {
    private KeyGeneratorSpi keyGeneratorSpi;
    private Provider provider;
    private String algorithm;
    private boolean isInit;

    protected KeyGenerator(KeyGeneratorSpi keyGeneratorSpi, Provider provider, String algorithm) {
        this.keyGeneratorSpi = keyGeneratorSpi;
        this.provider = provider;
        this.algorithm = algorithm;
        this.isInit = false;
    }

    public static final KeyGenerator getInstance(String algorithm) throws NoSuchAlgorithmException {
        Provider[] providers = Security.getProviders();
        for (int i = 0; i < providers.length; ++i) {
            try {
                KeyGeneratorSpi spi = (KeyGeneratorSpi)InitechProvider.getImplementation(algorithm, "KeyGenerator", providers[i]);
                return new KeyGenerator(spi, providers[i], algorithm);
            }
            catch (Exception e) {
                continue;
            }
        }
        throw new NoSuchAlgorithmException("No Such KeyGenerator algorithm");
    }

    public static final KeyGenerator getInstance(String algorithm, String provider) throws NoSuchAlgorithmException, NoSuchProviderException {
        Provider prov = InitechProvider.checkProviderObject(provider);
        if (prov == null) {
            throw new NoSuchProviderException("No Such Provider");
        }
        try {
            KeyGeneratorSpi spi = (KeyGeneratorSpi)InitechProvider.getImplementation(algorithm, "KeyGenerator", prov);
            return new KeyGenerator(spi, prov, algorithm);
        }
        catch (Exception e) {
            throw new NoSuchAlgorithmException("No Such KeyGenerotar algorithm");
        }
    }

    public final Provider getProvider() {
        return this.provider;
    }

    public final String getAlgorithm() {
        return this.algorithm;
    }

    public final void init(SecureRandom random) {
        this.keyGeneratorSpi.engineInit(random);
        this.isInit = true;
    }

    public final void init(AlgorithmParameterSpec params) throws InvalidAlgorithmParameterException {
        this.keyGeneratorSpi.engineInit(params, new SecureRandom());
        this.isInit = true;
    }

    public final void init(AlgorithmParameterSpec params, SecureRandom random) throws InvalidAlgorithmParameterException {
        this.keyGeneratorSpi.engineInit(params, random);
        this.isInit = true;
    }

    public final void init(int keysize) {
        this.keyGeneratorSpi.engineInit(keysize, new SecureRandom());
        this.isInit = true;
    }

    public final void init(int keysize, SecureRandom random) {
        this.keyGeneratorSpi.engineInit(keysize, random);
        this.isInit = true;
    }

    public final SecretKey generateKey() {
        return this.keyGeneratorSpi.engineGenerateKey();
    }
}

