/*
 * Decompiled with CFR 0.152.
 */
package com.initech.cryptox;

import com.initech.cryptox.SecureRandom;
import com.initech.cryptox.Zeroizable;
import com.initech.provider.crypto.InitechProvider;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.spec.AlgorithmParameterSpec;

public abstract class KeyPairGenerator
extends java.security.KeyPairGenerator
implements Zeroizable {
    protected KeyPairGenerator(String algorithm) {
        super(algorithm);
    }

    public void initialize(int keysize) {
        SecureRandom random = null;
        try {
            random = SecureRandom.getInstance("HASHDRBGSHA256", InitechProvider.NAME);
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (NoSuchProviderException e) {
            e.printStackTrace();
        }
        this._initialize(keysize, (java.security.SecureRandom)random);
    }

    public void initialize(int keysize, java.security.SecureRandom random) {
        this._initialize(keysize, random);
    }

    public void initialize(int keysize, String hashAlg) {
        SecureRandom random = null;
        try {
            random = SecureRandom.getInstance("HASHDRBG" + hashAlg, InitechProvider.NAME);
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (NoSuchProviderException e) {
            e.printStackTrace();
        }
        this._initialize(keysize, random);
    }

    public void zeroize() {
        this.engineZeroize();
    }

    protected abstract void _initialize(int var1, java.security.SecureRandom var2);

    public void initialize(AlgorithmParameterSpec params, java.security.SecureRandom random) throws InvalidAlgorithmParameterException {
        this._initialize(params, random);
    }

    protected void _initialize(AlgorithmParameterSpec params, java.security.SecureRandom random) throws InvalidAlgorithmParameterException {
        super.initialize(params, random);
    }

    public KeyPair generateKeyPair() {
        return this._generateKeyPair();
    }

    protected abstract KeyPair _generateKeyPair();

    protected abstract void engineZeroize();
}

