/*
 * Decompiled with CFR 0.152.
 */
package com.initech.cryptox;

import com.initech.cryptox.MacSpi;
import com.initech.cryptox.ShortBufferException;
import com.initech.provider.crypto.InitechProvider;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;
import java.security.spec.AlgorithmParameterSpec;

public class Mac {
    private MacSpi macSpi;
    private Provider provider;
    private String algorithm;
    private boolean isInit;

    protected Mac(MacSpi macSpi, Provider provider, String algorithm) {
        this.macSpi = macSpi;
        this.provider = provider;
        this.algorithm = algorithm;
        this.isInit = false;
    }

    public static final Mac getInstance(String algorithm) throws NoSuchAlgorithmException {
        Provider[] providers = Security.getProviders();
        for (int i = 0; i < providers.length; ++i) {
            try {
                String className = providers[i].getProperty("Mac." + algorithm);
                MacSpi spi = (MacSpi)Class.forName(className).newInstance();
                return new Mac(spi, providers[i], algorithm);
            }
            catch (Exception e) {
                continue;
            }
        }
        throw new NoSuchAlgorithmException("No Such Mac algorithm : " + algorithm);
    }

    public static final Mac getInstance(String algorithm, String provider) throws NoSuchAlgorithmException, NoSuchProviderException {
        Provider prov = InitechProvider.checkProviderObject(provider);
        if (prov == null) {
            throw new NoSuchProviderException("No Such Provider");
        }
        try {
            String className = prov.getProperty("Mac." + algorithm);
            MacSpi spi = (MacSpi)Class.forName(className).newInstance();
            return new Mac(spi, prov, algorithm);
        }
        catch (Exception e) {
            throw new NoSuchAlgorithmException("No Such Mac algorithm");
        }
    }

    public final Provider getProvider() {
        return this.provider;
    }

    public final String getAlgorithm() {
        return this.algorithm;
    }

    public final void init(Key key) throws InvalidKeyException {
        try {
            this.macSpi.engineInit(key, null);
            this.isInit = true;
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new InvalidKeyException("Mac need some parameter:" + e.toString());
        }
    }

    public final void init(Key key, AlgorithmParameterSpec params) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.macSpi.engineInit(key, params);
        this.isInit = true;
    }

    public final void update(byte input) throws IllegalStateException {
        if (!this.isInit) {
            throw new IllegalStateException("Mac is not initialized");
        }
        this.macSpi.engineUpdate(input);
    }

    public final void update(byte[] input) throws IllegalStateException {
        if (!this.isInit) {
            throw new IllegalStateException("Mac is not initialized");
        }
        if (input == null) {
            throw new IllegalArgumentException("input is null");
        }
        this.macSpi.engineUpdate(input, 0, input.length);
    }

    public final void update(byte[] input, int offset, int len) throws IllegalStateException {
        if (!this.isInit) {
            throw new IllegalStateException("Mac is not initialized");
        }
        if (offset + len > input.length) {
            throw new IllegalArgumentException("length is too long");
        }
        if (input == null) {
            throw new IllegalArgumentException("input is null");
        }
        if (len < 0) {
            throw new IllegalArgumentException("length is negative");
        }
        if (offset < 0) {
            throw new IllegalArgumentException("offset is negative");
        }
        this.macSpi.engineUpdate(input, offset, len);
    }

    public final byte[] doFinal() throws IllegalStateException {
        if (!this.isInit) {
            throw new IllegalStateException("Mac is not initialized");
        }
        return this.macSpi.engineDoFinal();
    }

    public final void doFinal(byte[] output, int outOffset) throws IllegalStateException, ShortBufferException {
        if (!this.isInit) {
            throw new IllegalStateException("Mac is not initialized");
        }
        if (outOffset < 0) {
            throw new IllegalArgumentException("offset is negative");
        }
        if (output == null) {
            throw new IllegalArgumentException("output is null");
        }
        byte[] temp = this.macSpi.engineDoFinal();
        if (output.length < outOffset + temp.length) {
            throw new ShortBufferException("output is too small");
        }
        System.arraycopy(temp, 0, output, outOffset, temp.length);
    }

    public final byte[] doFinal(byte[] input) throws IllegalStateException {
        if (!this.isInit) {
            throw new IllegalStateException("Mac is not initialized");
        }
        if (input.length <= 0) {
            throw new IllegalArgumentException("length is too long");
        }
        if (input == null) {
            throw new IllegalArgumentException("input is null");
        }
        this.macSpi.engineUpdate(input, 0, input.length);
        return this.macSpi.engineDoFinal();
    }

    public final void reset() {
        this.macSpi.engineReset();
    }

    public final Object clone() throws CloneNotSupportedException {
        if (this.macSpi instanceof Cloneable) {
            return new Mac((MacSpi)this.macSpi.clone(), this.provider, this.algorithm);
        }
        throw new CloneNotSupportedException();
    }

    public final int getMacLength() {
        return this.macSpi.engineGetMacLength();
    }
}

