/*
 * Decompiled with CFR 0.152.
 */
package com.initech.cryptox;

import com.initech.cryptox.BadPaddingException;
import com.initech.cryptox.Cipher;
import com.initech.cryptox.CipherSpi;
import com.initech.cryptox.IllegalBlockSizeException;
import com.initech.cryptox.NoSuchPaddingException;
import com.initech.cryptox.ShortBufferException;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;

public class NullCipher
extends Cipher {
    private static NullCipherSpi spi = new NullCipherSpi();
    private static Provider provider = null;
    private static String transformation = "";

    public NullCipher() {
        super(spi, provider, transformation);
    }

    private static class NullCipherSpi
    extends CipherSpi {
        public void _engineSetMode(String mode) throws NoSuchAlgorithmException {
        }

        public void _engineSetPadding(String padding) throws NoSuchPaddingException {
        }

        protected int _engineGetBlockSize() {
            return 1;
        }

        protected int _engineGetOutputSize(int inputLen) {
            return inputLen;
        }

        protected byte[] _engineGetIV() {
            return null;
        }

        protected void _engineInit(int opmode, Key key, SecureRandom random) throws InvalidKeyException {
        }

        protected void _engineInit(int opmode, Key key, AlgorithmParameterSpec params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        }

        protected void _engineInit(int opmode, Key key, AlgorithmParameters params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        }

        protected AlgorithmParameters _engineGetParameters() {
            return null;
        }

        protected byte[] _engineUpdate(byte[] in, int inOff, int inLen) {
            byte[] result = new byte[inLen];
            System.arraycopy(in, inOff, result, 0, inLen);
            return result;
        }

        protected int _engineUpdate(byte[] in, int inOff, int inLen, byte[] out, int outOff) throws ShortBufferException {
            if (out.length - outOff < inLen) {
                throw new ShortBufferException("output buffer too short.");
            }
            System.arraycopy(in, inOff, out, outOff, inLen);
            return inLen;
        }

        protected byte[] _engineDoFinal(byte[] input, int inputOffset, int inputLen) throws IllegalBlockSizeException, BadPaddingException {
            if (input != null) {
                return this._engineUpdate(input, inputOffset, inputLen);
            }
            return null;
        }

        protected int _engineDoFinal(byte[] in, int inOff, int inLen, byte[] out, int outOff) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
            if (in != null) {
                return this._engineUpdate(in, inOff, inLen, out, outOff);
            }
            return 0;
        }
    }
}

