/*
 * Decompiled with CFR 0.152.
 */
package com.initech.cryptox;

import com.initech.cryptox.IllegalBlockSizeException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OptionalDataException;
import java.io.Serializable;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;

public class SealedObject
implements Serializable {
    private static final long serialVersionUID = 7752987314528078777L;
    private byte[] encryptedObject;
    private byte[] params;
    private String encryptAlgorithm;
    private String paramsAlgorithm;

    public SealedObject(Serializable object, Cipher c) throws IOException, IllegalBlockSizeException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(object);
        oos.close();
        try {
            this.encryptedObject = c.doFinal(baos.toByteArray());
        }
        catch (BadPaddingException e) {
            throw new IllegalArgumentException("cipher object is not properly initialized");
        }
        catch (javax.crypto.IllegalBlockSizeException ie) {
            throw new IllegalBlockSizeException("cipher object is not properly initialized");
        }
        this.encryptAlgorithm = c.getAlgorithm();
        AlgorithmParameters algs = c.getParameters();
        if (algs != null) {
            this.encryptAlgorithm = algs.getAlgorithm();
            this.params = algs.getEncoded();
        }
    }

    public final String getAlgorithm() {
        return this.encryptAlgorithm;
    }

    public final Object getObject(Cipher c) throws IOException, ClassNotFoundException, IllegalBlockSizeException, BadPaddingException {
        Object obj;
        try {
            byte[] decryptedObject = c.doFinal(this.encryptedObject);
            ByteArrayInputStream bais = new ByteArrayInputStream(decryptedObject);
            ObjectInputStream ois = new ObjectInputStream(bais);
            obj = ois.readObject();
        }
        catch (OptionalDataException e) {
            throw new IOException("this data is not Object but primitive data");
        }
        catch (javax.crypto.IllegalBlockSizeException ibse) {
            throw new IllegalBlockSizeException();
        }
        return obj;
    }

    public final Object getObject(Key key) throws IOException, ClassNotFoundException, NoSuchAlgorithmException, InvalidKeyException {
        Object obj;
        byte[] decryptedObject;
        Cipher c;
        AlgorithmParameters aps = AlgorithmParameters.getInstance(this.paramsAlgorithm);
        aps.init(this.params);
        try {
            c = Cipher.getInstance(this.encryptAlgorithm);
        }
        catch (NoSuchPaddingException e) {
            throw new IOException("not given form.");
        }
        try {
            c.init(2, key, aps);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new IOException("invalid algorithm parameter exception" + e.toString());
        }
        try {
            decryptedObject = c.doFinal(this.encryptedObject);
        }
        catch (BadPaddingException e) {
            throw new IOException("not given form.");
        }
        catch (javax.crypto.IllegalBlockSizeException e) {
            throw new IOException("Illegal block size exception" + e.toString());
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(decryptedObject);
        ObjectInputStream ois = new ObjectInputStream(bais);
        try {
            obj = ois.readObject();
        }
        catch (OptionalDataException e) {
            throw new IOException("this data is not Object but primitive data");
        }
        return obj;
    }

    public final Object getObject(Key key, String provider) throws IOException, ClassNotFoundException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException {
        Object obj;
        byte[] decryptedObject;
        Cipher c;
        AlgorithmParameters aps = AlgorithmParameters.getInstance(this.paramsAlgorithm, provider);
        aps.init(this.params);
        try {
            c = Cipher.getInstance(this.encryptAlgorithm, provider);
        }
        catch (NoSuchPaddingException e) {
            throw new IOException("not given form.");
        }
        try {
            c.init(2, key, aps);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new IOException("invalid algorithm parameter exception" + e.toString());
        }
        try {
            decryptedObject = c.doFinal(this.encryptedObject);
        }
        catch (BadPaddingException e) {
            throw new IOException("not given form.");
        }
        catch (javax.crypto.IllegalBlockSizeException e) {
            throw new IOException("Illegal block size exception" + e.toString());
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(decryptedObject);
        ObjectInputStream ois = new ObjectInputStream(bais);
        try {
            obj = ois.readObject();
        }
        catch (OptionalDataException e) {
            throw new IOException("this data is not Object but primitive data");
        }
        return obj;
    }
}

