/*
 * Decompiled with CFR 0.152.
 */
package com.initech.cryptox;

import com.initech.cryptox.SecretKey;
import com.initech.cryptox.SecretKeyFactorySpi;
import com.initech.provider.crypto.InitechProvider;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;

public class SecretKeyFactory {
    private SecretKeyFactorySpi secretKeyFactorySpi;
    private String algorithm;
    private Provider provider;

    protected SecretKeyFactory(SecretKeyFactorySpi secretKeyFactorySpi, Provider provider, String algorithm) {
        this.secretKeyFactorySpi = secretKeyFactorySpi;
        this.algorithm = algorithm;
        this.provider = provider;
    }

    public static final SecretKeyFactory getInstance(String algorithm) throws NoSuchAlgorithmException {
        Provider[] providers = Security.getProviders();
        for (int i = 0; i < providers.length; ++i) {
            try {
                SecretKeyFactorySpi spi = (SecretKeyFactorySpi)InitechProvider.getImplementation(algorithm, "SecretKeyFactory", providers[i]);
                return new SecretKeyFactory(spi, providers[i], algorithm);
            }
            catch (Exception e) {
                continue;
            }
        }
        throw new NoSuchAlgorithmException("No Such SecretKeyFactory algorithm: " + algorithm);
    }

    public static final SecretKeyFactory getInstance(String algorithm, String provider) throws NoSuchAlgorithmException, NoSuchProviderException {
        Provider prov = InitechProvider.checkProviderObject(provider);
        if (prov == null) {
            throw new NoSuchProviderException("No Such Provider");
        }
        try {
            SecretKeyFactorySpi spi = (SecretKeyFactorySpi)InitechProvider.getImplementation(algorithm, "SecretKeyFactory", prov);
            return new SecretKeyFactory(spi, prov, algorithm);
        }
        catch (Exception e) {
            throw new NoSuchAlgorithmException("No Such SecretKeyFactory algorithm: " + algorithm);
        }
    }

    public final Provider getProvider() {
        return this.provider;
    }

    public final String getAlgorithm() {
        return this.algorithm;
    }

    public final SecretKey generateSecret(KeySpec keySpec) throws InvalidKeySpecException {
        return this.secretKeyFactorySpi.engineGenerateSecretX(keySpec);
    }

    public final KeySpec getKeySpec(SecretKey key, Class keySpec) throws InvalidKeySpecException {
        return this.secretKeyFactorySpi.engineGetKeySpec((javax.crypto.SecretKey)key, keySpec);
    }

    public final SecretKey translateKey(SecretKey key) throws InvalidKeyException {
        return this.secretKeyFactorySpi.engineTranslateKeyX(key);
    }
}

