/*
 * Decompiled with CFR 0.152.
 */
package com.initech.cryptox;

import com.initech.cryptox.Zeroizable;
import com.initech.provider.crypto.InitechProvider;
import com.initech.provider.crypto.random.HashDRBG;
import java.lang.reflect.InvocationTargetException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;

public class SecureRandom
extends java.security.SecureRandom
implements Zeroizable {
    private static final long serialVersionUID = 7478643826949304864L;
    private HashDRBG secureRandomSpi = null;

    private SecureRandom(String algorithm, Provider provider, HashDRBG spi) throws ClassNotFoundException, SecurityException, NoSuchMethodException, IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException {
        super(spi, provider);
        this.secureRandomSpi = spi;
    }

    public static SecureRandom getInstance(String algorithm) throws NoSuchAlgorithmException {
        Provider provider = Security.getProvider(InitechProvider.NAME);
        return SecureRandom.getInstance(algorithm, provider);
    }

    public static SecureRandom getInstance(String algorithm, String provider) throws NoSuchAlgorithmException, NoSuchProviderException {
        Provider pr = Security.getProvider(provider);
        return SecureRandom.getInstance(algorithm, pr);
    }

    public static SecureRandom getInstance(String algorithm, Provider provider) throws NoSuchAlgorithmException {
        try {
            HashDRBG spi = (HashDRBG)Class.forName("com.initech.provider.crypto.random." + algorithm).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            return new SecureRandom(algorithm, provider, spi);
        }
        catch (Exception e) {
            throw new NoSuchAlgorithmException(e.getMessage());
        }
    }

    public void zeroize() {
        if (this.secureRandomSpi != null) {
            this.secureRandomSpi.zeroize();
        }
    }
}

