/*
 * Decompiled with CFR 0.152.
 */
package com.initech.cryptox.util;

import com.initech.cryptox.util.StringUtil;
import java.io.PrintWriter;

public class Hex {
    private static final char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public static String dumpHex(byte hex) {
        char[] hexChar = new char[]{hexDigits[hex >>> 4 & 0xF], hexDigits[hex & 0xF]};
        return new String(hexChar);
    }

    public static void appendHex(byte hex, StringBuffer str) {
        str.append(hexDigits[hex >>> 4 & 0xF]);
        str.append(hexDigits[hex & 0xF]);
    }

    public static void dumpHex(StringBuffer strBuffer, byte[] byteArray, int offset, int length, char separator) {
        if (byteArray == null || byteArray.length == 0) {
            return;
        }
        for (int i = offset; i < offset + length; ++i) {
            Hex.appendHex(byteArray[i], strBuffer);
            if (separator == '\u0000' || i == offset + length - 1) continue;
            strBuffer.append(separator);
        }
    }

    public static void prettyDump(StringBuffer sb, byte[] byteArray, int offset, int length, int column, char separator, int indent) {
        int blockSize = separator == '\u0000' ? column / 2 : column / 3;
        int leftOvers = length % blockSize;
        int lastBlockOffset = length - leftOvers;
        for (int i = 0; i < lastBlockOffset; i += blockSize) {
            if (indent > 0) {
                StringUtil.indent(sb, indent);
            }
            Hex.dumpHex(sb, byteArray, offset + i, blockSize, separator);
            sb.append("\n");
        }
        if (indent > 0) {
            StringUtil.indent(sb, indent);
        }
        Hex.dumpHex(sb, byteArray, lastBlockOffset, leftOvers, separator);
    }

    public static void prettyDump(StringBuffer sb, byte[] byteArray, int offset, int length, int column, char separator) {
        Hex.prettyDump(sb, byteArray, offset, length, column, separator, 0);
    }

    public static String dumpHex(byte[] byteArray, int offset, int length, char separator) {
        StringBuffer sb = new StringBuffer();
        Hex.dumpHex(sb, byteArray, offset, length, separator);
        return sb.toString();
    }

    public static String dumpHex(byte[] byteArray, char separator) {
        return Hex.dumpHex(byteArray, 0, byteArray.length, separator);
    }

    public static String dumpHex(byte[] byteArray) {
        return Hex.dumpHex(byteArray, '\u0000');
    }

    public static String prettyDump(byte[] byteArray, int offset, int length, int column, char separator, int indent) {
        StringBuffer sb = new StringBuffer();
        Hex.prettyDump(sb, byteArray, offset, length, column, separator, indent);
        return sb.toString();
    }

    public static String prettyDump(byte[] byteArray, int offset, int length, int column, char separator) {
        StringBuffer sb = new StringBuffer();
        Hex.prettyDump(sb, byteArray, offset, length, column, separator, 0);
        return sb.toString();
    }

    public static String prettyDump(byte[] byteArray, int column, char separator, int indent) {
        return Hex.prettyDump(byteArray, 0, byteArray.length, column, separator, indent);
    }

    public static String prettyDump(byte[] byteArray, int column, char separator) {
        return Hex.prettyDump(byteArray, 0, byteArray.length, column, separator, 0);
    }

    public static String prettyDump(byte[] byteArray) {
        return Hex.prettyDump(byteArray, 0, byteArray.length, 80, '\u0000');
    }

    public static void dumpHex(PrintWriter out, byte[] byteArray) {
        out.print(Hex.prettyDump(byteArray));
    }

    public static byte[] parseHexaString(String hexString) {
        int i;
        StringBuffer sb = new StringBuffer();
        for (i = 0; i < hexString.length(); ++i) {
            char current = hexString.charAt(i);
            if (!('0' <= current && current <= '9' || 'A' <= current && current <= 'F') && ('a' > current || current > 'f')) continue;
            sb.append(current);
        }
        int leftover = sb.length() % 2;
        byte[] ret = new byte[sb.length() / 2 + leftover];
        if (leftover == 1) {
            ret[0] = Hex.parseHexaCharactor(sb.charAt(0));
            for (i = 0; i < sb.length() / 2; ++i) {
                ret[i + 1] = (byte)(Hex.parseHexaCharactor(sb.charAt(2 * i + 1)) << 4 | Hex.parseHexaCharactor(sb.charAt(2 * i + 2)));
            }
        } else {
            for (i = 0; i < sb.length() / 2; ++i) {
                ret[i] = (byte)(Hex.parseHexaCharactor(sb.charAt(2 * i)) << 4 | Hex.parseHexaCharactor(sb.charAt(2 * i + 1)));
            }
        }
        return ret;
    }

    private static byte parseHexaCharactor(char ch) {
        if ('0' <= ch && ch <= '9') {
            return (byte)(ch - 48);
        }
        if ('A' <= ch && ch <= 'F') {
            return (byte)(ch - 55);
        }
        if ('a' <= ch && ch <= 'f') {
            return (byte)(ch - 87);
        }
        return 0;
    }

    public static byte[] removeZero(byte[] inHex) {
        if (inHex[0] == 0 && (inHex[1] & 0xFFFFFF80) != 0) {
            byte[] outHex = new byte[inHex.length - 1];
            System.arraycopy(inHex, 1, outHex, 0, outHex.length);
            return outHex;
        }
        return inHex;
    }

    public static final byte[] longToByteArray(long lba) {
        byte[] retVal = new byte[8];
        for (int i = 0; i < 8; ++i) {
            retVal[i] = (byte)lba;
            lba >>= 8;
        }
        return retVal;
    }

    public static byte[] hexToByteArray(String hex) {
        if (hex == null || hex.length() == 0) {
            return null;
        }
        byte[] ba = new byte[hex.length() / 2];
        for (int i = 0; i < ba.length; ++i) {
            ba[i] = (byte)Integer.parseInt(hex.substring(2 * i, 2 * i + 2), 16);
        }
        return ba;
    }

    public static String byteArrayToHex(byte[] ba) {
        if (ba == null || ba.length == 0) {
            return null;
        }
        StringBuffer sb = new StringBuffer(ba.length * 2);
        for (int x = 0; x < ba.length; ++x) {
            String hexNumber = "0" + Integer.toHexString(0xFF & ba[x]);
            sb.append(hexNumber.substring(hexNumber.length() - 2));
        }
        return sb.toString();
    }

    public static String byteArrayToCapHex(byte[] a) {
        StringBuilder sb = new StringBuilder();
        for (byte b : a) {
            sb.append(String.format("%02X", b & 0xFF));
        }
        return sb.toString();
    }
}

