/*
 * Decompiled with CFR 0.152.
 */
package com.initech.cryptox.util;

import com.initech.cryptox.util.Base64Util;
import java.io.BufferedReader;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

public class PEMInputStream
extends FilterInputStream {
    private String header;
    private byte[] footer;
    private boolean hasHeader;
    private byte[] inbuf = new byte[4];
    private byte[] outbuf = new byte[3];
    private int obPos = -1;
    private int nextPos = -1;
    private BufferedReader br;

    public PEMInputStream(InputStream input, String head) throws IOException {
        super(input);
        String inputLine;
        this.header = new String("-----BEGIN " + head + "-----");
        this.footer = new String("-----END " + head + "-----").getBytes();
        this.br = new BufferedReader(new InputStreamReader(this.in, "ISO8859_1"));
        do {
            if ((inputLine = this.br.readLine()) != null) continue;
            throw new IOException("too short data");
        } while (!inputLine.equals(this.header));
    }

    public PEMInputStream(InputStream input) throws IOException {
        super(input);
    }

    public int read() throws IOException {
        if (0 <= this.nextPos && this.nextPos <= 2 && this.nextPos < this.obPos) {
            return this.outbuf[this.nextPos++] & 0xFF;
        }
        if (this.obPos == 0) {
            return -1;
        }
        this.obPos = 0;
        this.nextPos = 0;
        int count = 0;
        while (count < 4) {
            int t = this.br.read();
            if (t == -1) {
                if (count <= 0) break;
                throw new IOException("Unexpected end of data encountered");
            }
            if (this.footer != null && t == this.footer[0]) {
                if (count > 0) {
                    throw new IOException("Unexpected end of data encountered");
                }
                this.br.skip(this.footer.length - 1);
                return -1;
            }
            if (43 > t || t > 122) continue;
            this.inbuf[count++] = (byte)t;
        }
        this.obPos = Base64Util.decodeBlock(this.inbuf, this.outbuf);
        return this.outbuf[this.nextPos++] & 0xFF;
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    public int read(byte[] b, int off, int len) throws IOException {
        for (int i = off; i < off + len; ++i) {
            int t = this.read();
            if (t == -1) {
                if (i == off) {
                    return -1;
                }
                return i - off;
            }
            b[i] = (byte)(t & 0xFF);
        }
        return len;
    }

    public long skip(long n) throws IOException {
        int t;
        long i = 0L;
        for (i = 0L; i < n && (t = this.br.read()) != -1; ++i) {
        }
        return i;
    }

    public int available() throws IOException {
        return 0;
    }

    public void close() throws IOException {
        super.close();
        this.obPos = 0;
    }
}

