/*
 * Decompiled with CFR 0.152.
 */
package com.initech.cryptox.util;

import com.initech.cryptox.util.Base64Util;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class PEMOutputStream
extends FilterOutputStream {
    private byte[] header;
    private byte[] footer;
    private byte[] outbuf = new byte[4];
    private byte[] inbuf = new byte[3];
    private int inbufPos = 0;
    private int chrCnt = 0;

    public PEMOutputStream(OutputStream output, String head) throws IOException {
        super(output);
        String t = new String("-----BEGIN " + head + "-----\n");
        this.header = t.getBytes();
        t = new String("-----END " + head + "-----\n");
        this.footer = t.getBytes();
        output.write(this.header);
    }

    public PEMOutputStream(OutputStream output) throws IOException {
        super(output);
    }

    public void write(int b) throws IOException {
        this.inbuf[this.inbufPos] = (byte)(b & 0xFF);
        ++this.inbufPos;
        if (this.inbufPos >= this.inbuf.length) {
            Base64Util.encodeBlock(this.inbuf, 4, this.outbuf);
            this.out.write(this.outbuf, 0, 4);
            this.chrCnt += 4;
            this.inbufPos = 0;
            if (this.chrCnt == 64) {
                this.out.write(10);
                this.chrCnt = 0;
            }
        }
    }

    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        for (int i = off; i < off + len; ++i) {
            this.write(b[i]);
        }
    }

    public void flush() throws IOException {
        if (this.inbufPos > 0) {
            Base64Util.encodeBlock(this.inbuf, this.inbufPos, this.outbuf);
            this.out.write(this.outbuf, 0, 4);
        }
        this.out.write(10);
        if (this.footer != null) {
            this.out.write(this.footer);
            this.footer = null;
        }
    }

    public void close() throws IOException {
        super.close();
        this.inbufPos = 0;
    }
}

