/*
 * Decompiled with CFR 0.152.
 */
package com.initech.pkcs.pkcs8;

import com.initech.asn1.ASN1Decoder;
import com.initech.asn1.ASN1Encoder;
import com.initech.asn1.ASN1Exception;
import com.initech.asn1.BERDecoder;
import com.initech.asn1.DEREncoder;
import com.initech.asn1.useful.ASN1Object;
import com.initech.asn1.useful.AlgorithmID;
import com.initech.cryptox.Cipher;
import com.initech.cryptox.SecretKey;
import com.initech.cryptox.SecretKeyFactory;
import com.initech.cryptox.spec.PBEKeySpec;
import com.initech.cryptox.spec.PBEParameterSpec;
import com.initech.pkcs.pkcs8.PrivateKeyInfo;
import com.initech.pkcs.pkcs8.spec.EnhancedPKCS8EncodedKeySpec;
import com.initech.provider.AutoJCE;
import com.initech.provider.crypto.InitechProvider;
import com.initech.provider.crypto.cipher.PEOBEParameterData;
import com.initech.provider.crypto.spec.PBES2ParameterSpec;
import com.initech.provider.pkcs.pkcs5.PBEKey;
import com.initech.provider.pkcs.pkcs5.PBES2Data;
import java.io.IOException;
import java.io.InputStream;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.InvalidParameterSpecException;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;

public class EncryptedPrivateKeyInfo
extends ASN1Object {
    private static final long serialVersionUID = 4931012182893653117L;
    private AlgorithmID encryptionAlgorithm = new AlgorithmID();
    private byte[] encryptedData;
    private PrivateKeyInfo pkinfo;

    public EncryptedPrivateKeyInfo() {
    }

    public EncryptedPrivateKeyInfo(InputStream inStream) throws ASN1Exception {
        BERDecoder dec = new BERDecoder(inStream);
        this.decode(dec);
        this.modified = true;
    }

    public EncryptedPrivateKeyInfo(byte[] data) throws ASN1Exception {
        BERDecoder dec = new BERDecoder(data);
        this.decode(dec);
        this.encoded = (byte[])data.clone();
        this.modified = false;
    }

    public EncryptedPrivateKeyInfo(PrivateKeyInfo pkinfo, javax.crypto.spec.PBEKeySpec pbeKeySpec_j, AlgorithmID algorithmID) throws NoSuchAlgorithmException, IOException, InvalidKeySpecException, NoSuchPaddingException, InvalidAlgorithmParameterException, InvalidKeyException, IllegalBlockSizeException, NoSuchProviderException, BadPaddingException, InvalidParameterSpecException {
        this(pkinfo, (PBEKeySpec)AutoJCE.toJCEX(pbeKeySpec_j), algorithmID);
    }

    public EncryptedPrivateKeyInfo(PrivateKeyInfo pkinfo, PBEKeySpec pbeKeySpec, AlgorithmID algorithmID) throws NoSuchAlgorithmException, IOException, InvalidKeySpecException, NoSuchPaddingException, InvalidAlgorithmParameterException, InvalidKeyException, IllegalBlockSizeException, NoSuchProviderException, BadPaddingException, InvalidParameterSpecException {
        this.pkinfo = pkinfo;
        this.encryptionAlgorithm = algorithmID;
        this.encrypt(this.pkinfo, pbeKeySpec, algorithmID);
    }

    public byte[] getEncryptedData() {
        return this.encryptedData;
    }

    public void setEncryptedData(byte[] encryptedData) {
        this.encryptedData = encryptedData;
    }

    public AlgorithmID getAlgorithmID() {
        return this.encryptionAlgorithm;
    }

    public void setAlgorithmID(AlgorithmID encryptionAlgorithm) {
        this.encryptionAlgorithm = encryptionAlgorithm;
    }

    protected byte[] encrypt(PrivateKeyInfo pkinfo, javax.crypto.spec.PBEKeySpec pbeKeySpec_j, AlgorithmID algorithmID) throws NoSuchAlgorithmException, IOException, InvalidKeySpecException, NoSuchPaddingException, InvalidAlgorithmParameterException, InvalidKeyException, InvalidParameterSpecException, BadPaddingException, IllegalBlockSizeException, NoSuchProviderException {
        PBEKeySpec pbeKeySpec = (PBEKeySpec)AutoJCE.toJCEX(pbeKeySpec_j);
        return this.encrypt(pkinfo, pbeKeySpec, algorithmID);
    }

    protected byte[] encrypt(PrivateKeyInfo pkinfo, PBEKeySpec pbeKeySpec, AlgorithmID algorithmID) throws NoSuchAlgorithmException, IOException, InvalidKeySpecException, NoSuchPaddingException, InvalidAlgorithmParameterException, InvalidKeyException, InvalidParameterSpecException, BadPaddingException, IllegalBlockSizeException, NoSuchProviderException, NoSuchPaddingException {
        byte[] dataToBeEncrypted;
        try {
            dataToBeEncrypted = pkinfo.getEncoded();
        }
        catch (ASN1Exception e) {
            throw new IOException(e.toString());
        }
        String cipherName = algorithmID.getAlgName();
        Cipher pbeCipher = Cipher.getInstance(cipherName, InitechProvider.NAME);
        SecretKeyFactory sKeyFactory = SecretKeyFactory.getInstance("PKCS5", InitechProvider.NAME);
        SecretKey pbeKey = sKeyFactory.generateSecret(pbeKeySpec);
        try {
            if (cipherName.equals("PBES2")) {
                PBES2Data pbes2asn1;
                try {
                    pbes2asn1 = new PBES2Data(algorithmID.getParameter());
                }
                catch (ASN1Exception e) {
                    throw new IOException(e.toString());
                }
                PBEParameterSpec kdfParams = new PBEParameterSpec(pbes2asn1.getSalt(), pbes2asn1.getIterationCount());
                AlgorithmID encryptionAlgorithm = pbes2asn1.getEncryptionScheme();
                String encAlgName = encryptionAlgorithm.getAlgName();
                AlgorithmParameters encAlgParam = AlgorithmParameters.getInstance(encAlgName, InitechProvider.NAME);
                encAlgParam.init(encryptionAlgorithm.getParameter());
                int keyLength = pbes2asn1.getKeyLength();
                if (keyLength == -1) {
                    if (encAlgName.equals("DEScbc")) {
                        keyLength = 8;
                    } else if (encAlgName.equals("DESedecbc")) {
                        keyLength = 24;
                    } else if (encAlgName.equals("SEEDcbc")) {
                        keyLength = 16;
                    } else if (encAlgName.equals("ARIAcbc")) {
                        keyLength = 16;
                    } else if (encAlgName.equals("Rijndaelcbc") || encAlgName.equals("AEScbc")) {
                        keyLength = 16;
                    } else {
                        throw new InvalidAlgorithmParameterException("Key Length needed");
                    }
                }
                PBES2ParameterSpec pbes2param = new PBES2ParameterSpec(kdfParams, encAlgName, keyLength, encAlgParam, pbes2asn1.getPRFAlgorithm().getAlgName());
                pbeCipher.init(1, (Key)pbeKey, pbes2param);
            } else {
                AlgorithmParameters algParam = AlgorithmParameters.getInstance("PBE", InitechProvider.NAME);
                if (cipherName.equals("PEOBEWithSHA1AndSeedcbc")) {
                    PEOBEParameterData peobeData = new PEOBEParameterData(algorithmID.getParameter());
                    PBEParameterSpec peobeSpec = new PBEParameterSpec(peobeData.getSalt(), peobeData.getIterationCount());
                    algParam.init(peobeSpec);
                } else {
                    byte[] encodedParameter = algorithmID.getParameter();
                    if (encodedParameter == null) {
                        // empty if block
                    }
                    algParam.init(encodedParameter);
                }
                PBEParameterSpec algParamSpec = algParam.getParameterSpec(PBEParameterSpec.class);
                pbeCipher.init(1, (Key)pbeKey, algParamSpec);
            }
            this.encryptedData = pbeCipher.doFinal(dataToBeEncrypted);
            PBEKey k = (PBEKey)pbeKey;
            k.zeroize();
            DEREncoder enc = new DEREncoder();
            try {
                int seqid = enc.encodeSequence();
                algorithmID.encode(enc);
                enc.encodeOctetString(this.encryptedData);
                enc.endOf(seqid);
                byte[] byArray = enc.toByteArray();
                return byArray;
            }
            catch (ASN1Exception e) {
                try {
                    throw new IOException(e.toString());
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                    throw new BadPaddingException("PrivateKey Decrypt Bad padding");
                }
            }
        }
        finally {
            PBEKey k = (PBEKey)pbeKey;
            k.zeroize();
        }
    }

    public PrivateKey decrypt(javax.crypto.spec.PBEKeySpec pbeKeySpec_j) throws NoSuchAlgorithmException, IOException, InvalidKeySpecException, NoSuchPaddingException, InvalidAlgorithmParameterException, InvalidKeyException, IllegalBlockSizeException, NoSuchProviderException, BadPaddingException, InvalidParameterSpecException, ASN1Exception {
        PBEKeySpec pbeKeySpec = (PBEKeySpec)AutoJCE.toJCEX(pbeKeySpec_j);
        return this.decrypt(pbeKeySpec);
    }

    public PrivateKey decrypt(PBEKeySpec pbeKeySpec) throws NoSuchAlgorithmException, IOException, InvalidKeySpecException, NoSuchPaddingException, InvalidAlgorithmParameterException, InvalidKeyException, IllegalBlockSizeException, NoSuchProviderException, BadPaddingException, InvalidParameterSpecException, ASN1Exception {
        String cipherName = this.encryptionAlgorithm.getAlgName();
        if (cipherName.equals("SEEDcbc")) {
            cipherName = "PBEWithSHA1AndSeedcbcKICA";
        }
        Cipher pbeCipher = Cipher.getInstance(cipherName, InitechProvider.NAME);
        SecretKeyFactory sKeyFactory = SecretKeyFactory.getInstance("PKCS5", InitechProvider.NAME);
        SecretKey pbeKey = sKeyFactory.generateSecret(pbeKeySpec);
        try {
            if (cipherName.equals("PBES2")) {
                PBES2Data pbes2asn1;
                try {
                    pbes2asn1 = new PBES2Data(this.encryptionAlgorithm.getParameter());
                }
                catch (ASN1Exception e) {
                    throw new IOException(e.toString());
                }
                PBEParameterSpec kdfParams = new PBEParameterSpec(pbes2asn1.getSalt(), pbes2asn1.getIterationCount());
                AlgorithmID encryptionAlgorithm = pbes2asn1.getEncryptionScheme();
                String encAlgName = encryptionAlgorithm.getAlgName();
                AlgorithmParameters encAlgParam = AlgorithmParameters.getInstance(encAlgName, InitechProvider.NAME);
                encAlgParam.init(encryptionAlgorithm.getParameter());
                int keyLength = pbes2asn1.getKeyLength();
                if (keyLength == -1) {
                    if (encAlgName.equals("DEScbc")) {
                        keyLength = 8;
                    } else if (encAlgName.equals("DESedecbc")) {
                        keyLength = 24;
                    } else if (encAlgName.equals("SEEDcbc")) {
                        keyLength = 16;
                    } else if (encAlgName.equals("ARIAcbc")) {
                        keyLength = 16;
                    } else if (encAlgName.equals("Rijndaelcbc") || encAlgName.equals("AEScbc")) {
                        keyLength = 16;
                    } else {
                        throw new InvalidAlgorithmParameterException("Key Length needed");
                    }
                }
                PBES2ParameterSpec pbes2param = new PBES2ParameterSpec(kdfParams, encAlgName, keyLength, encAlgParam, pbes2asn1.getPRFAlgorithm().getAlgName());
                pbeCipher.init(2, (Key)pbeKey, pbes2param);
            } else {
                AlgorithmParameters algParam = AlgorithmParameters.getInstance("PBE", InitechProvider.NAME);
                if (cipherName.equals("PEOBEWithSHA1AndSeedcbc")) {
                    PEOBEParameterData peobeData = new PEOBEParameterData(this.encryptionAlgorithm.getParameter());
                    PBEParameterSpec peobeSpec = new PBEParameterSpec(peobeData.getSalt(), peobeData.getIterationCount());
                    algParam.init(peobeSpec);
                } else {
                    byte[] encodedParameter = this.encryptionAlgorithm.getParameter();
                    if (encodedParameter == null) {
                        // empty if block
                    }
                    algParam.init(encodedParameter);
                }
                PBEParameterSpec algParamSpec = algParam.getParameterSpec(PBEParameterSpec.class);
                pbeCipher.init(2, (Key)pbeKey, algParamSpec);
            }
            byte[] pkcs8KeyData = pbeCipher.doFinal(this.encryptedData);
            PBEKey k = (PBEKey)pbeKey;
            k.zeroize();
            EnhancedPKCS8EncodedKeySpec epkcsspec = new EnhancedPKCS8EncodedKeySpec(pkcs8KeyData);
            KeyFactory kf = epkcsspec.getKeyFactory(InitechProvider.NAME);
            PrivateKey privateKey = kf.generatePrivate(epkcsspec);
            return privateKey;
        }
        catch (BadPaddingException e) {
            throw new BadPaddingException("BadPaddingException");
        }
        finally {
            PBEKey k = (PBEKey)pbeKey;
            k.zeroize();
        }
    }

    String getPrivateKeyAlg() {
        return this.pkinfo.getAlgorithm();
    }

    public void decode(ASN1Decoder dec) throws ASN1Exception {
        int id = dec.decodeSequence();
        this.encryptionAlgorithm.decode(dec);
        this.encryptedData = dec.decodeOctetString();
        dec.endOf(id);
    }

    public void encode(ASN1Encoder enc) throws ASN1Exception {
        AlgorithmID algId = this.encryptionAlgorithm;
        String algName = this.encryptionAlgorithm.getAlgName();
        String oid = this.encryptionAlgorithm.getAlg();
        int id = enc.encodeSequence();
        this.encryptionAlgorithm.encode(enc);
        enc.encodeOctetString(this.encryptedData);
        enc.endOf(id);
    }
}

