/*
 * Decompiled with CFR 0.152.
 */
package com.initech.pkcs.pkcs8;

import com.initech.asn1.ASN1Decoder;
import com.initech.asn1.ASN1Encoder;
import com.initech.asn1.ASN1Exception;
import com.initech.asn1.BERDecoder;
import com.initech.asn1.useful.ASN1Object;
import com.initech.asn1.useful.AlgorithmID;
import com.initech.cryptox.util.Hex;
import com.initech.pkcs.pkcs8.EncryptedPrivateKeyInfo;
import com.initech.provider.crypto.InitechProvider;
import com.initech.provider.crypto.cipher.PEOBEParameterData;
import java.security.MessageDigest;
import java.util.HashMap;

public class EncryptedPrivateKeyInfos
extends ASN1Object {
    private static final long serialVersionUID = -3834439410279857238L;
    private HashMap encryptedPriKeys = new HashMap();

    public EncryptedPrivateKeyInfos() {
    }

    public EncryptedPrivateKeyInfos(byte[] encPriKeys) throws Exception {
        this();
        try {
            BERDecoder dec = new BERDecoder(encPriKeys);
            this.decode(dec);
            this.encoded = encPriKeys;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Exception("EncryptedPrivateKeyInfo decode fail");
        }
    }

    private String generateMapId(byte[] pri) throws Exception {
        MessageDigest md = MessageDigest.getInstance("SHA256", InitechProvider.NAME);
        md.update(pri);
        byte[] mdVal = md.digest();
        return Hex.dumpHex(mdVal);
    }

    public synchronized void addEncryptedPrivateKeyInfo(EncryptedPrivateKeyInfo encPri) throws ASN1Exception, Exception {
        String keyId = this.generateMapId(encPri.getEncoded());
        this.encryptedPriKeys.put(keyId, encPri);
    }

    public synchronized void removeEncryptedPrivateKeyInfo(String keyId) {
        this.encryptedPriKeys.remove(keyId);
    }

    public HashMap getObjectNames() {
        HashMap<String, String> objList = new HashMap<String, String>();
        for (String keyId : this.encryptedPriKeys.keySet()) {
            EncryptedPrivateKeyInfo encPriExt = (EncryptedPrivateKeyInfo)this.encryptedPriKeys.get(keyId);
            AlgorithmID aid = encPriExt.getAlgorithmID();
            byte[] parameter = aid.getParameter();
            try {
                PEOBEParameterData data = new PEOBEParameterData(parameter);
                objList.put(keyId, data.getObjectName());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return objList;
    }

    public EncryptedPrivateKeyInfo getEncryptedPrivateKeyInfo(String keyId) {
        return (EncryptedPrivateKeyInfo)this.encryptedPriKeys.get(keyId);
    }

    public String[] getKeyFactorIDs(String keyId) {
        EncryptedPrivateKeyInfo encPriExt = (EncryptedPrivateKeyInfo)this.encryptedPriKeys.get(keyId);
        if (encPriExt != null) {
            AlgorithmID aid = encPriExt.getAlgorithmID();
            byte[] parameter = aid.getParameter();
            try {
                PEOBEParameterData data = new PEOBEParameterData(parameter);
                return data.getKeyFactorID();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public void encode(ASN1Encoder enc) throws ASN1Exception {
        int id = enc.encodeSequence();
        for (String keyId : this.encryptedPriKeys.keySet()) {
            EncryptedPrivateKeyInfo encPriExt = (EncryptedPrivateKeyInfo)this.encryptedPriKeys.get(keyId);
            encPriExt.encode(enc);
        }
        enc.endOf(id);
    }

    public void decode(ASN1Decoder dec) throws ASN1Exception {
        int id = dec.decodeSequence();
        while (!dec.endOf(id)) {
            EncryptedPrivateKeyInfo encPri = new EncryptedPrivateKeyInfo();
            encPri.decode(dec);
            try {
                String keyId = this.generateMapId(encPri.getEncoded());
                this.encryptedPriKeys.put(keyId, encPri);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        dec.endOf(id);
    }
}

