/*
 * Decompiled with CFR 0.152.
 */
package com.initech.pkcs.pkcs8;

import com.initech.asn1.ASN1Decoder;
import com.initech.asn1.ASN1Encoder;
import com.initech.asn1.ASN1Exception;
import com.initech.asn1.ASN1Tag;
import com.initech.asn1.BERDecoder;
import com.initech.asn1.useful.ASN1Object;
import com.initech.asn1.useful.AlgorithmID;
import com.initech.asn1.useful.Attribute;
import com.initech.asn1.useful.Attributes;
import com.initech.cryptox.Zeroizable;
import java.io.InputStream;
import java.security.PrivateKey;

public class PrivateKeyInfo
extends ASN1Object
implements Zeroizable {
    private static final long serialVersionUID = 7912165749596423148L;
    private int version;
    private AlgorithmID privateKeyAlgorithm = new AlgorithmID();
    private byte[] privateKey;
    private Attributes attrs = new Attributes();

    public PrivateKeyInfo() {
        this.version = 0;
        this.privateKey = null;
    }

    public PrivateKeyInfo(InputStream inStream) throws ASN1Exception {
        BERDecoder dec = new BERDecoder(inStream);
        this.decode(dec);
        this.modified = true;
    }

    public PrivateKeyInfo(byte[] data) throws ASN1Exception {
        BERDecoder dec = new BERDecoder(data);
        this.decode(dec);
        this.encoded = (byte[])data.clone();
        this.modified = false;
    }

    public PrivateKeyInfo(PrivateKey pkey) throws ASN1Exception {
        this.version = 0;
        this.privateKey = (byte[])pkey.getEncoded().clone();
        BERDecoder dec = new BERDecoder(this.privateKey);
        this.decode(dec);
    }

    public String getAlgorithm() {
        return this.privateKeyAlgorithm.getAlg();
    }

    public byte[] getParameters() {
        return this.privateKeyAlgorithm.getParameter();
    }

    public byte[] getPrivateKey() {
        return (byte[])this.privateKey.clone();
    }

    public void setVersion(int value) {
        this.modified = true;
        this.version = value;
    }

    public void setPrivateKeyAlgorithm(AlgorithmID id) {
        this.modified = true;
        this.privateKeyAlgorithm = (AlgorithmID)id.clone();
    }

    public Attribute getAttribute(String oid) {
        return this.attrs.get(oid);
    }

    public void addAttribute(Attribute at) {
        this.modified = true;
        this.attrs.add(at);
    }

    public void setAttributes(Attributes attrs) {
        this.modified = true;
        this.attrs = attrs;
    }

    public Attributes getAttributes() {
        return this.attrs;
    }

    public void setPrivateKey(byte[] value) {
        this.privateKey = (byte[])value.clone();
    }

    public void decode(ASN1Decoder dec) throws ASN1Exception {
        int id = dec.decodeSequence();
        this.version = dec.decodeIntegerAsInt();
        this.privateKeyAlgorithm.decode(dec);
        this.privateKey = dec.decodeOctetString();
        if (!dec.nextIsOptional(ASN1Tag.makeContextTag(0))) {
            dec.nextIsImplicit(ASN1Tag.makeContextTag(0));
            this.attrs.decode(dec);
        }
        dec.endOf(id);
    }

    public void encode(ASN1Encoder enc) throws ASN1Exception {
        int id = enc.encodeSequence();
        enc.encodeInteger(this.version);
        this.privateKeyAlgorithm.encode(enc);
        enc.encodeOctetString(this.privateKey);
        if (this.attrs.size() > 0) {
            enc.nextIsImplicit(ASN1Tag.makeContextTag(0));
            this.attrs.encode(enc);
        }
        enc.endOf(id);
    }

    public void zeroize() {
        if (this.encoded != null) {
            for (int i = 0; i < this.encoded.length; ++i) {
                this.encoded[i] = 0;
            }
        }
    }
}

