/*
 * Decompiled with CFR 0.152.
 */
package com.initech.pkcs.pkcs8.spec;

import com.initech.asn1.ASN1Exception;
import com.initech.asn1.DERDecoder;
import com.initech.asn1.useful.AlgorithmID;
import com.initech.provider.crypto.InitechProvider;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.spec.PKCS8EncodedKeySpec;

public class EnhancedPKCS8EncodedKeySpec
extends PKCS8EncodedKeySpec {
    private String algId;
    private String algName;
    private AlgorithmID aid = new AlgorithmID();

    public EnhancedPKCS8EncodedKeySpec(byte[] encodedKey) throws InvalidKeyException {
        super(encodedKey);
        try {
            DERDecoder dec = new DERDecoder(encodedKey);
            int id = dec.decodeSequence();
            dec.skipNextTag();
            this.aid.decode(dec);
            dec.skipNextTag();
            dec.endOf(id);
        }
        catch (ASN1Exception ex) {
            ex.printStackTrace();
            throw new InvalidKeyException("Invalid PKCS#8 Key");
        }
        this.algId = this.aid.getAlg();
        this.algName = this.aid.getAlgName();
    }

    public String getKeyAlg() {
        return this.algId;
    }

    public String getKeyAlgName() {
        return this.algName;
    }

    public AlgorithmID getAlgorithmID() {
        return (AlgorithmID)this.aid.clone();
    }

    public KeyFactory getKeyFactory() throws NoSuchAlgorithmException, NoSuchProviderException {
        if (this.algName == null) {
            throw new NoSuchAlgorithmException("Can't Identify Key Algorithm");
        }
        return KeyFactory.getInstance(this.algName, InitechProvider.NAME);
    }

    public KeyFactory getKeyFactory(String provider) throws NoSuchAlgorithmException, NoSuchProviderException {
        if (this.algName == null) {
            throw new NoSuchAlgorithmException("Can't Identify Key Algorithm");
        }
        return KeyFactory.getInstance(this.algName, provider);
    }
}

