/*
 * Decompiled with CFR 0.152.
 */
package com.initech.provider;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarException;
import java.util.logging.Logger;

public abstract class JarUtils {
    private static final Logger log = Logger.getLogger(JarUtils.class.getName());
    public static final String META_INF = "META-INF/";
    public static final String DSA_SUFFIX = ".DSA";
    public static final String SF_SUFFIX = ".SF";
    public static final String NAME = "Name";
    public static final String MANIFEST_VERSION = "Manifest-Version";
    public static final String SIGNATURE_VERSION = "Signature-Version";
    public static final byte[] CRLF = new byte[]{13, 10};
    private static final String DEFAULT_MF_VERSION = "1.0";
    private static final String DEFAULT_SF_VERSION = "1.0";
    private static final Attributes.Name CREATED_BY = new Attributes.Name("Created-By");
    private static final String CREATOR = System.getProperty("java.version") + " (" + System.getProperty("java.vendor") + ")";

    public static void readMFManifest(Attributes attr, Map entries, InputStream in) throws IOException {
        BufferedReader br = new BufferedReader(new InputStreamReader(in, "UTF-8"));
        JarUtils.readMainSection(attr, br);
        JarUtils.readIndividualSections(entries, br);
    }

    public static void readSFManifest(Attributes attr, Map entries, InputStream in) throws IOException {
        BufferedReader br = new BufferedReader(new InputStreamReader(in, "UTF-8"));
        String version_header = Attributes.Name.SIGNATURE_VERSION.toString();
        try {
            String version = JarUtils.expectHeader(version_header, br);
            attr.putValue(SIGNATURE_VERSION, version);
            if (!"1.0".equals(version)) {
                log.warning("Unexpected version number: " + version + ". Continue (but may fail later)");
            }
        }
        catch (IOException ioe) {
            throw new JarException("Signature file MUST start with a " + version_header + ": " + ioe.getMessage());
        }
        JarUtils.read_attributes(attr, br);
        String s = br.readLine();
        while (s != null && s.length() > 0) {
            Attributes eAttr = JarUtils.readSectionName(s, br, entries);
            JarUtils.read_attributes(eAttr, br);
            s = br.readLine();
        }
    }

    private static void readMainSection(Attributes attr, BufferedReader br) throws IOException {
        JarUtils.read_attributes(attr, br);
        if (attr.getValue(Attributes.Name.MANIFEST_VERSION) == null) {
            attr.putValue(MANIFEST_VERSION, "0.0");
        }
    }

    private static void readIndividualSections(Map entries, BufferedReader br) throws IOException {
        String s = br.readLine();
        while (s != null && !s.equals("")) {
            Attributes attr = JarUtils.readSectionName(s, br, entries);
            JarUtils.read_attributes(attr, br);
            s = br.readLine();
        }
    }

    private static void readVersionInfo(Attributes attr, BufferedReader br) throws IOException {
        String version_header = Attributes.Name.MANIFEST_VERSION.toString();
        try {
            String value = JarUtils.expectHeader(version_header, br);
            attr.putValue(MANIFEST_VERSION, value);
        }
        catch (IOException ioe) {
            throw new JarException("Manifest should start with a " + version_header + ": " + ioe.getMessage());
        }
    }

    private static String expectHeader(String header, BufferedReader br) throws IOException {
        String s = br.readLine();
        if (s == null) {
            throw new JarException("unexpected end of file");
        }
        return JarUtils.expectHeader(header, br, s);
    }

    private static void read_attributes(Attributes attr, BufferedReader br) throws IOException {
        String s = br.readLine();
        while (s != null && !s.equals("")) {
            JarUtils.readAttribute(attr, s, br);
            s = br.readLine();
        }
    }

    private static void readAttribute(Attributes attr, String s, BufferedReader br) throws IOException {
        try {
            int colon = s.indexOf(": ");
            String name = s.substring(0, colon);
            String value_start = s.substring(colon + 2);
            String value = JarUtils.readHeaderValue(value_start, br);
            attr.putValue(name, value);
        }
        catch (IndexOutOfBoundsException iobe) {
            throw new JarException("Manifest contains a bad header: " + s);
        }
    }

    private static String readHeaderValue(String s, BufferedReader br) throws IOException {
        boolean try_next = true;
        while (try_next) {
            br.mark(1);
            if (br.read() == 32) {
                s = s + br.readLine();
                continue;
            }
            br.reset();
            try_next = false;
        }
        return s;
    }

    private static Attributes readSectionName(String s, BufferedReader br, Map entries) throws JarException {
        try {
            String name = JarUtils.expectHeader(NAME, br, s);
            Attributes attr = new Attributes();
            entries.put(name, attr);
            return attr;
        }
        catch (IOException ioe) {
            throw new JarException("Section should start with a Name header: " + ioe.getMessage());
        }
    }

    private static String expectHeader(String header, BufferedReader br, String s) throws IOException {
        try {
            String name = s.substring(0, header.length() + 1);
            if (name.equalsIgnoreCase(header + ":")) {
                String value_start = s.substring(header.length() + 2);
                return JarUtils.readHeaderValue(value_start, br);
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        throw new JarException("unexpected '" + s + "'");
    }

    public static void writeMFManifest(Attributes attr, Map entries, OutputStream stream) throws IOException {
        BufferedOutputStream out = stream instanceof BufferedOutputStream ? (BufferedOutputStream)stream : new BufferedOutputStream(stream, 4096);
        JarUtils.writeVersionInfo(attr, out);
        for (Map.Entry<Object, Object> entry : attr.entrySet()) {
            if (Attributes.Name.MANIFEST_VERSION.equals(entry.getKey())) continue;
            JarUtils.writeAttributeEntry(entry, out);
        }
        out.write(CRLF);
        for (Map.Entry<Object, Object> entry : entries.entrySet()) {
            JarUtils.writeHeader(NAME, entry.getKey().toString(), out);
            Attributes eAttr = (Attributes)entry.getValue();
            for (Map.Entry<Object, Object> e2 : eAttr.entrySet()) {
                JarUtils.writeAttributeEntry(e2, out);
            }
            out.write(CRLF);
        }
        out.flush();
    }

    public static void writeSFManifest(Attributes attr, Map entries, OutputStream stream) throws IOException {
        BufferedOutputStream out = stream instanceof BufferedOutputStream ? (BufferedOutputStream)stream : new BufferedOutputStream(stream, 4096);
        JarUtils.writeHeader(Attributes.Name.SIGNATURE_VERSION.toString(), "1.0", out);
        JarUtils.writeHeader(CREATED_BY.toString(), CREATOR, out);
        for (Map.Entry<Object, Object> entry : attr.entrySet()) {
            Attributes.Name name = (Attributes.Name)entry.getKey();
            if (Attributes.Name.SIGNATURE_VERSION.equals(name) || CREATED_BY.equals(name)) continue;
            JarUtils.writeHeader(name.toString(), (String)entry.getValue(), out);
        }
        out.write(CRLF);
        for (Map.Entry<Object, Object> entry : entries.entrySet()) {
            JarUtils.writeHeader(NAME, entry.getKey().toString(), out);
            Attributes eAttr = (Attributes)entry.getValue();
            for (Map.Entry<Object, Object> e2 : eAttr.entrySet()) {
                JarUtils.writeHeader(e2.getKey().toString(), (String)e2.getValue(), out);
            }
            out.write(CRLF);
        }
        out.flush();
    }

    private static void writeVersionInfo(Attributes attr, OutputStream out) throws IOException {
        String version = attr.getValue(Attributes.Name.MANIFEST_VERSION);
        if (version == null) {
            version = "1.0";
        }
        JarUtils.writeHeader(Attributes.Name.MANIFEST_VERSION.toString(), version, out);
    }

    private static void writeAttributeEntry(Map.Entry entry, OutputStream out) throws IOException {
        String name = entry.getKey().toString();
        String value = entry.getValue().toString();
        if (name.equalsIgnoreCase(NAME)) {
            throw new JarException("Attributes cannot be called 'Name'");
        }
        if (name.startsWith("From")) {
            throw new JarException("Header cannot start with the four letters 'From'" + name);
        }
        JarUtils.writeHeader(name, value, out);
    }

    private static void writeHeader(String name, String value, OutputStream out) throws IOException {
        String target = name + ": ";
        byte[] b = target.getBytes("UTF-8");
        if (b.length > 72) {
            throw new IOException("Attribute's name already longer than 70 bytes");
        }
        if (b.length == 72) {
            out.write(b);
            out.write(CRLF);
            target = " " + value;
        } else {
            target = target + value;
        }
        while (true) {
            if ((b = target.getBytes("UTF-8")).length < 73) break;
            int n = 72;
            while ((b = target.substring(0, n).getBytes("UTF-8")).length >= 73) {
                if (--n >= 1) continue;
                throw new IOException("Header is unbreakable and longer than 72 bytes");
            }
            out.write(b);
            out.write(CRLF);
            target = " " + target.substring(n);
        }
        out.write(b);
        out.write(CRLF);
    }
}

