/*
 * Decompiled with CFR 0.152.
 */
package com.initech.provider.crypto;

import com.initech.cryptox.KSXRuntimeException;
import com.initech.cryptox.util.Hex;
import com.initech.provider.crypto.SelfTest;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;

public final class InitechProvider
extends Provider {
    private static final long serialVersionUID = 5895060222437845497L;
    public static String NAME = "Initech";
    public static final String VERSION = "4.2.7";
    public static final double VERSION_DOUBLE = 4.206;
    public static final String INFO = "Initech Security Provider(INISAFE Crypto) v4.2.7, SEED, ARIA, AES, 3DES, RSA, KCDSA, DSA, ECDSA, SHA and SecureRandom .... support";
    public static final String PRODUCT_NAME = "INITECH INISAFECryptoForJava";
    public static final String PRODUCT_UPDATE_DATE = "2022.10.21";
    public static final int ADMIN = 0;
    public static final int USER = 1;
    public static boolean isPrint = false;
    private static int PROVIDER_NOT = 0;
    private static int PROVIDER_ING = 1;
    private static int PROVIDER_END = 2;
    private static int PROVIDER_STATUS = PROVIDER_NOT;
    private boolean mode = false;

    public InitechProvider() {
        this(true, false);
    }

    public InitechProvider(boolean provenFlag) {
        this(true, provenFlag);
    }

    public InitechProvider(boolean selfTestFlag, boolean provenFlag) {
        this(selfTestFlag, provenFlag, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public InitechProvider(boolean selfTestFlag, boolean provenFlag, boolean updateFlag) {
        super(InitechProvider.NAME, 4.206, "Initech Security Provider(INISAFE Crypto) v4.2.7, SEED, ARIA, AES, 3DES, RSA, KCDSA, DSA, ECDSA, SHA and SecureRandom .... support");
        var4_4 = this;
        synchronized (var4_4) {
            block22: {
                provider = null;
                checkProvider = null;
                provenFlag = false;
                try {
                    provider = Security.getProvider(InitechProvider.NAME);
                }
                catch (Exception e) {
                    old_provider = Security.getProvider(InitechProvider.NAME);
                    System.out.println("WARN : " + e);
                    System.out.println("WARN : Other Version Initech Provider was Added - remove other version crypto module(jar) " + old_provider);
                    provider = null;
                }
                if (provider == null) break block22;
                beforeVersion = provider.getVersion();
                if (beforeVersion >= 4.206) ** GOTO lbl-1000
                if (beforeVersion < 4.206 && !updateFlag) lbl-1000:
                // 2 sources

                {
                    try {
                        ret = InitechProvider.providerVectorTest();
                        if (!ret.booleanValue()) {
                            throw new RuntimeException("Provider vector test value is invalid.");
                        }
                        System.out.println("Initech Provider(" + beforeVersion + ") is already working.");
                        return;
                    }
                    catch (NoSuchAlgorithmException e) {
                        System.out.println("Failed to selfVectorTest. The provider(" + beforeVersion + ")will be deleted and re-registered. errorMessage : " + e.getMessage());
                    }
                    catch (NoSuchProviderException e) {
                        System.out.println("Failed to selfVectorTest. The provider(" + beforeVersion + ")will be deleted and re-registered. errorMessage : " + e.getMessage());
                    }
                    catch (RuntimeException e) {
                        System.out.println("Failed to selfVectorTest. The provider(" + beforeVersion + ")will be deleted and re-registered. errorMessage : " + e.getMessage());
                    }
                } else {
                    System.out.println("It will delete the old provider(" + beforeVersion + ") and register the new one(" + 4.206 + ").");
                    Security.removeProvider(InitechProvider.NAME);
                }
            }
            try {
                InitechProvider.PROVIDER_STATUS = InitechProvider.PROVIDER_ING;
                this.mode = provenFlag;
                if (this.mode) {
                    this.puts2();
                } else {
                    this.puts();
                }
                for (i = 0; i < 10; ++i) {
                    Security.addProvider(this);
                    checkProvider = Security.getProvider(InitechProvider.NAME);
                    if (checkProvider != null) break;
                    try {
                        Thread.sleep(10L);
                        continue;
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                if (checkProvider == null) {
                    throw new KSXRuntimeException();
                }
                InitechProvider.PROVIDER_STATUS = InitechProvider.PROVIDER_END;
                if (selfTestFlag) {
                    SelfTest.setState(1);
                    SelfTest.powerUp();
                }
                SelfTest.setState(3);
                System.out.println("Initech Crypto Provider v4.2.7 succeeded in adding provider.");
            }
            catch (KSXRuntimeException e) {
                errorString = "Failed to addProvider InitechProvider V4.2.7.";
                System.out.println("ERROR : " + errorString + " " + e.getMessage());
                if (checkProvider != null) {
                    Security.removeProvider(InitechProvider.NAME);
                }
                new KSXRuntimeException(errorString + " " + e.getMessage(), e).printStackTrace();
            }
        }
    }

    public boolean getMode() {
        return this.mode;
    }

    public static void addAsProvider(boolean selfTestFlag, boolean provenFlag) {
        new InitechProvider(selfTestFlag, provenFlag);
    }

    public static void addAsProvider(boolean selfTestFlag, boolean provenFlag, boolean updateFalg) {
        new InitechProvider(selfTestFlag, provenFlag, updateFalg);
    }

    private static void printInfo() {
        SimpleDateFormat dateformat = new SimpleDateFormat("yyyy/MM/dd HH:mm ss");
        StringBuffer sb = new StringBuffer();
        sb.append("\n");
        sb.append("\n#################################################");
        sb.append("\n#######      INITECH Product Info     #######");
        sb.append("\n");
        sb.append("\n    Package Name : INITECH INISAFECryptoForJava");
        sb.append("\n    Version Info : 4.2.7 release");
        sb.append("\n    Update Date  : 2022.10.21");
        sb.append("\n    Current Time : " + dateformat.format(new Date()));
        sb.append("\n");
        sb.append("\n####### Initech Security Provider(INISAFE Crypto) v4.2.7, SEED, ARIA, AES, 3DES, RSA, KCDSA, DSA, ECDSA, SHA and SecureRandom .... support #######");
        sb.append("\n##################################################");
        sb.append("\n\n");
        System.out.println(sb.toString());
    }

    public static void addAsProvider() {
        InitechProvider.addAsProvider(true, false);
    }

    private static Provider addProvider() {
        return new InitechProvider(false, false);
    }

    public static void changeMode() {
        InitechProvider.addAsProvider(false, false);
    }

    public static Provider checkProviderObject() {
        return InitechProvider.checkProviderObject(NAME);
    }

    public static Provider checkProviderObject(String providerName) {
        switch (PROVIDER_STATUS) {
            case 0: 
            case 1: {
                try {
                    int ing = 0;
                    while (PROVIDER_STATUS != PROVIDER_END) {
                        if (++ing % 500 == 0) {
                            System.out.println("[" + PROVIDER_STATUS + "]Add Provider waiting......" + ing);
                        }
                        Thread.sleep(10L);
                        if (ing < 1000) continue;
                    }
                }
                catch (Exception e) {}
                break;
            }
        }
        Provider prov = Security.getProvider(providerName);
        if (prov == null) {
            prov = InitechProvider.addProvider();
        } else {
            PROVIDER_STATUS = PROVIDER_END;
        }
        return prov;
    }

    static void SelfTestProvider() {
        System.out.println("INITECH Provider SelfTest Mode");
        InitechProvider.changeMode();
    }

    public static String getKryptonVersion() {
        return "INISAFE Crypto for Java with JCEX Version 4.206";
    }

    public static void printMode() {
        System.out.println("Deprecated method");
    }

    public static boolean isProvenMode() {
        return false;
    }

    public void puts2() {
        this.putBlockCipher("SEED", "Seed");
        this.putBlockCipher("ARIA", "Aria");
        this.put("Cipher.RSA", "com.initech.provider.crypto.cipher.RSA");
        this.put("KeyPairGenerator.RSA", "com.initech.provider.crypto.rsa.RSAKeyPairGenerator");
        this.put("KeyPairGenerator.RSASSA-PSS", "com.initech.provider.crypto.rsa.RSAPSSKeyPairGenerator");
        this.put("KeyPairGenerator.KCDSA", "com.initech.provider.crypto.kcdsa.KCDSAKeyPairGenerator");
        this.put("SecretKeyFactory.HMAC", "com.initech.provider.crypto.mac.HMACKeyFactory");
        this.put("Alg.Alias.SecretKeyFactory.HMACwithSHA224", "HMAC");
        this.put("Alg.Alias.SecretKeyFactory.HMACwithSHA256", "HMAC");
        this.put("Alg.Alias.SecretKeyFactory.HMACwithSHA384", "HMAC");
        this.put("Alg.Alias.SecretKeyFactory.HMACwithSHA512", "HMAC");
        this.put("Alg.Alias.SecretKeyFactory.HMACwithSHA3_224", "HMAC");
        this.put("Alg.Alias.SecretKeyFactory.HMACwithSHA3_256", "HMAC");
        this.put("Alg.Alias.SecretKeyFactory.HMACwithSHA3_384", "HMAC");
        this.put("Alg.Alias.SecretKeyFactory.HMACwithSHA3_512", "HMAC");
        this.put("Alg.Alias.SecretKeyFactory.HMACwithLSH256_224", "HMAC");
        this.put("Alg.Alias.SecretKeyFactory.HMACwithLSH256_256", "HMAC");
        this.put("Alg.Alias.SecretKeyFactory.HMACwithLSH512_224", "HMAC");
        this.put("Alg.Alias.SecretKeyFactory.HMACwithLSH512_256", "HMAC");
        this.put("Alg.Alias.SecretKeyFactory.HMACwithLSH512_384", "HMAC");
        this.put("Alg.Alias.SecretKeyFactory.HMACwithLSH512_512", "HMAC");
        this.put("KeyFactory.RSA", "com.initech.provider.crypto.rsa.RSAKeyFactory");
        this.put("KeyFactory.RSASSA-PSS", "com.initech.provider.crypto.rsa.RSAPSSKeyFactory");
        this.put("KeyFactory.KCDSA", "com.initech.provider.crypto.kcdsa.KCDSAKeyFactory");
        this.put("KeyFactory.KCDSA1", "com.initech.provider.crypto.kcdsa.KCDSAKeyFactory");
        this.put("MessageDigest.SHA-224", "com.initech.provider.crypto.md.SHA224");
        this.put("MessageDigest.SHA224", "com.initech.provider.crypto.md.SHA224");
        this.put("MessageDigest.SHA-256", "com.initech.provider.crypto.md.SHA256");
        this.put("MessageDigest.SHA256", "com.initech.provider.crypto.md.SHA256");
        this.put("MessageDigest.SHA-384", "com.initech.provider.crypto.md.SHA384");
        this.put("MessageDigest.SHA384", "com.initech.provider.crypto.md.SHA384");
        this.put("MessageDigest.SHA-512", "com.initech.provider.crypto.md.SHA512");
        this.put("MessageDigest.SHA512", "com.initech.provider.crypto.md.SHA512");
        this.put("MessageDigest.SM3", "com.initech.provider.crypto.md.SM3");
        this.put("MessageDigest.SHA3-224", "com.initech.provider.crypto.md.SHA3_224");
        this.put("MessageDigest.SHA3-256", "com.initech.provider.crypto.md.SHA3_256");
        this.put("MessageDigest.SHA3-384", "com.initech.provider.crypto.md.SHA3_384");
        this.put("MessageDigest.SHA3-512", "com.initech.provider.crypto.md.SHA3_512");
        this.put("MessageDigest.LSH256", "com.initech.provider.crypto.md.LSH256_256");
        this.put("MessageDigest.LSH-256", "com.initech.provider.crypto.md.LSH256_256");
        this.put("MessageDigest.LSH256-256", "com.initech.provider.crypto.md.LSH256_256");
        this.put("MessageDigest.LSH256-224", "com.initech.provider.crypto.md.LSH256_224");
        this.put("MessageDigest.LSH512", "com.initech.provider.crypto.md.LSH512_512");
        this.put("MessageDigest.LSH-512", "com.initech.provider.crypto.md.LSH512_512");
        this.put("MessageDigest.LSH512-512", "com.initech.provider.crypto.md.LSH512_512");
        this.put("MessageDigest.LSH512-384", "com.initech.provider.crypto.md.LSH512_384");
        this.put("MessageDigest.LSH512-256", "com.initech.provider.crypto.md.LSH512_256");
        this.put("MessageDigest.LSH512-224", "com.initech.provider.crypto.md.LSH512_224");
        this.put("AlgorithmParameters.KCDSA", "com.initech.provider.crypto.kcdsa.KCDSAParameters");
        this.put("AlgorithmParameters.KCDSA1", "com.initech.provider.crypto.kcdsa.KCDSAParameters");
        this.put("AlgorithmParameterGenerator.KCDSA", "com.initech.provider.crypto.kcdsa.KCDSAParameterGenerator");
        this.put("AlgorithmParameterGenerator.KCDSA1", "com.initech.provider.crypto.kcdsa.KCDSAParameterGenerator");
        this.put("AlgorithmParameters.SEED", "com.initech.provider.crypto.cipher.SEEDParameters");
        this.put("Alg.Alias.AlgorithmParameters.SEEDecb", "SEED");
        this.put("Alg.Alias.AlgorithmParameters.SEEDcbc", "SEED");
        this.put("Alg.Alias.AlgorithmParameters.SEEDofb", "SEED");
        this.put("Alg.Alias.AlgorithmParameters.SEEDcfb", "SEED");
        this.put("Alg.Alias.AlgorithmParameters.SEEDctr", "SEED");
        this.put("AlgorithmParameters.ARIA", "com.initech.provider.crypto.cipher.ARIAParameters");
        this.put("Alg.Alias.AlgorithmParameters.ARIAecb", "ARIA");
        this.put("Alg.Alias.AlgorithmParameters.ARIAcbc", "ARIA");
        this.put("Alg.Alias.AlgorithmParameters.ARIAofb", "ARIA");
        this.put("Alg.Alias.AlgorithmParameters.ARIAcfb", "ARIA");
        this.put("Alg.Alias.AlgorithmParameters.ARIActr", "ARIA");
        this.put("Mac.HMACwithSHA224", "com.initech.provider.crypto.mac.HMACwithSHA224");
        this.put("Alg.Alias.Mac.HmacSHA224", "HMACwithSHA224");
        this.put("Mac.HMACwithSHA256", "com.initech.provider.crypto.mac.HMACwithSHA256");
        this.put("Alg.Alias.Mac.HmacSHA256", "HMACwithSHA256");
        this.put("Mac.HMACwithSHA384", "com.initech.provider.crypto.mac.HMACwithSHA384");
        this.put("Alg.Alias.Mac.HmacSHA384", "HMACwithSHA384");
        this.put("Mac.HMACwithSHA512", "com.initech.provider.crypto.mac.HMACwithSHA512");
        this.put("Alg.Alias.Mac.HmacSHA512", "HMACwithSHA512");
        this.put("Mac.HMACwithSHA3_224", "com.initech.provider.crypto.mac.HMACwithSHA3_224");
        this.put("Alg.Alias.Mac.HmacSHA3-224", "HMACwithSHA3_224");
        this.put("Mac.HMACwithSHA3_256", "com.initech.provider.crypto.mac.HMACwithSHA3_256");
        this.put("Alg.Alias.Mac.HmacSHA3-256", "HMACwithSHA3_256");
        this.put("Mac.HMACwithSHA3_384", "com.initech.provider.crypto.mac.HMACwithSHA3_384");
        this.put("Alg.Alias.Mac.HmacSHA3-384", "HMACwithSHA3_384");
        this.put("Mac.HMACwithSHA3_512", "com.initech.provider.crypto.mac.HMACwithSHA3_512");
        this.put("Alg.Alias.Mac.HmacSHA3-512", "HMACwithSHA3_512");
        this.put("Mac.HMACwithLSH256_224", "com.initech.provider.crypto.mac.HMACwithLSH256_224");
        this.put("Alg.Alias.Mac.HmacLSH256-224", "HMACwithLSH256_224");
        this.put("Mac.HMACwithLSH256_256", "com.initech.provider.crypto.mac.HMACwithLSH256_256");
        this.put("Alg.Alias.Mac.HmacLSH256-256", "HMACwithLSH256_256");
        this.put("Mac.HMACwithLSH512_224", "com.initech.provider.crypto.mac.HMACwithLSH512_224");
        this.put("Alg.Alias.Mac.HmacLSH512-224", "HMACwithLSH512_224");
        this.put("Mac.HMACwithLSH512_256", "com.initech.provider.crypto.mac.HMACwithLSH512_256");
        this.put("Alg.Alias.Mac.HmacLSH512-256", "HMACwithLSH512_256");
        this.put("Mac.HMACwithLSH512_384", "com.initech.provider.crypto.mac.HMACwithLSH512_384");
        this.put("Alg.Alias.Mac.HmacLSH512-384", "HMACwithLSH512_384");
        this.put("Mac.HMACwithLSH512_512", "com.initech.provider.crypto.mac.HMACwithLSH512_512");
        this.put("Alg.Alias.Mac.HmacLSH512-512", "HMACwithLSH512_512");
        this.put("Signature.SHA256withRSAPSS", "com.initech.provider.crypto.rsa.RSAPSSSignatureSHA256");
        this.put("Signature.SHA256withRSAandMGF1", "com.initech.provider.crypto.rsa.RSAPSSSignatureSHA256");
        this.put("Signature.SHA224withKCDSA", "com.initech.provider.crypto.kcdsa.SHA224withKCDSA");
        this.put("Signature.SHA256withKCDSA", "com.initech.provider.crypto.kcdsa.SHA256withKCDSA");
        this.put("Signature.SHA224withRSA", "com.initech.provider.crypto.rsa.SHA224withRSA");
        this.put("Signature.SHA256withRSA", "com.initech.provider.crypto.rsa.SHA256withRSA");
        this.put("SecureRandom.HashDRBG", "com.initech.provider.crypto.random.HashDRBG");
        this.put("SecureRandom.HASHDRBGSHA224", "com.initech.provider.crypto.random.HASHDRBGSHA224");
        this.put("SecureRandom.HASHDRBGSHA-224", "com.initech.provider.crypto.random.HASHDRBGSHA224");
        this.put("SecureRandom.HASHDRBGSHA256", "com.initech.provider.crypto.random.HASHDRBGSHA256");
        this.put("SecureRandom.HASHDRBGSHA-256", "com.initech.provider.crypto.random.HASHDRBGSHA256");
        this.put("SecureRandom.HASHDRBGSHA384", "com.initech.provider.crypto.random.HASHDRBGSHA384");
        this.put("SecureRandom.HASHDRBGSHA-384", "com.initech.provider.crypto.random.HASHDRBGSHA384");
        this.put("SecureRandom.HASHDRBGSHA512", "com.initech.provider.crypto.random.HASHDRBGSHA512");
        this.put("SecureRandom.HASHDRBGSHA-512", "com.initech.provider.crypto.random.HASHDRBGSHA512");
        this.put("CertificateFactory.X.509", "com.initech.x509.X509CertificateFactory");
        this.put("Cipher.PBES2", "com.initech.provider.crypto.cipher.PBES2");
        this.put("AlgorithmParameters.PBE", "com.initech.provider.crypto.cipher.PBEParameters");
        this.put("AlgorithmParameterGenerator.PBE", "com.initech.provider.crypto.cipher.PBEParameterGenerator");
        this.put("SecretKeyFactory.PKCS5", "com.initech.provider.crypto.cipher.PKCS5KeyFactory");
        this.put("AlgorithmParameters.PEOBE", "com.initech.provider.crypto.cipher.PEOBEParameters");
        this.put("Cipher.PEOBEWithSHA1AndSeedcbc", "com.initech.vendor.initech.PEOBEWithSHA1AndSeedcbc");
    }

    public static void setRole(int role) {
    }

    public static int getRole() {
        return 0;
    }

    public static void checkKSXRandom(SecureRandom random) {
        if (random == null) {
            throw new KSXRuntimeException("KS X ISO/IEC 24759 - SecurenRandom is null");
        }
        if (!(random.getProvider() instanceof InitechProvider)) {
            throw new KSXRuntimeException("KS X ISO/IEC 24759 - SecurenRandom is not InitechProvider : " + random.getProvider().getClass().getName());
        }
    }

    private void putBlockCipher(String cipherName, String className) {
        this.put("Cipher." + cipherName + "/ECB/NoPadding", "com.initech.provider.crypto.cipher." + className);
        this.put("Cipher." + cipherName + "/ECB", "com.initech.provider.crypto.cipher." + className + "ecb");
        this.put("Cipher." + cipherName + "/CBC", "com.initech.provider.crypto.cipher." + className + "cbc");
        this.put("Cipher." + cipherName + "/OFB", "com.initech.provider.crypto.cipher." + className + "ofbiso");
        this.put("Cipher." + cipherName + "/OFBISO", "com.initech.provider.crypto.cipher." + className + "ofbiso");
        this.put("Cipher." + cipherName + "/CFB", "com.initech.provider.crypto.cipher." + className + "cfbiso");
        this.put("Cipher." + cipherName + "/CFB8", "com.initech.provider.crypto.cipher." + className + "cfbiso");
        this.put("Cipher." + cipherName + "/CFB128", "com.initech.provider.crypto.cipher." + className + "cfbiso");
        this.put("Cipher." + cipherName + "/CTR", "com.initech.provider.crypto.cipher." + className + "ctriso");
        this.put("Alg.Alias.Cipher." + cipherName, cipherName + "/ECB");
        this.put("Alg.Alias.Cipher." + cipherName + "ecb", cipherName + "/ECB");
        this.put("Alg.Alias.Cipher." + cipherName + "cbc", cipherName + "/CBC");
        this.put("Alg.Alias.Cipher." + cipherName + "ofb", cipherName + "/OFB");
        this.put("Alg.Alias.Cipher." + cipherName + "ofb", cipherName + "/OFBISO");
        this.put("Alg.Alias.Cipher." + cipherName + "ofbiso", cipherName + "/OFBISO");
        this.put("Alg.Alias.Cipher." + cipherName + "ofb128", cipherName + "/OFBISO");
        this.put("Alg.Alias.Cipher." + cipherName + "/OFB128", cipherName + "/OFBISO");
        this.put("Alg.Alias.Cipher." + cipherName + "/OFB64", cipherName + "/OFBISO");
        this.put("Alg.Alias.Cipher." + cipherName + "/OFB32", cipherName + "/OFBISO");
        this.put("Alg.Alias.Cipher." + cipherName + "/OFB16", cipherName + "/OFBISO");
        this.put("Alg.Alias.Cipher." + cipherName + "/OFB8", cipherName + "/OFBISO");
        this.put("Alg.Alias.Cipher." + cipherName + "/CTR", cipherName + "/CTRISO");
        this.put("Alg.Alias.Cipher." + cipherName + "cfb", cipherName + "/CFBISO");
        this.put("Alg.Alias.Cipher." + cipherName + "/CFB8", cipherName + "/CFBISO");
        this.put("Alg.Alias.Cipher." + cipherName + "/CFB128", cipherName + "/CFBISO");
        this.put("KeyGenerator." + cipherName, "com.initech.provider.crypto.cipher." + className + "KeyGenerator");
        this.put("Alg.Alias.KeyGenerator." + cipherName + "/CTR", cipherName);
        this.put("Alg.Alias.KeyGenerator." + cipherName + "/ECB", cipherName);
        this.put("Alg.Alias.KeyGenerator." + cipherName + "/CBC", cipherName);
        this.put("Alg.Alias.KeyGenerator." + cipherName + "/OFB", cipherName);
        this.put("Alg.Alias.KeyGenerator." + cipherName + "/CFB", cipherName);
        this.put("Alg.Alias.KeyGenerator." + cipherName + "ecb", cipherName);
        this.put("Alg.Alias.KeyGenerator." + cipherName + "cbc", cipherName);
        this.put("Alg.Alias.KeyGenerator." + cipherName + "ofb", cipherName);
        this.put("Alg.Alias.KeyGenerator." + cipherName + "cfb", cipherName);
        this.put("SecretKeyFactory." + cipherName, "com.initech.provider.crypto.cipher." + className + "KeyFactory");
        this.put("Alg.Alias.SecretKeyFactory." + cipherName + "/CTR", cipherName);
        this.put("Alg.Alias.SecretKeyFactory." + cipherName + "/ECB", cipherName);
        this.put("Alg.Alias.SecretKeyFactory." + cipherName + "/CBC", cipherName);
        this.put("Alg.Alias.SecretKeyFactory." + cipherName + "/OFB", cipherName);
        this.put("Alg.Alias.SecretKeyFactory." + cipherName + "/CFB", cipherName);
        this.put("Alg.Alias.SecretKeyFactory." + cipherName + "ecb", cipherName);
        this.put("Alg.Alias.SecretKeyFactory." + cipherName + "cbc", cipherName);
        this.put("Alg.Alias.SecretKeyFactory." + cipherName + "ofb", cipherName);
        this.put("Alg.Alias.SecretKeyFactory." + cipherName + "cfb", cipherName);
    }

    private void puts() {
        this.putBlockCipher("SEED", "Seed");
        this.putBlockCipher("ARIA", "Aria");
        this.putBlockCipher("LEA", "Lea");
        this.putBlockCipher("SSSS", "SSSS");
        this.putBlockCipher("SEEDX", "SSSS");
        this.putBlockCipher("DES", "DES");
        this.putBlockCipher("DESede", "DESede");
        this.putBlockCipher("RC2", "RC2");
        this.putBlockCipher("RC5", "RC5");
        this.putBlockCipher("Rijndael", "Rijndael");
        this.putBlockCipher("AES", "Rijndael");
        this.putBlockCipher("NSEED", "jni.NSeed");
        this.put("SEED/CBC/PKCS5Padding", "com.initech.provider.crypto.cipher.sun.Seedcbcpk5");
        this.put("SecretKeyFactory.SSSS", "com.initech.provider.crypto.cipher.SeedKeyFactory");
        this.put("KeyGenerator.SSSS", "com.initech.provider.crypto.cipher.SeedKeyGenerator");
        this.put("SecretKeyFactory.SEEDX", "com.initech.provider.crypto.cipher.SeedKeyFactory");
        this.put("KeyGenerator.SEEDX", "com.initech.provider.crypto.cipher.SeedKeyGenerator");
        this.put("Cipher.RC4", "com.initech.provider.crypto.cipher.RC4");
        this.put("Cipher.RSA", "com.initech.provider.crypto.cipher.RSA");
        this.put("KeyGenerator.RC4", "com.initech.provider.crypto.cipher.RC4KeyGenerator");
        this.put("KeyAgreement.DH", "com.initech.provider.crypto.dh.DHKeyAgreement");
        this.put("KeyAgreement.ESDH", "com.initech.provider.crypto.dh.ESDHKeyAgreement");
        this.put("KeyPairGenerator.RSA", "com.initech.provider.crypto.rsa.RSAKeyPairGenerator");
        this.put("KeyPairGenerator.RSASSA-PSS", "com.initech.provider.crypto.rsa.RSAPSSKeyPairGenerator");
        this.put("KeyPairGenerator.KCDSA", "com.initech.provider.crypto.kcdsa.KCDSAKeyPairGenerator");
        this.put("KeyPairGenerator.DH", "com.initech.provider.crypto.dh.DHKeyPairGenerator");
        this.put("KeyPairGenerator.DSA", "com.initech.provider.crypto.dsa.DSAKeyPairGenerator");
        this.put("KeyPairGenerator.ECDSA", "com.initech.provider.crypto.ecdsa.ECDSAKeyPairGenerator");
        this.put("Alg.Alias.KeyPairGenerator.MD5withDSA", "DSA");
        this.put("Alg.Alias.KeyPairGenerator.SHA1withDSA", "DSA");
        this.put("SecretKeyFactory.RC4", "com.initech.provider.crypto.cipher.RC4KeyFactory");
        this.put("SecretKeyFactory.PKCS5", "com.initech.provider.crypto.cipher.PKCS5KeyFactory");
        this.put("SecretKeyFactory.PBEWithSHAAnd3KeyTripleDES", "com.initech.provider.crypto.cipher.PKCS5KeyFactory");
        this.put("SecretKeyFactory.PBEWithSHAAnd2KeyTripleDES", "com.initech.provider.crypto.cipher.PKCS5KeyFactory");
        this.put("SecretKeyFactory.PBEWithSHAAnd128BitRC2", "com.initech.provider.crypto.cipher.PKCS5KeyFactory");
        this.put("SecretKeyFactory.PBEWithSHAAnd40BitRC2", "com.initech.provider.crypto.cipher.PKCS5KeyFactory");
        this.put("SecretKeyFactory.DEScbc", "com.initech.provider.crypto.cipher.DESKeyFactory");
        this.put("SecretKeyFactory.DESedecbc", "com.initech.provider.crypto.cipher.DESedeKeyFactory");
        this.put("SecretKeyFactory.RC2cbc", "com.initech.provider.crypto.cipher.RC2KeyFactory");
        this.put("SecretKeyFactory.RC5cbc", "com.initech.provider.crypto.cipher.RC5KeyFactory");
        this.put("SecretKeyFactory.Rijndaelcbc", "com.initech.provider.crypto.cipher.RijndaelKeyFactory");
        this.put("Alg.Alias.SecretKeyFactory.PBEWithSHA1AndDES", "PKCS5");
        this.put("Alg.Alias.SecretKeyFactory.PBEWithSHA1AndRC2", "PKCS5");
        this.put("Alg.Alias.SecretKeyFactory.PBEWithMD5AndDES", "PKCS5");
        this.put("Alg.Alias.SecretKeyFactory.PBEWithMD5AndRC2", "PKCS5");
        this.put("Alg.Alias.SecretKeyFactory.PBEWithMD2AndDES", "PKCS5");
        this.put("Alg.Alias.SecretKeyFactory.PBEWithMD2AndRC2", "PKCS5");
        this.put("Alg.Alias.SecretKeyFactory.PBEWithHmacSHA1AndDES", "PKCS5");
        this.put("Alg.Alias.SecretKeyFactory.PBEWithHmacSHA1AndDESede", "PKCS5");
        this.put("Alg.Alias.SecretKeyFactory.PBEWithHmacSHA1AndDESede3", "PKCS5");
        this.put("Alg.Alias.SecretKeyFactory.PBEWithHmacSHA1AndRC2", "PKCS5");
        this.put("Alg.Alias.SecretKeyFactory.PBEWithHmacSHA1AndRC5", "PKCS5");
        this.put("SecretKeyFactory.HMAC", "com.initech.provider.crypto.mac.HMACKeyFactory");
        this.put("Alg.Alias.SecretKeyFactory.HMACwithMD5", "HMAC");
        this.put("Alg.Alias.SecretKeyFactory.HMACwithHAS160", "HMAC");
        this.put("Alg.Alias.SecretKeyFactory.HMACwithSHA1", "HMAC");
        this.put("Alg.Alias.SecretKeyFactory.HMACwithSHA224", "HMAC");
        this.put("Alg.Alias.SecretKeyFactory.HMACwithSHA256", "HMAC");
        this.put("Alg.Alias.SecretKeyFactory.HMACwithSHA384", "HMAC");
        this.put("Alg.Alias.SecretKeyFactory.HMACwithSHA512", "HMAC");
        this.put("Alg.Alias.SecretKeyFactory.HMACwithSHA3_224", "HMAC");
        this.put("Alg.Alias.SecretKeyFactory.HMACwithSHA3_256", "HMAC");
        this.put("Alg.Alias.SecretKeyFactory.HMACwithSHA3_384", "HMAC");
        this.put("Alg.Alias.SecretKeyFactory.HMACwithSHA3_512", "HMAC");
        this.put("Alg.Alias.SecretKeyFactory.HMACwithLSH256_224", "HMAC");
        this.put("Alg.Alias.SecretKeyFactory.HMACwithLSH256_256", "HMAC");
        this.put("Alg.Alias.SecretKeyFactory.HMACwithLSH512_224", "HMAC");
        this.put("Alg.Alias.SecretKeyFactory.HMACwithLSH512_256", "HMAC");
        this.put("Alg.Alias.SecretKeyFactory.HMACwithLSH512_384", "HMAC");
        this.put("Alg.Alias.SecretKeyFactory.HMACwithLSH512_512", "HMAC");
        this.put("Alg.Alias.SecretKeyFactory.MACwithDES", "DES");
        this.put("Alg.Alias.SecretKeyFactory.MACwithDESede", "DESede");
        this.put("KeyFactory.RSA", "com.initech.provider.crypto.rsa.RSAKeyFactory");
        this.put("KeyFactory.RSASSA-PSS", "com.initech.provider.crypto.rsa.RSAPSSKeyFactory");
        this.put("KeyFactory.KCDSA", "com.initech.provider.crypto.kcdsa.KCDSAKeyFactory");
        this.put("KeyFactory.KCDSA1", "com.initech.provider.crypto.kcdsa.KCDSAKeyFactory");
        this.put("KeyFactory.DH", "com.initech.provider.crypto.dh.DHKeyFactory");
        this.put("KeyFactory.DSA", "com.initech.provider.crypto.dsa.DSAKeyFactory");
        this.put("KeyFactory.ECDSA", "com.initech.provider.crypto.ecdsa.ECDSAKeyFactory");
        this.put("MessageDigest.HAS160", "com.initech.provider.crypto.md.HAS160");
        this.put("MessageDigest.SHA-1", "com.initech.provider.crypto.md.SHA1");
        this.put("MessageDigest.SHA-256", "com.initech.provider.crypto.md.SHA256");
        this.put("MessageDigest.SHA-384", "com.initech.provider.crypto.md.SHA384");
        this.put("MessageDigest.SHA-512", "com.initech.provider.crypto.md.SHA512");
        this.put("MessageDigest.SHA-224", "com.initech.provider.crypto.md.SHA224");
        this.put("MessageDigest.SHA256", "com.initech.provider.crypto.md.SHA256");
        this.put("MessageDigest.SHA384", "com.initech.provider.crypto.md.SHA384");
        this.put("MessageDigest.SHA512", "com.initech.provider.crypto.md.SHA512");
        this.put("MessageDigest.SHA224", "com.initech.provider.crypto.md.SHA224");
        this.put("Alg.Alias.MessageDigest.SHA1", "SHA-1");
        this.put("MessageDigest.MD5", "com.initech.provider.crypto.md.MD5");
        this.put("MessageDigest.RIPEMD160", "com.initech.provider.crypto.md.RIPEMD160");
        this.put("MessageDigest.SM3", "com.initech.provider.crypto.md.SM3");
        this.put("MessageDigest.SHA3-224", "com.initech.provider.crypto.md.SHA3_224");
        this.put("MessageDigest.SHA3-256", "com.initech.provider.crypto.md.SHA3_256");
        this.put("MessageDigest.SHA3-384", "com.initech.provider.crypto.md.SHA3_384");
        this.put("MessageDigest.SHA3-512", "com.initech.provider.crypto.md.SHA3_512");
        this.put("MessageDigest.LSH256", "com.initech.provider.crypto.md.LSH256_256");
        this.put("MessageDigest.LSH-256", "com.initech.provider.crypto.md.LSH256_256");
        this.put("MessageDigest.LSH256-256", "com.initech.provider.crypto.md.LSH256_256");
        this.put("MessageDigest.LSH256-224", "com.initech.provider.crypto.md.LSH256_224");
        this.put("MessageDigest.LSH512", "com.initech.provider.crypto.md.LSH512_512");
        this.put("MessageDigest.LSH-512", "com.initech.provider.crypto.md.LSH512_512");
        this.put("MessageDigest.LSH512-512", "com.initech.provider.crypto.md.LSH512_512");
        this.put("MessageDigest.LSH512-384", "com.initech.provider.crypto.md.LSH512_384");
        this.put("MessageDigest.LSH512-256", "com.initech.provider.crypto.md.LSH512_256");
        this.put("MessageDigest.LSH512-224", "com.initech.provider.crypto.md.LSH512_224");
        this.put("AlgorithmParameters.KCDSA", "com.initech.provider.crypto.kcdsa.KCDSAParameters");
        this.put("AlgorithmParameters.KCDSA1", "com.initech.provider.crypto.kcdsa.KCDSAParameters");
        this.put("AlgorithmParameterGenerator.KCDSA", "com.initech.provider.crypto.kcdsa.KCDSAParameterGenerator");
        this.put("AlgorithmParameterGenerator.KCDSA1", "com.initech.provider.crypto.kcdsa.KCDSAParameterGenerator");
        this.put("AlgorithmParameters.DSA", "com.initech.provider.crypto.dsa.DSAParameters");
        this.put("AlgorithmParameterGenerator.DSA", "com.initech.provider.crypto.dsa.DSAParameterGenerator");
        this.put("AlgorithmParameters.DH", "com.initech.provider.crypto.dh.DHParameters");
        this.put("AlgorithmParameterGenerator.DH", "com.initech.provider.crypto.dh.DHParameterGenerator");
        this.put("AlgorithmParameters.PBE", "com.initech.provider.crypto.cipher.PBEParameters");
        this.put("AlgorithmParameterGenerator.PBE", "com.initech.provider.crypto.cipher.PBEParameterGenerator");
        this.put("AlgorithmParameters.AES", "com.initech.provider.crypto.cipher.RijndaelParameters");
        this.put("Alg.Alias.AlgorithmParameters.AESecb", "Rijndael");
        this.put("Alg.Alias.AlgorithmParameters.AEScbc", "Rijndael");
        this.put("Alg.Alias.AlgorithmParameters.AESofb", "Rijndael");
        this.put("Alg.Alias.AlgorithmParameters.AEScfb", "Rijndael");
        this.put("AlgorithmParameters.Rijndael", "com.initech.provider.crypto.cipher.RijndaelParameters");
        this.put("Alg.Alias.AlgorithmParameters.Rijndaelecb", "Rijndael");
        this.put("Alg.Alias.AlgorithmParameters.Rijndaelcbc", "Rijndael");
        this.put("Alg.Alias.AlgorithmParameters.Rijndaelofb", "Rijndael");
        this.put("Alg.Alias.AlgorithmParameters.Rijndaelcfb", "Rijndael");
        this.put("AlgorithmParameters.DES", "com.initech.provider.crypto.cipher.DESParameters");
        this.put("Alg.Alias.AlgorithmParameters.DESecb", "DES");
        this.put("Alg.Alias.AlgorithmParameters.DEScbc", "DES");
        this.put("Alg.Alias.AlgorithmParameters.DESofb", "DES");
        this.put("Alg.Alias.AlgorithmParameters.DEScfb", "DES");
        this.put("AlgorithmParameters.SEED", "com.initech.provider.crypto.cipher.SEEDParameters");
        this.put("Alg.Alias.AlgorithmParameters.SEEDecb", "SEED");
        this.put("Alg.Alias.AlgorithmParameters.SEEDcbc", "SEED");
        this.put("Alg.Alias.AlgorithmParameters.SEEDofb", "SEED");
        this.put("Alg.Alias.AlgorithmParameters.SEEDcfb", "SEED");
        this.put("Alg.Alias.AlgorithmParameters.SEEDctr", "SEED");
        this.put("AlgorithmParameters.ARIA", "com.initech.provider.crypto.cipher.ARIAParameters");
        this.put("Alg.Alias.AlgorithmParameters.ARIAecb", "ARIA");
        this.put("Alg.Alias.AlgorithmParameters.ARIAcbc", "ARIA");
        this.put("Alg.Alias.AlgorithmParameters.ARIAofb", "ARIA");
        this.put("Alg.Alias.AlgorithmParameters.ARIAcfb", "ARIA");
        this.put("Alg.Alias.AlgorithmParameters.ARIActr", "ARIA");
        this.put("AlgorithmParameters.LEA", "com.initech.provider.crypto.cipher.LEAParameters");
        this.put("Alg.Alias.AlgorithmParameters.LEAecb", "LEA");
        this.put("Alg.Alias.AlgorithmParameters.LEAcbc", "LEA");
        this.put("Alg.Alias.AlgorithmParameters.LEAofb", "LEA");
        this.put("Alg.Alias.AlgorithmParameters.LEAcfb", "LEA");
        this.put("Alg.Alias.AlgorithmParameters.LEActr", "LEA");
        this.put("AlgorithmParameters.DESede", "com.initech.provider.crypto.cipher.DESedeParameters");
        this.put("Alg.Alias.AlgorithmParameters.DESedeecb", "DESede");
        this.put("Alg.Alias.AlgorithmParameters.DESedecbc", "DESede");
        this.put("Alg.Alias.AlgorithmParameters.DESedeofb", "DESede");
        this.put("Alg.Alias.AlgorithmParameters.DESedecfb", "DESede");
        this.put("AlgorithmParameters.RC2", "com.initech.provider.crypto.cipher.RC2Parameters");
        this.put("Alg.Alias.AlgorithmParameters.RC2cbc", "RC2");
        this.put("Alg.Alias.AlgorithmParameters.RC2ofb", "RC2");
        this.put("Alg.Alias.AlgorithmParameters.RC2cfb", "RC2");
        this.put("AlgorithmParameters.RC5", "com.initech.provider.crypto.cipher.RC5Parameters");
        this.put("Alg.Alias.AlgorithmParameters.RC2cbc", "RC5");
        this.put("Alg.Alias.AlgorithmParameters.RC2ofb", "RC5");
        this.put("Alg.Alias.AlgorithmParameters.RC2cfb", "RC5");
        this.put("Mac.HMACwithHAS160", "com.initech.provider.crypto.mac.HMACwithHAS160");
        this.put("Mac.HMACwithSHA1", "com.initech.provider.crypto.mac.HMACwithSHA1");
        this.put("Alg.Alias.Mac.HmacSHA1", "HMACwithSHA1");
        this.put("Mac.HMACwithMD5", "com.initech.provider.crypto.mac.HMACwithMD5");
        this.put("Alg.Alias.Mac.HmacMD5", "HMACwithMD5");
        this.put("Mac.MACwithDES", "com.initech.provider.crypto.mac.MACwithDES");
        this.put("Mac.MACwithDESede", "com.initech.provider.crypto.mac.MACwithDESede");
        this.put("Mac.MACwithTDES", "com.initech.provider.crypto.mac.MACwithDESede");
        this.put("Mac.PBMAC1", "com.initech.provider.crypto.mac.PBMAC1");
        this.put("Mac.HMACwithSHA224", "com.initech.provider.crypto.mac.HMACwithSHA224");
        this.put("Alg.Alias.Mac.HmacSHA224", "HMACwithSHA224");
        this.put("Mac.HMACwithSHA256", "com.initech.provider.crypto.mac.HMACwithSHA256");
        this.put("Alg.Alias.Mac.HmacSHA256", "HMACwithSHA256");
        this.put("Mac.HMACwithSHA384", "com.initech.provider.crypto.mac.HMACwithSHA384");
        this.put("Alg.Alias.Mac.HmacSHA384", "HMACwithSHA384");
        this.put("Mac.HMACwithSHA512", "com.initech.provider.crypto.mac.HMACwithSHA512");
        this.put("Alg.Alias.Mac.HmacSHA512", "HMACwithSHA512");
        this.put("Mac.HMACwithSHA3_224", "com.initech.provider.crypto.mac.HMACwithSHA3_224");
        this.put("Alg.Alias.Mac.HmacSHA3-224", "HMACwithSHA3_224");
        this.put("Mac.HMACwithSHA3_256", "com.initech.provider.crypto.mac.HMACwithSHA3_256");
        this.put("Alg.Alias.Mac.HmacSHA3-256", "HMACwithSHA3_256");
        this.put("Mac.HMACwithSHA3_384", "com.initech.provider.crypto.mac.HMACwithSHA3_384");
        this.put("Alg.Alias.Mac.HmacSHA3-384", "HMACwithSHA3_384");
        this.put("Mac.HMACwithSHA3_512", "com.initech.provider.crypto.mac.HMACwithSHA3_512");
        this.put("Alg.Alias.Mac.HmacSHA3-512", "HMACwithSHA3_512");
        this.put("Mac.HMACwithLSH256_224", "com.initech.provider.crypto.mac.HMACwithLSH256_224");
        this.put("Alg.Alias.Mac.HmacLSH256-224", "HMACwithLSH256_224");
        this.put("Mac.HMACwithLSH256_256", "com.initech.provider.crypto.mac.HMACwithLSH256_256");
        this.put("Alg.Alias.Mac.HmacLSH256-256", "HMACwithLSH256_256");
        this.put("Mac.HMACwithLSH512_224", "com.initech.provider.crypto.mac.HMACwithLSH512_224");
        this.put("Alg.Alias.Mac.HmacLSH512-224", "HMACwithLSH512_224");
        this.put("Mac.HMACwithLSH512_256", "com.initech.provider.crypto.mac.HMACwithLSH512_256");
        this.put("Alg.Alias.Mac.HmacLSH512-256", "HMACwithLSH512_256");
        this.put("Mac.HMACwithLSH512_384", "com.initech.provider.crypto.mac.HMACwithLSH512_384");
        this.put("Alg.Alias.Mac.HmacLSH512-384", "HMACwithLSH512_384");
        this.put("Mac.HMACwithLSH512_512", "com.initech.provider.crypto.mac.HMACwithLSH512_512");
        this.put("Alg.Alias.Mac.HmacLSH512-512", "HMACwithLSH512_512");
        this.put("Mac.HmacSHA1", "com.initech.provider.crypto.mac.HMACwithSHA1");
        this.put("Alg.Alias.Mac.HMACwithSHA1", "HmacSHA1");
        this.put("Mac.HmacSHA224", "com.initech.provider.crypto.mac.HMACwithSHA224");
        this.put("Alg.Alias.Mac.HMACwithSHA224", "HmacSHA224");
        this.put("Mac.HmacSHA256", "com.initech.provider.crypto.mac.HMACwithSHA256");
        this.put("Alg.Alias.Mac.HMACwithSHA256", "HmacSHA256");
        this.put("Mac.HmacSHA384", "com.initech.provider.crypto.mac.HMACwithSHA384");
        this.put("Alg.Alias.Mac.HMACwithSHA384", "HmacSHA384");
        this.put("Mac.HmacSHA512", "com.initech.provider.crypto.mac.HMACwithSHA512");
        this.put("Alg.Alias.Mac.HMACwithSHA512", "HmacSHA512");
        this.put("Mac.HmacSHA3-224", "com.initech.provider.crypto.mac.HMACwithSHA3_224");
        this.put("Alg.Alias.Mac.HMACwithSHA3_224", "HmacSHA3-224");
        this.put("Mac.HmacSHA3-256", "com.initech.provider.crypto.mac.HMACwithSHA3_256");
        this.put("Alg.Alias.Mac.HMACwithSHA3_256", "HmacSHA3-256");
        this.put("Mac.HmacSHA3-384", "com.initech.provider.crypto.mac.HMACwithSHA3_384");
        this.put("Alg.Alias.Mac.HMACwithSHA3_384", "HmacSHA3-384");
        this.put("Mac.HmacSHA3-512", "com.initech.provider.crypto.mac.HMACwithSHA3_512");
        this.put("Alg.Alias.Mac.HMACwithSHA3_512", "HmacSHA3-512");
        this.put("Mac.HmacLSH256-224", "com.initech.provider.crypto.mac.HMACwithLSH256_224");
        this.put("Alg.Alias.Mac.HMACwithLSH256_224", "HmacLSH256-224");
        this.put("Mac.HmacLSH256-256", "com.initech.provider.crypto.mac.HMACwithLSH256_256");
        this.put("Alg.Alias.Mac.HMACwithLSH256_256", "HmacLSH256-256");
        this.put("Mac.HmacLSH512-224", "com.initech.provider.crypto.mac.HMACwithLSH512_224");
        this.put("Alg.Alias.Mac.HMACwithLSH512_224", "HmacLSH512-224");
        this.put("Mac.HmacLSH512-256", "com.initech.provider.crypto.mac.HMACwithLSH512_256");
        this.put("Alg.Alias.Mac.HMACwithLSH512_256", "HmacLSH512-256");
        this.put("Mac.HmacLSH512-384", "com.initech.provider.crypto.mac.HMACwithLSH512_384");
        this.put("Alg.Alias.Mac.HMACwithLSH512_384", "HmacLSH512-384");
        this.put("Mac.HmacLSH512-512", "com.initech.provider.crypto.mac.HMACwithLSH512_512");
        this.put("Alg.Alias.Mac.HMACwithLSH512_512", "HmacLSH512-512");
        this.put("Signature.MD5withRSA", "com.initech.provider.crypto.rsa.MD5withRSA");
        this.put("Signature.SHA1withRSA", "com.initech.provider.crypto.rsa.SHA1withRSA");
        this.put("Signature.RSA", "com.initech.provider.crypto.rsa.NonHashedRSASignature");
        this.put("Signature.NonHashedRSASignature", "com.initech.provider.crypto.rsa.NonHashedRSASignature");
        this.put("Signature.MD5withDSA", "com.initech.provider.crypto.dsa.MD5withDSA");
        this.put("Signature.SHA1withDSA", "com.initech.provider.crypto.dsa.SHA1withDSA");
        this.put("Signature.NonHashedDSA", "com.initech.provider.crypto.dsa.NonHashedDSA");
        this.put("Signature.SHA1withKCDSA", "com.initech.provider.crypto.kcdsa.SHA1withKCDSA");
        this.put("Signature.MD5withKCDSA", "com.initech.provider.crypto.kcdsa.MD5withKCDSA");
        this.put("Signature.HAS160withKCDSA", "com.initech.provider.crypto.kcdsa.HAS160withKCDSA");
        this.put("Signature.SHA1withKCDSA1", "com.initech.provider.crypto.kcdsa.SHA1withKCDSA");
        this.put("Signature.HAS160withKCDSA1", "com.initech.provider.crypto.kcdsa.HAS160withKCDSA");
        this.put("Signature.SHA1withECDSA", "com.initech.provider.crypto.ecdsa.SHA1withECDSA");
        this.put("Signature.SHA224withECDSA", "com.initech.provider.crypto.ecdsa.SHA224withECDSA");
        this.put("Signature.SHA256withECDSA", "com.initech.provider.crypto.ecdsa.SHA256withECDSA");
        this.put("Signature.SHA384withECDSA", "com.initech.provider.crypto.ecdsa.SHA384withECDSA");
        this.put("Signature.SHA512withECDSA", "com.initech.provider.crypto.ecdsa.SHA512withECDSA");
        this.put("Signature.SM3withECDSA", "com.initech.provider.crypto.ecdsa.SM3withECDSA");
        this.put("Signature.SHA1withRSAPSS", "com.initech.provider.crypto.rsa.RSAPSSSignatureSHA1");
        this.put("Signature.SHA256withRSAPSS", "com.initech.provider.crypto.rsa.RSAPSSSignatureSHA256");
        this.put("Signature.SHA1withRSAandMGF1", "com.initech.provider.crypto.rsa.RSAPSSSignatureSHA1");
        this.put("Signature.SHA256withRSAandMGF1", "com.initech.provider.crypto.rsa.RSAPSSSignatureSHA256");
        this.put("Signature.SHA1withRSAPKCS1v1_5", "com.initech.provider.crypto.rsa.RSAPKCS1v15Signature");
        this.put("Signature.SHA224withKCDSA", "com.initech.provider.crypto.kcdsa.SHA224withKCDSA");
        this.put("Signature.SHA256withKCDSA", "com.initech.provider.crypto.kcdsa.SHA256withKCDSA");
        this.put("Signature.SHA224withRSA", "com.initech.provider.crypto.rsa.SHA224withRSA");
        this.put("Signature.SHA256withRSA", "com.initech.provider.crypto.rsa.SHA256withRSA");
        this.put("SecureRandom.FIPS186-2Appendix3", "com.initech.provider.crypto.random.FIPS186_2Appendix3");
        this.put("SecureRandom.X9.17", "com.initech.provider.crypto.random.X9_17");
        this.put("SecureRandom.HashDRBG", "com.initech.provider.crypto.random.HashDRBG");
        this.put("SecureRandom.HASHDRBGSHA1", "com.initech.provider.crypto.random.HASHDRBGSHA1");
        this.put("SecureRandom.HASHDRBGSHA-1", "com.initech.provider.crypto.random.HASHDRBGSHA1");
        this.put("SecureRandom.HASHDRBGSHA224", "com.initech.provider.crypto.random.HASHDRBGSHA224");
        this.put("SecureRandom.HASHDRBGSHA-224", "com.initech.provider.crypto.random.HASHDRBGSHA224");
        this.put("SecureRandom.HASHDRBGSHA256", "com.initech.provider.crypto.random.HASHDRBGSHA256");
        this.put("SecureRandom.HASHDRBGSHA-256", "com.initech.provider.crypto.random.HASHDRBGSHA256");
        this.put("SecureRandom.HASHDRBGSHA384", "com.initech.provider.crypto.random.HASHDRBGSHA384");
        this.put("SecureRandom.HASHDRBGSHA-384", "com.initech.provider.crypto.random.HASHDRBGSHA384");
        this.put("SecureRandom.HASHDRBGSHA512", "com.initech.provider.crypto.random.HASHDRBGSHA512");
        this.put("SecureRandom.HASHDRBGSHA-512", "com.initech.provider.crypto.random.HASHDRBGSHA512");
        this.put("CertificateFactory.X.509", "com.initech.x509.X509CertificateFactory");
        this.put("Cipher.PBEWithSHA1AndSeedcbc", "com.initech.vendor.kftc.PBEWithSHA1AndSeedcbc");
        this.put("Cipher.PBEWithSHA1AndSeedcbcKICA", "com.initech.vendor.kica.PBEWithSHA1AndSeedcbc");
        this.put("Cipher.PBEWithMD2AndDES", "com.initech.provider.crypto.cipher.PBEWithMD2AndDES");
        this.put("Cipher.PBEWithMD5AndDES", "com.initech.provider.crypto.cipher.PBEWithMD5AndDES");
        this.put("Cipher.PBEWithSHA1AndDES", "com.initech.provider.crypto.cipher.PBEWithSHA1AndDES");
        this.put("Cipher.PBEWithMD2AndRC2", "com.initech.provider.crypto.cipher.PBEWithMD2AndRC2");
        this.put("Cipher.PBEWithMD5AndRC2", "com.initech.provider.crypto.cipher.PBEWithMD5AndRC2");
        this.put("Cipher.PBEWithSHA1AndRC2", "com.initech.provider.crypto.cipher.PBEWithSHA1AndRC2");
        this.put("Cipher.PBEWithSHAAnd3KeyTripleDES", "com.initech.provider.crypto.cipher.PBEWithSHAAnd3KeyTripleDES");
        this.put("Cipher.PBEWithSHAAnd2KeyTripleDES", "com.initech.provider.crypto.cipher.PBEWithSHAAnd2KeyTripleDES");
        this.put("Cipher.PBEWithSHAAnd128BitRC2", "com.initech.provider.crypto.cipher.PBEWithSHAAnd128BitRC2");
        this.put("Cipher.PBEWithSHAAnd40BitRC2", "com.initech.provider.crypto.cipher.PBEWithSHAAnd40BitRC2");
        this.put("Cipher.PBES2", "com.initech.provider.crypto.cipher.PBES2");
        this.put("SecretKeyFactory.PBEWithSHAAnd3KeyTripleDES", "com.initech.provider.crypto.cipher.PKCS5KeyFactory");
        this.put("SecretKeyFactory.PBEWithSHAAnd2KeyTripleDES", "com.initech.provider.crypto.cipher.PKCS5KeyFactory");
        this.put("SecretKeyFactory.PBEWithSHAAnd128BitRC2", "com.initech.provider.crypto.cipher.PKCS5KeyFactory");
        this.put("SecretKeyFactory.PBEWithSHAAnd40BitRC2", "com.initech.provider.crypto.cipher.PKCS5KeyFactory");
        this.put("AlgorithmParameters.PBE", "com.initech.provider.crypto.cipher.PBEParameters");
        this.put("AlgorithmParameterGenerator.PBE", "com.initech.provider.crypto.cipher.PBEParameterGenerator");
        this.put("SecretKeyFactory.PKCS5", "com.initech.provider.crypto.cipher.PKCS5KeyFactory");
        this.put("AlgorithmParameters.PEOBE", "com.initech.provider.crypto.cipher.PEOBEParameters");
        this.put("Cipher.PEOBEWithSHA1AndSeedcbc", "com.initech.vendor.initech.PEOBEWithSHA1AndSeedcbc");
    }

    public static final Object getImplementation(String alias, String engineType, Provider provider) throws NoSuchAlgorithmException {
        Object theObject;
        SelfTest.checkKSXRunnable();
        String key = engineType + "." + alias;
        String className = provider.getProperty(key);
        if (className == null) {
            key = "Alg.Alias." + engineType + "." + alias;
            String realName = provider.getProperty(key);
            if (realName != null) {
                Object theObject2 = InitechProvider.getImplementation(realName, engineType, provider);
                return theObject2;
            }
            throw new NoSuchAlgorithmException("No such entry in provider db :" + engineType + "." + alias);
        }
        try {
            theObject = Class.forName(className).newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new NoSuchAlgorithmException("Failed to load " + engineType + "." + alias + " specified:" + className);
        }
        return theObject;
    }

    private static final Boolean providerVectorTest() throws NoSuchAlgorithmException, NoSuchProviderException {
        MessageDigest md = MessageDigest.getInstance("SHA256", NAME);
        byte[] input = Hex.parseHexaString("51b85221c6f06d6ef07b752e9473e3ab524da1da");
        String hashedtext = "edd3b2b52cf10582c56491ccce2ee54c9fd429c7e9c7aff2b5456cebabf83715";
        md.update(input, 0, input.length);
        byte[] data = md.digest();
        if (!Arrays.equals(Hex.parseHexaString(hashedtext), data)) {
            throw new KSXRuntimeException("Failed provider vector test(SHA256) ");
        }
        return true;
    }

    static {
        String tmp = System.getProperty("com.initech.crypto.log", "off");
        if (tmp.equalsIgnoreCase("on")) {
            isPrint = true;
        }
    }
}

