/*
 * Decompiled with CFR 0.152.
 */
package com.initech.provider.crypto;

import com.initech.asn1.OIDDictionary;
import com.initech.provider.crypto.InitechProvider;
import java.security.NoSuchAlgorithmException;
import java.security.Security;

public final class Provider
extends java.security.Provider {
    private static final long serialVersionUID = 85766664796092972L;
    public static String NAME = "Initech";
    public static String info = "Initech Security Provider(INISAFE Crypto) v3.1.9, SEED, AES, RSA, DSA, ECDSA, KCDSA, MD5, SHA1, HAS160 etc. support";

    public static void addAsProvider() {
        Security.insertProviderAt(new Provider(), 1);
    }

    public static String getKryptonVersion() {
        return "INISAFE Crypto for Java with JCEX Version 3.1.5";
    }

    public Provider() {
        super(NAME, 2.0, info);
        this.puts();
    }

    private void putBlockCipher(String cipherName, String className) {
        this.put("Cipher." + cipherName + "/ECB/NoPadding", "com.initech.provider.crypto.cipher." + className);
        this.put("Cipher." + cipherName + "/ECB", "com.initech.provider.crypto.cipher." + className + "ecb");
        this.put("Cipher." + cipherName + "/CBC", "com.initech.provider.crypto.cipher." + className + "cbc");
        this.put("Cipher." + cipherName + "/OFB", "com.initech.provider.crypto.cipher." + className + "ofb");
        this.put("Cipher." + cipherName + "/OFBISO", "com.initech.provider.crypto.cipher." + className + "ofbiso");
        this.put("Cipher." + cipherName + "/CFB", "com.initech.provider.crypto.cipher." + className + "cfb");
        this.put("Alg.Alias.Cipher." + cipherName + "/OFB128", cipherName + "/OFBISO");
        this.put("Alg.Alias.Cipher." + cipherName, cipherName + "/ECB");
        this.put("Alg.Alias.Cipher." + cipherName + "ecb", cipherName + "/ECB");
        this.put("Alg.Alias.Cipher." + cipherName + "cbc", cipherName + "/CBC");
        this.put("Alg.Alias.Cipher." + cipherName + "ofb", cipherName + "/OFB");
        this.put("Alg.Alias.Cipher." + cipherName + "ofbiso", cipherName + "/OFBISO");
        this.put("Alg.Alias.Cipher." + cipherName + "ofb128", cipherName + "/OFBISO");
        this.put("Alg.Alias.Cipher." + cipherName + "cfb", cipherName + "/CFB");
        this.put("KeyGenerator." + cipherName, "com.initech.provider.crypto.cipher." + className + "KeyGenerator");
        this.put("Alg.Alias.KeyGenerator." + cipherName + "/ECB", cipherName);
        this.put("Alg.Alias.KeyGenerator." + cipherName + "/CBC", cipherName);
        this.put("Alg.Alias.KeyGenerator." + cipherName + "/OFB", cipherName);
        this.put("Alg.Alias.KeyGenerator." + cipherName + "/CFB", cipherName);
        this.put("Alg.Alias.KeyGenerator." + cipherName + "ecb", cipherName);
        this.put("Alg.Alias.KeyGenerator." + cipherName + "cbc", cipherName);
        this.put("Alg.Alias.KeyGenerator." + cipherName + "ofb", cipherName);
        this.put("Alg.Alias.KeyGenerator." + cipherName + "cfb", cipherName);
        this.put("SecretKeyFactory." + cipherName, "com.initech.provider.crypto.cipher." + className + "KeyFactory");
        this.put("Alg.Alias.SecretKeyFactory." + cipherName + "/ECB", cipherName);
        this.put("Alg.Alias.SecretKeyFactory." + cipherName + "/CBC", cipherName);
        this.put("Alg.Alias.SecretKeyFactory." + cipherName + "/OFB", cipherName);
        this.put("Alg.Alias.SecretKeyFactory." + cipherName + "/CFB", cipherName);
        this.put("Alg.Alias.SecretKeyFactory." + cipherName + "ecb", cipherName);
        this.put("Alg.Alias.SecretKeyFactory." + cipherName + "cbc", cipherName);
        this.put("Alg.Alias.SecretKeyFactory." + cipherName + "ofb", cipherName);
        this.put("Alg.Alias.SecretKeyFactory." + cipherName + "cfb", cipherName);
    }

    private void puts() {
        this.putBlockCipher("SEED", "Seed");
        this.put("SEED/CBC/PKCS5Padding", "com.initech.provider.crypto.cipher.sun.Seedcbcpk5");
        this.putBlockCipher("SSSS", "SSSS");
        this.put("SecretKeyFactory.SSSS", "com.initech.provider.crypto.cipher.SeedKeyFactory");
        this.put("KeyGenerator.SSSS", "com.initech.provider.crypto.cipher.SeedKeyGenerator");
        this.putBlockCipher("SEEDX", "SSSS");
        this.put("SecretKeyFactory.SEEDX", "com.initech.provider.crypto.cipher.SeedKeyFactory");
        this.put("KeyGenerator.SEEDX", "com.initech.provider.crypto.cipher.SeedKeyGenerator");
        this.putBlockCipher("DES", "DES");
        this.putBlockCipher("DESede", "DESede");
        this.putBlockCipher("RC2", "RC2");
        this.putBlockCipher("RC5", "RC5");
        this.putBlockCipher("Rijndael", "Rijndael");
        this.putBlockCipher("AES", "Rijndael");
        this.putBlockCipher("NSEED", "jni.NSeed");
        this.put("Cipher.RC4", "com.initech.provider.crypto.cipher.RC4");
        this.put("Cipher.RSA", "com.initech.provider.crypto.cipher.RSA");
        this.put("Cipher.PBEWithSHA1AndSeedcbc", "com.initech.vendor.kftc.PBEWithSHA1AndSeedcbc");
        this.put("Cipher.PBEWithSHA1AndSeedcbcKICA", "com.initech.vendor.kica.PBEWithSHA1AndSeedcbc");
        this.put("Cipher.PBEWithMD2AndDES", "com.initech.provider.crypto.cipher.PBEWithMD2AndDES");
        this.put("Cipher.PBEWithMD5AndDES", "com.initech.provider.crypto.cipher.PBEWithMD5AndDES");
        this.put("Cipher.PBEWithSHA1AndDES", "com.initech.provider.crypto.cipher.PBEWithSHA1AndDES");
        this.put("Cipher.PBEWithMD2AndRC2", "com.initech.provider.crypto.cipher.PBEWithMD2AndRC2");
        this.put("Cipher.PBEWithMD5AndRC2", "com.initech.provider.crypto.cipher.PBEWithMD5AndRC2");
        this.put("Cipher.PBEWithSHA1AndRC2", "com.initech.provider.crypto.cipher.PBEWithSHA1AndRC2");
        this.put("Cipher.PBEWithSHAAnd3KeyTripleDES", "com.initech.provider.crypto.cipher.PBEWithSHAAnd3KeyTripleDES");
        this.put("Cipher.PBEWithSHAAnd2KeyTripleDES", "com.initech.provider.crypto.cipher.PBEWithSHAAnd2KeyTripleDES");
        this.put("Cipher.PBEWithSHAAnd128BitRC2", "com.initech.provider.crypto.cipher.PBEWithSHAAnd128BitRC2");
        this.put("Cipher.PBEWithSHAAnd40BitRC2", "com.initech.provider.crypto.cipher.PBEWithSHAAnd40BitRC2");
        this.put("Cipher.PBES2", "com.initech.provider.crypto.cipher.PBES2");
        this.put("KeyGenerator.RC4", "com.initech.provider.crypto.cipher.RC4KeyGenerator");
        this.put("KeyAgreement.DH", "com.initech.provider.crypto.dh.DHKeyAgreement");
        this.put("KeyAgreement.ESDH", "com.initech.provider.crypto.dh.ESDHKeyAgreement");
        this.put("KeyPairGenerator.RSA", "com.initech.provider.crypto.rsa.RSAKeyPairGenerator");
        this.put("KeyPairGenerator.KCDSA", "com.initech.provider.crypto.kcdsa.KCDSAKeyPairGenerator");
        this.put("KeyPairGenerator.DH", "com.initech.provider.crypto.dh.DHKeyPairGenerator");
        this.put("KeyPairGenerator.DSA", "com.initech.provider.crypto.dsa.DSAKeyPairGenerator");
        this.put("KeyPairGenerator.ECDSA", "com.initech.provider.crypto.ecdsa.ECDSAKeyPairGenerator");
        this.put("Alg.Alias.KeyPairGenerator.MD5withDSA", "DSA");
        this.put("Alg.Alias.KeyPairGenerator.SHA1withDSA", "DSA");
        this.put("SecretKeyFactory.RC4", "com.initech.provider.crypto.cipher.RC4KeyFactory");
        this.put("SecretKeyFactory.PKCS5", "com.initech.provider.crypto.cipher.PKCS5KeyFactory");
        this.put("SecretKeyFactory.PBEWithSHAAnd3KeyTripleDES", "com.initech.provider.crypto.cipher.PKCS5KeyFactory");
        this.put("SecretKeyFactory.PBEWithSHAAnd2KeyTripleDES", "com.initech.provider.crypto.cipher.PKCS5KeyFactory");
        this.put("SecretKeyFactory.PBEWithSHAAnd128BitRC2", "com.initech.provider.crypto.cipher.PKCS5KeyFactory");
        this.put("SecretKeyFactory.PBEWithSHAAnd40BitRC2", "com.initech.provider.crypto.cipher.PKCS5KeyFactory");
        this.put("SecretKeyFactory.DEScbc", "com.initech.provider.crypto.cipher.DESKeyFactory");
        this.put("SecretKeyFactory.DESedecbc", "com.initech.provider.crypto.cipher.DESedeKeyFactory");
        this.put("SecretKeyFactory.RC2cbc", "com.initech.provider.crypto.cipher.RC2KeyFactory");
        this.put("SecretKeyFactory.RC5cbc", "com.initech.provider.crypto.cipher.RC5KeyFactory");
        this.put("Alg.Alias.SecretKeyFactory.PBEWithSHA1AndDES", "PKCS5");
        this.put("Alg.Alias.SecretKeyFactory.PBEWithSHA1AndRC2", "PKCS5");
        this.put("Alg.Alias.SecretKeyFactory.PBEWithMD5AndDES", "PKCS5");
        this.put("Alg.Alias.SecretKeyFactory.PBEWithMD5AndRC2", "PKCS5");
        this.put("Alg.Alias.SecretKeyFactory.PBEWithMD2AndDES", "PKCS5");
        this.put("Alg.Alias.SecretKeyFactory.PBEWithMD2AndRC2", "PKCS5");
        this.put("Alg.Alias.SecretKeyFactory.PBEWithHmacSHA1AndDES", "PKCS5");
        this.put("Alg.Alias.SecretKeyFactory.PBEWithHmacSHA1AndDESede", "PKCS5");
        this.put("Alg.Alias.SecretKeyFactory.PBEWithHmacSHA1AndDESede3", "PKCS5");
        this.put("Alg.Alias.SecretKeyFactory.PBEWithHmacSHA1AndRC2", "PKCS5");
        this.put("Alg.Alias.SecretKeyFactory.PBEWithHmacSHA1AndRC5", "PKCS5");
        this.put("SecretKeyFactory.HMAC", "com.initech.provider.crypto.mac.HMACKeyFactory");
        this.put("Alg.Alias.SecretKeyFactory.HMACwithSHA1", "HMAC");
        this.put("Alg.Alias.SecretKeyFactory.HMACwithMD5", "HMAC");
        this.put("Alg.Alias.SecretKeyFactory.HMACwithHAS160", "HMAC");
        this.put("Alg.Alias.SecretKeyFactory.MACwithDES", "DES");
        this.put("Alg.Alias.SecretKeyFactory.MACwithDESede", "DESede");
        this.put("KeyFactory.RSA", "com.initech.provider.crypto.rsa.RSAKeyFactory");
        this.put("KeyFactory.KCDSA", "com.initech.provider.crypto.kcdsa.KCDSAKeyFactory");
        this.put("KeyFactory.KCDSA1", "com.initech.provider.crypto.kcdsa.KCDSAKeyFactory");
        this.put("KeyFactory.DH", "com.initech.provider.crypto.dh.DHKeyFactory");
        this.put("KeyFactory.DSA", "com.initech.provider.crypto.dsa.DSAKeyFactory");
        this.put("KeyFactory.ECDSA", "com.initech.provider.crypto.ecdsa.ECDSAKeyFactory");
        this.put("MessageDigest.HAS160", "com.initech.provider.crypto.md.HAS160");
        this.put("MessageDigest.SHA-1", "com.initech.provider.crypto.md.SHA1");
        this.put("Alg.Alias.MessageDigest.SHA1", "SHA-1");
        this.put("MessageDigest.MD5", "com.initech.provider.crypto.md.MD5");
        this.put("MessageDigest.RIPEMD160", "com.initech.provider.crypto.md.RIPEMD160");
        this.put("AlgorithmParameters.KCDSA", "com.initech.provider.crypto.kcdsa.KCDSAParameters");
        this.put("AlgorithmParameters.KCDSA1", "com.initech.provider.crypto.kcdsa.KCDSAParameters");
        this.put("AlgorithmParameterGenerator.KCDSA", "com.initech.provider.crypto.kcdsa.KCDSAParameterGenerator");
        this.put("AlgorithmParameterGenerator.KCDSA1", "com.initech.provider.crypto.kcdsa.KCDSAParameterGenerator");
        this.put("AlgorithmParameters.DSA", "com.initech.provider.crypto.dsa.DSAParameters");
        this.put("AlgorithmParameterGenerator.DSA", "com.initech.provider.crypto.dsa.DSAParameterGenerator");
        this.put("AlgorithmParameters.DH", "com.initech.provider.crypto.dh.DHParameters");
        this.put("AlgorithmParameterGenerator.DH", "com.initech.provider.crypto.dh.DHParameterGenerator");
        this.put("AlgorithmParameters.PBE", "com.initech.provider.crypto.cipher.PBEParameters");
        this.put("AlgorithmParameterGenerator.PBE", "com.initech.provider.crypto.cipher.PBEParameterGenerator");
        this.put("AlgorithmParameters.DES", "com.initech.provider.crypto.cipher.DESParameters");
        this.put("Alg.Alias.AlgorithmParameters.DEScbc", "DES");
        this.put("Alg.Alias.AlgorithmParameters.DESofb", "DES");
        this.put("Alg.Alias.AlgorithmParameters.DEScfb", "DES");
        this.put("AlgorithmParameters.SEED", "com.initech.provider.crypto.cipher.SEEDParameters");
        this.put("Alg.Alias.AlgorithmParameters.SEEDecb", "SEED");
        this.put("Alg.Alias.AlgorithmParameters.SEEDcbc", "SEED");
        this.put("Alg.Alias.AlgorithmParameters.SEEDofb", "SEED");
        this.put("Alg.Alias.AlgorithmParameters.SEEDcfb", "SEED");
        this.put("AlgorithmParameters.DESede", "com.initech.provider.crypto.cipher.DESedeParameters");
        this.put("Alg.Alias.AlgorithmParameters.DESedecbc", "DESede");
        this.put("Alg.Alias.AlgorithmParameters.DESedeofb", "DESede");
        this.put("Alg.Alias.AlgorithmParameters.DESedecfb", "DESede");
        this.put("AlgorithmParameters.RC2", "com.initech.provider.crypto.cipher.RC2Parameters");
        this.put("Alg.Alias.AlgorithmParameters.RC2cbc", "RC2");
        this.put("Alg.Alias.AlgorithmParameters.RC2ofb", "RC2");
        this.put("Alg.Alias.AlgorithmParameters.RC2cfb", "RC2");
        this.put("AlgorithmParameters.RC5", "com.initech.provider.crypto.cipher.RC5Parameters");
        this.put("Alg.Alias.AlgorithmParameters.RC2cbc", "RC5");
        this.put("Alg.Alias.AlgorithmParameters.RC2ofb", "RC5");
        this.put("Alg.Alias.AlgorithmParameters.RC2cfb", "RC5");
        this.put("Mac.HMACwithHAS160", "com.initech.provider.crypto.mac.HMACwithHAS160");
        this.put("Mac.HMACwithSHA1", "com.initech.provider.crypto.mac.HMACwithSHA1");
        this.put("Alg.Alias.Mac.HmacSHA1", "HMACwithSHA1");
        this.put("Mac.HMACwithMD5", "com.initech.provider.crypto.mac.HMACwithMD5");
        this.put("Alg.Alias.Mac.HmacMD5", "HMACwithMD5");
        this.put("Mac.MACwithDES", "com.initech.provider.crypto.mac.MACwithDES");
        this.put("Mac.MACwithDESede", "com.initech.provider.crypto.mac.MACwithDESede");
        this.put("Mac.MACwithTDES", "com.initech.provider.crypto.mac.MACwithDESede");
        this.put("Mac.PBMAC1", "com.initech.provider.crypto.mac.PBMAC1");
        this.put("Signature.MD5withRSA", "com.initech.provider.crypto.rsa.MD5withRSA");
        this.put("Signature.SHA1withRSA", "com.initech.provider.crypto.rsa.SHA1withRSA");
        this.put("Signature.RSA", "com.initech.provider.crypto.rsa.NonHashedRSASignature");
        this.put("Signature.MD5withDSA", "com.initech.provider.crypto.dsa.MD5withDSA");
        this.put("Signature.SHA1withDSA", "com.initech.provider.crypto.dsa.SHA1withDSA");
        this.put("Signature.NonHashedDSA", "com.initech.provider.crypto.dsa.NonHashedDSA");
        this.put("Signature.SHA1withKCDSA", "com.initech.provider.crypto.kcdsa.SHA1withKCDSA");
        this.put("Signature.MD5withKCDSA", "com.initech.provider.crypto.kcdsa.MD5withKCDSA");
        this.put("Signature.HAS160withKCDSA", "com.initech.provider.crypto.kcdsa.HAS160withKCDSA");
        this.put("Signature.SHA1withKCDSA1", "com.initech.provider.crypto.kcdsa.SHA1withKCDSA");
        this.put("Signature.HAS160withKCDSA1", "com.initech.provider.crypto.kcdsa.HAS160withKCDSA");
        this.put("Signature.SHA1withECDSA", "com.initech.provider.crypto.ecdsa.SHA1withECDSA");
        this.put("CertificateFactory.X.509", "com.initech.x509.X509CertificateFactory");
        this.put("SecureRandom.X9.17", "com.initech.provider.crypto.random.X9_17");
    }

    public static final Object getImplementation(String alias, String engineType, Provider provider) throws NoSuchAlgorithmException {
        Object theObject;
        String key = engineType + "." + alias;
        String className = provider.getProperty(key);
        if (className == null) {
            key = "Alg.Alias." + engineType + "." + alias;
            String realName = provider.getProperty(key);
            if (realName != null) {
                Object theObject2 = Provider.getImplementation(realName, engineType, provider);
                return theObject2;
            }
            throw new NoSuchAlgorithmException("No such entry in provider db :" + engineType + "." + alias);
        }
        try {
            theObject = Class.forName(className).newInstance();
        }
        catch (Exception e) {
            throw new NoSuchAlgorithmException("Failed to load " + engineType + "." + alias + " specified:" + className);
        }
        return theObject;
    }

    static {
        Class<OIDDictionary> c = OIDDictionary.class;
        InitechProvider.NAME = "INITECH";
    }
}

