/*
 * Decompiled with CFR 0.152.
 */
package com.initech.provider.crypto;

import com.initech.cryptox.Cipher;
import com.initech.cryptox.KSXRuntimeException;
import com.initech.cryptox.SecretKey;
import com.initech.cryptox.SecretKeyFactory;
import com.initech.cryptox.spec.IvParameterSpec;
import com.initech.cryptox.spec.SecretKeySpec;
import com.initech.cryptox.util.Base64Util;
import com.initech.cryptox.util.Hex;
import com.initech.provider.JarUtils;
import com.initech.provider.crypto.InitechProvider;
import com.initech.provider.crypto.SelfTestCase;
import com.initech.provider.crypto.cipher.Aria;
import com.initech.provider.crypto.cipher.CipherSelfTestCase;
import com.initech.provider.crypto.cipher.RSA;
import com.initech.provider.crypto.cipher.Seed;
import com.initech.provider.crypto.kcdsa.KCDSAPublicKeyImpl;
import com.initech.provider.crypto.kcdsa.KCDSASelfTestCase;
import com.initech.provider.crypto.kcdsa.SHA256withKCDSA;
import com.initech.provider.crypto.mac.MACSelfTestCase;
import com.initech.provider.crypto.md.MDSelfTestCase;
import com.initech.provider.crypto.md.SHA1;
import com.initech.provider.crypto.md.SHA256;
import com.initech.provider.crypto.random.HashDRBG;
import com.initech.provider.crypto.random.RandomSelfTestCase;
import com.initech.provider.crypto.rsa.RSAPSSSignature;
import com.initech.provider.crypto.rsa.RSASignSelfTestCase;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

public final class SelfTest {
    public static final int OFF_STATE = 0;
    public static final int ON_STATE = 1;
    public static final int SELFTEST_STATE = 2;
    public static final int READY_STATE = 3;
    public static final int ERROR_STATE = 4;
    private static final String[] STATE_STRINGS = new String[]{"OFF", "ON", "SELFTEST", "READY", "ERROR"};
    private int state = 1;
    private static SelfTest me = new SelfTest();
    private Throwable failure;
    private static boolean verifiedSelfIntegrity = false;
    private static boolean verifiedSelfLibraryIntegrity = false;
    private static X509Certificate providerCert = null;
    private static final byte[] bytesOfProviderCert = "-----BEGIN CERTIFICATE-----\nMIIDsTCCA2+gAwIBAgICAR8wCwYHKoZIzjgEAwUAMIGQMQswCQYDVQQGEwJVUzEL\nMAkGA1UECBMCQ0ExEjAQBgNVBAcTCVBhbG8gQWx0bzEdMBsGA1UEChMUU3VuIE1p\nY3Jvc3lzdGVtcyBJbmMxIzAhBgNVBAsTGkphdmEgU29mdHdhcmUgQ29kZSBTaWdu\naW5nMRwwGgYDVQQDExNKQ0UgQ29kZSBTaWduaW5nIENBMB4XDTAyMDMwOTAwMzU0\nNVoXDTA3MDMxMzAwMzU0NVowXzEdMBsGA1UEChMUU3VuIE1pY3Jvc3lzdGVtcyBJ\nbmMxIzAhBgNVBAsTGkphdmEgU29mdHdhcmUgQ29kZSBTaWduaW5nMRkwFwYDVQQD\nExBJTklURUNIIENvLiBMdGQuMIIBtzCCASwGByqGSM44BAEwggEfAoGBAP1/U4Ed\ndRIpUt9KnC7s5Of2EbdSPO9EAMMeP4C2USZpRV1AIlH7WT2NWPq/xfW6MPbLm1Vs\n14E7gB00b/JmYLdrmVClpJ+f6AR7ECLCT7up1/63xhv4O1fnxqimFQ8E+4P208Ue\nwwI1VBNaFpEy9nXzrith1yrv8iIDGZ3RSAHHAhUAl2BQjxUjC8yykrmCouuEC/BY\nHPUCgYEA9+GghdabPd7LvKtcNrhXuXmUr7v6OuqC+VdMCz0HgmdRWVeOutRZT+Zx\nBxCBgLRJFnEj6EwoFhO3zwkyjMim4TwWeotUfI0o4KOuHiuzpnWRbqN/C/ohNWLx\n+2J6ASQ7zKTxvqhRkImog9/hWuWfBpKLZl6Ae1UlZAFMO/7PSSoDgYQAAoGATQOn\nr2VJO/xpM2ZmvK6KzQTKbmRNLQVl0xltZIP0XN8YaD0yV/fSmONl11DUcW22OCBO\n5mWv+/WfjebyA91GP1m9tazpGpno2j3biTfIRejE3PIRf1sVdlSrogoZ43U/T7b6\nCSg3Zu2wSVnByy+wO+0mJqovQk/hbPcW2MmyNwajgYcwgYQwEQYJYIZIAYb4QgEB\nBAQDAgQQMA4GA1UdDwEB/wQEAwIF4DAdBgNVHQ4EFgQUWT8rmvp+i5mVy2vf+2N/\n5q/8sWwwHwYDVR0jBBgwFoAUZeL0hsnTTvCRTliiavXYeFqawaYwHwYDVR0RBBgw\nFoEUZ29kc2xvcmRAaW5pdGVjaC5jb20wCwYHKoZIzjgEAwUAAy8AMCwCFB9Y/4sE\nxweLy5H0fTlc0r37sPgkAhQkBsM6XtlTeLyiR33+2yZXNwXfug==\n-----END CERTIFICATE-----".getBytes();
    private static final byte[] bytesOfProviderCert2 = "-----BEGIN CERTIFICATE-----\nMIIDnTCCAoWgAwIBAgIIb71v0k1ijsEwDQYJKoZIhvcNAQELBQAwYDEbMBkGA1UE\nCgwST3JhY2xlIENvcnBvcmF0aW9uMSMwIQYDVQQLDBpKYXZhIFNvZnR3YXJlIENv\nZGUgU2lnbmluZzEcMBoGA1UEAwwTSkNFIENvZGUgU2lnbmluZyBDQTAeFw0yMDAx\nMTAwMTM2MTNaFw0yNTAxMDkwMTM2MTNaMFQxGzAZBgNVBAoMEk9yYWNsZSBDb3Jw\nb3JhdGlvbjEjMCEGA1UECwwaSmF2YSBTb2Z0d2FyZSBDb2RlIFNpZ25pbmcxEDAO\nBgNVBAMMB0lOSVRFQ0gwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQCC\nQBaDB9gSSBUinpnYixDuMkmCTM+iYyP/ZRSeZ7ESmSt7zR9MBg+qFz21vG+dqRx4\ndiZGglnc2ibFOyKpMKwKKoxIq7eARsFOuFhr4PbEGs9ToZSz3+p6IantaU/OsGZp\n1rgH1y18wb6mPG8gnSJyQmwQmUqWHhB/uAgkrIj3t12O7rBLCNQnnRDm9pLnQ7Lw\nBgLxvI8tB/j0XbZjy8DfDUWhWPAwonibVDmbenFSADaUapHh2CdY4vf8Lo5r0fn/\nW8C3FNDk4oABP9BIcHS4p5zONYkpYKfvk6htuD/DLf3FjkqEiPKPQEFDPC9A2XMA\nspD3+vJI8XsxZW8FHOETAgMBAAGjZzBlMB0GA1UdDgQWBBTc1LUNuWhTnX7wd9I/\n0qkEDT4i4DAfBgNVHSMEGDAWgBRZ1QGE0wI7jUGXRpfnpVEHvGwgKzAOBgNVHQ8B\nAf8EBAMCB4AwEwYDVR0lBAwwCgYIKwYBBQUHAwMwDQYJKoZIhvcNAQELBQADggEB\nAHSoupOzV42G/KDOZpUIVTtNTXE+9tIRITC2KX5RpkNT+AoGOtkXbfXrOCsAfg7N\nIDjrSCMwUCJaxO9/sHFymOq0nkDAkqrchtP+yYqVfmt8V1G3UCWNI9tej7zoOOoO\nN0nW20a6DQBA/RTMLGee0FjuoggVbjwQk5vqrwOKspXF5xDOx8bUuxCG6UUDs9jz\nYBWM4RPu8Y8tqgtAkNxeT2GHCYNHoVOJ4AYamAeJ7RlVzBgH+LTnxqvt2AJEO48Q\nzfepOTuXh+/TCJTSoVOzdmSCMdkx8rXg6JWPIEuTxSk0In5+Oj1EYWOs0n0S2c+q\n6Ib5bDctL96UUwTS4XTNVfc=\n-----END CERTIFICATE-----".getBytes();
    private static ArrayList<byte[]> certList = new ArrayList();

    private SelfTest() {
    }

    public static boolean isKSXRunnable() {
        SelfTest.me.state = 3;
        return SelfTest.me.state != 4;
    }

    public static String getStateString() {
        return STATE_STRINGS[SelfTest.me.state];
    }

    public static synchronized boolean completeKSX() {
        try {
            int loop = 0;
            do {
                if (SelfTest.isKSXRunnable()) {
                    return true;
                }
                if (++loop % 10 == 0) {
                    System.out.println("SelfTest waiting......" + loop);
                }
                Thread.sleep(10L);
            } while (loop < 300);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public static void checkKSXRunnable() {
        if (!SelfTest.isKSXRunnable()) {
            KSXRuntimeException e = new KSXRuntimeException("KSX Module State:" + SelfTest.getStateString());
            StackTraceElement[] elements = e.getStackTrace();
            for (int i = 0; i < elements.length; ++i) {
                StackTraceElement element = elements[i];
                if (SelfTest.me.state != 2 || !element.getClassName().equals(SelfTest.class.getName()) || !element.getMethodName().equals("doTest")) continue;
                return;
            }
            if (SelfTest.completeKSX()) {
                return;
            }
            throw e;
        }
    }

    public static Throwable getFailure() {
        return SelfTest.me.failure;
    }

    public static int getState() {
        return SelfTest.me.state;
    }

    protected static void setState(int state) {
        SelfTest.me.state = state;
    }

    public static synchronized void powerUp() {
        boolean ret;
        if (SelfTest.me.state != 1 || (ret = SelfTest.doTest())) {
            // empty if block
        }
    }

    public static boolean doTest() {
        if (InitechProvider.getRole() != 0) {
            throw new KSXRuntimeException("priviliged error");
        }
        return me.test();
    }

    protected static void corruptify() {
        SelfTest.me.state = 4;
    }

    private boolean test() {
        this.state = 2;
        try {
            SelfTest.CoreFunctionTest();
            SelfTestCase[] cases = new SelfTestCase[]{new CipherSelfTestCase(), new MDSelfTestCase(), new MACSelfTestCase(), new RSASignSelfTestCase(), new KCDSASelfTestCase(), new RandomSelfTestCase()};
            for (int i = 0; i < cases.length; ++i) {
                cases[i].selfTest();
            }
            SelfTest.selfIntegrityChecking();
            this.state = 3;
            return true;
        }
        catch (Exception e) {
            this.failure = e;
            this.state = 4;
            throw new KSXRuntimeException(e.getMessage(), e);
        }
    }

    private static final void selfIntegrityChecking() {
        if (verifiedSelfIntegrity) {
            return;
        }
        SelfTest.integrityChecking(InitechProvider.class);
        verifiedSelfIntegrity = true;
    }

    private static final void libraryIntegrityChecking() {
        if (verifiedSelfLibraryIntegrity) {
            return;
        }
        SelfTest.integrityChecking(InitechProvider.class);
        verifiedSelfLibraryIntegrity = true;
    }

    private static final void integrityChecking(final Class target) {
        URL providerURL = (URL)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                CodeSource cs = target.getProtectionDomain().getCodeSource();
                return cs.getLocation();
            }
        });
        if (providerURL == null) {
            throw new KSXRuntimeException("selfIntegrityCheck Failed.");
        }
        JarVerifier jv = new JarVerifier(providerURL);
        try {
            Boolean isVerifySuccess = false;
            certList.add(bytesOfProviderCert);
            certList.add(bytesOfProviderCert2);
            for (int i = 0; i < certList.size(); ++i) {
                byte[] cert = certList.get(i);
                providerCert = SelfTest.setupProviderCert(cert);
                try {
                    jv.verify(providerCert);
                }
                catch (Exception e) {
                    continue;
                }
                jv.verifyKCDSA();
                isVerifySuccess = true;
                break;
            }
            if (!isVerifySuccess.booleanValue()) {
                throw new KSXRuntimeException("selfIntegrityCheck Failed");
            }
        }
        catch (Exception e) {
            throw new KSXRuntimeException("selfIntegrityCheck Failed", e);
        }
        finally {
            try {
                jv.close();
            }
            catch (IOException ie) {}
        }
    }

    private static X509Certificate setupProviderCert(byte[] certificate) throws IOException, CertificateException, NoSuchProviderException {
        CertificateFactory cf = CertificateFactory.getInstance("X.509", InitechProvider.NAME);
        ByteArrayInputStream inStream = new ByteArrayInputStream(certificate);
        X509Certificate cert = (X509Certificate)cf.generateCertificate(inStream);
        inStream.close();
        return cert;
    }

    public static void CoreFunctionTest() throws Exception {
        try {
            BigInteger bi = new BigInteger("1", 16);
            RSA rsa = new RSA();
            Seed seed = new Seed();
            Aria aria = new Aria();
            SHA256 sha256 = new SHA256();
            SHA256withKCDSA sha256kcdsa = new SHA256withKCDSA();
            HashDRBG hdSha256 = new HashDRBG("SHA256");
            RSAPSSSignature sign256 = new RSAPSSSignature(new SHA256());
        }
        catch (KSXRuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new KSXRuntimeException("Core Function Test Error", e);
        }
    }

    static class JarVerifier {
        private URL jarURL = null;
        private JarFile jarFile = null;

        JarVerifier(URL jarURL) {
            this.jarURL = jarURL;
        }

        private JarFile jarFileLoad() throws Exception {
            JarFile jar_file = null;
            URL module_url = this.getClass().getProtectionDomain().getCodeSource().getLocation();
            String jar_file_path = null;
            if (module_url.getProtocol().equals("jar")) {
                jar_file_path = module_url.toURI().getPath();
            } else if (module_url.getProtocol().equals("file")) {
                jar_file_path = module_url.toURI().getPath();
            } else if (module_url.getProtocol().equalsIgnoreCase("vfs")) {
                module_url = new URL("jar:" + module_url.toString().replaceAll("vfs:", "file:") + "!/");
                jar_file_path = module_url.toURI().getPath();
            }
            if (jar_file_path != null) {
                System.out.println("jar_file_path:" + jar_file_path);
                jar_file = new JarFile(jar_file_path);
            }
            return jar_file;
        }

        private JarFile retrieveJarFileFromURL(URL url) throws PrivilegedActionException, MalformedURLException {
            JarFile jf = null;
            this.jarURL = url.getProtocol().equalsIgnoreCase("jar") ? url : (url.getProtocol().equalsIgnoreCase("vfs") ? new URL("jar:" + url.toString().replaceAll("vfs:", "file:") + "!/") : new URL("jar:" + url.toString() + "!/"));
            jf = (JarFile)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    JarURLConnection conn = (JarURLConnection)JarVerifier.this.jarURL.openConnection();
                    conn.setUseCaches(false);
                    return conn.getJarFile();
                }
            });
            return jf;
        }

        public void verify(X509Certificate targetCert) throws IOException {
            if (targetCert == null) {
                throw new SecurityException("Provider certificate is invalid");
            }
            try {
                this.jarFile = this.jarFileLoad();
            }
            catch (Exception ex) {
                SecurityException se = new SecurityException();
                se.initCause(ex);
                throw se;
            }
            Vector<JarEntry> entriesVec = new Vector<JarEntry>();
            Manifest man = this.jarFile.getManifest();
            if (man == null) {
                throw new SecurityException("The provider is not signed");
            }
            byte[] buffer = new byte[8192];
            Enumeration<JarEntry> entries = this.jarFile.entries();
            while (entries.hasMoreElements()) {
                int n;
                JarEntry je = entries.nextElement();
                if (je.isDirectory()) continue;
                entriesVec.addElement(je);
                InputStream is = this.jarFile.getInputStream(je);
                while ((n = is.read(buffer, 0, buffer.length)) != -1) {
                }
                is.close();
            }
            Enumeration e = entriesVec.elements();
            while (e.hasMoreElements()) {
                X509Certificate[] certChain;
                JarEntry je = (JarEntry)e.nextElement();
                Certificate[] certs = je.getCertificates();
                if (certs == null || certs.length == 0) {
                    if (je.getName().startsWith("META-INF")) continue;
                    throw new SecurityException("The provider has unsigned class files.");
                }
                int startIndex = 0;
                boolean signedAsExpected = false;
                while ((certChain = JarVerifier.getAChain(certs, startIndex)) != null) {
                    if (certChain[0].equals(targetCert)) {
                        signedAsExpected = true;
                        break;
                    }
                    startIndex += certChain.length;
                }
                if (signedAsExpected) continue;
                throw new SecurityException("The provider is not signed by a trusted signer");
            }
        }

        private static X509Certificate[] getAChain(Certificate[] certs, int startIndex) {
            int i;
            if (startIndex > certs.length - 1) {
                return null;
            }
            for (i = startIndex; i < certs.length - 1 && ((Object)((X509Certificate)certs[i + 1]).getSubjectDN()).equals(((X509Certificate)certs[i]).getIssuerDN()); ++i) {
            }
            int certChainSize = i - startIndex + 1;
            X509Certificate[] ret = new X509Certificate[certChainSize];
            for (int j = 0; j < certChainSize; ++j) {
                ret[j] = (X509Certificate)certs[startIndex + j];
            }
            return ret;
        }

        void verifyKCDSA() throws KSXRuntimeException {
            try {
                if (this.jarFile == null) {
                    return;
                }
                byte[] buf = new byte[4096];
                ByteBuffer classBuffer = ByteBuffer.allocate(0x1400000);
                BigInteger P = new BigInteger("00A507E5D03D2561A6C046E28F5CBFDDEE1E128400012C35CA24E2CDB9F0636C85777C0F1AC78DD44B5778468210FDDB5247FFCAAFAFBC04AB3C98E3BDCE71124AE13642E16A90506C1711CA0AEFE78A4285C42005157D8B992C0183CA97F22AAC33F96C3955369F73931CB07B3E19CA37E908C11356C7AD0918F9675A24BE4D3926C3F20BBBEAB1C9702FFB32FC637A4C57C1C083F4E5B45AEDD152F8BE7057AFF831BA3A2302CB16B22D6D8FA74AF2ABE79FC86AA8089F7BC29FD09F9A22DF83A4DA0EB00F5BDD847B7504215CCC58EB62B0E585C1475417E07BB098D158820F073A1EC47B879D3C3BBE995E5861D7A933FAD32DBCE69976157D19121A6BC347", 16);
                BigInteger Q = new BigInteger("009CC3FE5F93224CC5045E7841FA52812F609F98452E2105E5D7660503", 16);
                BigInteger G = new BigInteger("00954186EBDEE4D20610CBD12E034A487660705ADB2895F3CC9997F06AE045F86901712708E145CFD0633E5861C064E667D27661ABDB961DD998D2837A12BAA62561B58BE2FBDF64603CBE5AF5D4F9A7FB559C6D97624F21E93A1EA907264B9F55FAA00C0CF6874858571CA9E6B1D6B2C58F8700B31DEC69801E695C40433DF1AAD001253A7996A0C3B46E31104BCF23E4C03856276EBDAA66F93DB5DD40FE51E84F127863F76D8AEACDDF735D077AC2E99C1E21CBED039C2B57165F48DA18DB30BE2E6352D3DB88305544C844A2A7B634A5719354656B746550E53A7074CE0293003100D2A7BF5BFA7E16DB1E75FB97CEDDE1221CA7B40A0892150D0D3D89906E", 16);
                BigInteger Y = new BigInteger("001F19AFA9AEF53BB0DE77CFB95217C9B7F097F0A9562645CC5D1A0AAFCF66133DC663BA3FD953B3A31E1D8E045347F15B8CA9B69FCE036F28337172197843EF326CB947E1258009E037884B63F07EB1AE515A22DC82AEB2D35CC19BD226BB56B591152F7D1CDA0B709ACFE2523A1D6B387F3AED10B1BE860130AD18573C5E53BD1E4D897009D895B4B73A348E3E2FBF418450B98C4512801C40ED5B7E2DF6B40ADF36765AA8739111269E0046C78C4BFD161B767339692A3DB150A8D7982D75A44557B8B7F8C06D467089521E75C67FFA894FEE19CFE5396286CE40EC349CC709888912E18417B33E50381BFCE59972B67AF08E3EAD4AB247F13E46B3280306ED", 16);
                KCDSAPublicKeyImpl pubKey = new KCDSAPublicKeyImpl(Y, P, Q, G);
                SHA256withKCDSA kcdsa = new SHA256withKCDSA();
                kcdsa.initVerify(pubKey);
                Enumeration<JarEntry> enu = this.jarFile.entries();
                while (enu.hasMoreElements()) {
                    int len;
                    String className;
                    JarEntry je = enu.nextElement();
                    String resourceName = je.getName();
                    if (resourceName.length() <= 6 || (className = resourceName.substring(resourceName.length() - 5, resourceName.length())).compareTo("class") != 0) continue;
                    InputStream in = this.jarFile.getInputStream(je);
                    while ((len = in.read(buf)) > 0) {
                        classBuffer.put(buf, 0, len);
                    }
                    in.close();
                }
                classBuffer.flip();
                try {
                    File file = new File("selftest_verify");
                    FileOutputStream fOutStream = new FileOutputStream(file);
                    fOutStream.write(classBuffer.array());
                    fOutStream.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                kcdsa.update(classBuffer.array(), 0, classBuffer.array().length);
                boolean b = kcdsa.verify(this.readKcdsaSignature());
                if (!b) {
                    throw new KSXRuntimeException("verify[KCDSA] Failed");
                }
            }
            catch (KSXRuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new KSXRuntimeException("selfIntegrityCheck[KCDSA] Failed", e);
            }
        }

        private boolean verifySignature(String sigFileName) throws KSXRuntimeException {
            try {
                int len;
                byte[] msg = "001F19AFA9AEF53BB0DE77CFB95217C9B7F097F0A9562645CC5D1A0AAFCF66133DC663BA3FD953B3A31E1D8E045347F15B8CA9B69FCE036F28337172197843EF326CB947E1258009E037884B63F07EB1AE515A22DC82AEB2D35CC19BD226BB56B591152F7D1CDA0B709ACFE2523A1D6B387F3AED10B1BE860130AD18573C5E53BD1E4D897009D895B4B73A348E3E2FBF418450B98C4512801C40ED5B7E2DF6B40ADF36765AA8739111269E0046C78C4BFD161B767339692A3DB150A8D7982D75A44557B8B7F8C06D467089521E75C67FFA894FEE19CFE5396286CE40EC349CC709888912E18417B33E50381BFCE59972B67AF08E3EAD4AB247F13E46B3280306ED".getBytes();
                MessageDigest md = null;
                md = MessageDigest.getInstance("SHA256", InitechProvider.NAME);
                md.update(bytesOfProviderCert);
                byte[] kek = md.digest();
                md.update(kek);
                byte[] iv = md.digest();
                SecretKeyFactory secretFactory = SecretKeyFactory.getInstance("ARIA", "Initech");
                SecretKeySpec scretSpec = new SecretKeySpec(kek, "ARIA");
                SecretKey sk = secretFactory.generateSecret(scretSpec);
                Cipher cipher = Cipher.getInstance("ARIA/ECB/PKCS5Padding", "Initech");
                cipher.init(1, (Key)sk, new IvParameterSpec(iv));
                byte[] cipherData = cipher.doFinal(msg);
                cipher.init(2, (Key)sk, new IvParameterSpec(iv));
                byte[] byteY = cipher.doFinal(cipherData);
                String hexStringY = Hex.byteArrayToHex(byteY);
                BigInteger Y = new BigInteger(hexStringY, 16);
                BigInteger P = new BigInteger("00A507E5D03D2561A6C046E28F5CBFDDEE1E128400012C35CA24E2CDB9F0636C85777C0F1AC78DD44B5778468210FDDB5247FFCAAFAFBC04AB3C98E3BDCE71124AE13642E16A90506C1711CA0AEFE78A4285C42005157D8B992C0183CA97F22AAC33F96C3955369F73931CB07B3E19CA37E908C11356C7AD0918F9675A24BE4D3926C3F20BBBEAB1C9702FFB32FC637A4C57C1C083F4E5B45AEDD152F8BE7057AFF831BA3A2302CB16B22D6D8FA74AF2ABE79FC86AA8089F7BC29FD09F9A22DF83A4DA0EB00F5BDD847B7504215CCC58EB62B0E585C1475417E07BB098D158820F073A1EC47B879D3C3BBE995E5861D7A933FAD32DBCE69976157D19121A6BC347", 16);
                BigInteger Q = new BigInteger("009CC3FE5F93224CC5045E7841FA52812F609F98452E2105E5D7660503", 16);
                BigInteger G = new BigInteger("00954186EBDEE4D20610CBD12E034A487660705ADB2895F3CC9997F06AE045F86901712708E145CFD0633E5861C064E667D27661ABDB961DD998D2837A12BAA62561B58BE2FBDF64603CBE5AF5D4F9A7FB559C6D97624F21E93A1EA907264B9F55FAA00C0CF6874858571CA9E6B1D6B2C58F8700B31DEC69801E695C40433DF1AAD001253A7996A0C3B46E31104BCF23E4C03856276EBDAA66F93DB5DD40FE51E84F127863F76D8AEACDDF735D077AC2E99C1E21CBED039C2B57165F48DA18DB30BE2E6352D3DB88305544C844A2A7B634A5719354656B746550E53A7074CE0293003100D2A7BF5BFA7E16DB1E75FB97CEDDE1221CA7B40A0892150D0D3D89906E", 16);
                KCDSAPublicKeyImpl pubKey = new KCDSAPublicKeyImpl(Y, P, Q, G);
                SHA256withKCDSA sha256kcdsa = new SHA256withKCDSA();
                sha256kcdsa.initVerify(pubKey);
                JarEntry jarEntry = this.jarFile.getJarEntry(sigFileName);
                InputStream in = this.jarFile.getInputStream(jarEntry);
                byte[] buf = new byte[4096];
                while ((len = in.read(buf)) > 0) {
                    sha256kcdsa.update(buf, 0, len);
                }
                in.close();
                byte[] signature = this.readKcdsaSignature();
                return sha256kcdsa.verify(signature);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new KSXRuntimeException("selfIntegrityCheck KCDSA Signature Error", e);
            }
        }

        private byte[] readKcdsaSignature() throws IOException {
            int len;
            JarEntry jarEntry = this.jarFile.getJarEntry("META-INF/INITECH.KCDSA");
            InputStream in = this.jarFile.getInputStream(jarEntry);
            byte[] buf = new byte[4096];
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            while ((len = in.read(buf)) > 0) {
                out.write(buf, 0, len);
            }
            in.close();
            out.close();
            return out.toByteArray();
        }

        private byte[] jarMANIFEST() throws IOException {
            int len;
            JarEntry jarEntry = this.jarFile.getJarEntry("META-INF/MANIFEST.MF");
            InputStream in = this.jarFile.getInputStream(jarEntry);
            byte[] buf = new byte[4096];
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            while ((len = in.read(buf)) > 0) {
                out.write(buf, 0, len);
            }
            in.close();
            out.close();
            return out.toByteArray();
        }

        private boolean verifyEntries(String name2) throws IOException, NoSuchAlgorithmException, NoSuchProviderException {
            String hash;
            Map.Entry me;
            String name;
            JarEntry jarEntry = this.jarFile.getJarEntry(name2);
            InputStream in = this.jarFile.getInputStream(jarEntry);
            Attributes attr = new Attributes();
            HashMap entries = new HashMap();
            JarUtils.readMFManifest(attr, entries, in);
            boolean result = false;
            Set entrySet = entries.entrySet();
            Iterator it = entrySet.iterator();
            while (it.hasNext() && (result = this.verifyEntry(name = (String)(me = it.next()).getKey(), hash = (attr = (Attributes)me.getValue()).getValue("SHA1-Digest")))) {
            }
            in.close();
            return result;
        }

        private boolean verifyEntry(String name, String hash) throws IOException, NoSuchAlgorithmException, NoSuchProviderException {
            String expectedValue = this.getEntryHash(name);
            boolean result = expectedValue.equals(hash);
            return result;
        }

        private String getEntryHash(String entryName) throws IOException, NoSuchAlgorithmException, NoSuchProviderException {
            JarEntry manifest = this.jarFile.getJarEntry(entryName);
            InputStream in = this.jarFile.getInputStream(manifest);
            return this.hashStream(in);
        }

        private String hashStream(InputStream stream) throws NoSuchAlgorithmException, NoSuchProviderException, IOException {
            int n;
            SHA1 sha = new SHA1();
            BufferedInputStream bis = new BufferedInputStream(stream, 4096);
            byte[] buffer = new byte[4096];
            int count = 0;
            while ((n = bis.read(buffer)) != -1) {
                if (n <= 0) continue;
                sha.update(buffer, 0, n);
                count += n;
            }
            byte[] hash = sha.digest();
            String result = this.base64encode(hash);
            bis.close();
            return result;
        }

        private String base64encode(byte[] buf) {
            try {
                return new String(Base64Util.encode(buf)).trim();
            }
            catch (IOException e) {
                return null;
            }
        }

        protected void close() throws IOException {
            if (this.jarFile != null) {
                this.jarFile.close();
            }
        }
    }
}

