/*
 * Decompiled with CFR 0.152.
 */
package com.initech.provider.crypto.cipher;

import com.initech.cryptox.IllegalBlockSizeException;
import com.initech.provider.crypto.cipher.BlockCipher;
import java.security.InvalidKeyException;
import java.security.Key;

public class Aria
extends BlockCipher {
    protected static final int BLOCK_SIZE = 16;
    private static final char[] HEX_DIGITS;
    private static final int[][] KRK;
    private static final byte[] S1;
    private static final byte[] S2;
    private static final byte[] X1;
    private static final byte[] X2;
    private static final int[] TS1;
    private static final int[] TS2;
    private static final int[] TX1;
    private static final int[] TX2;
    private int keySize = 0;
    private int numberOfRounds = 0;
    private byte[] masterKey = null;
    private int[] encRoundKeys = null;
    private int[] decRoundKeys = null;

    public Aria() {
        this.setBlockSize(16);
    }

    private void reset() {
        this.keySize = 0;
        this.numberOfRounds = 0;
        this.masterKey = null;
        this.encRoundKeys = null;
        this.decRoundKeys = null;
    }

    public int getKeySize() {
        return this.keySize;
    }

    protected int encryptBlock(byte[] input, int inputOffset, int inputLength, byte[] output, int outputOffset) throws IllegalBlockSizeException {
        Aria.doCrypt(input, inputOffset, this.encRoundKeys, this.numberOfRounds, output, outputOffset);
        return inputLength;
    }

    protected int decryptBlock(byte[] input, int inputOffset, int inputLength, byte[] output, int outputOffset) {
        Aria.doCrypt(input, inputOffset, this.decRoundKeys, this.numberOfRounds, output, outputOffset);
        return inputLength;
    }

    protected void setKey(Key key) throws InvalidKeyException {
        if (key == null) {
            throw new InvalidKeyException("Input key is null.('ARIA ???\u7531\u044a????\u317b? 128,192,256 bit \uf9cd?\uf9de???\u2478???')");
        }
        byte[] keyEnc = key.getEncoded();
        if (keyEnc.length != 16 && keyEnc.length != 24 && keyEnc.length != 32) {
            throw new InvalidKeyException("Invaild key size.('ARIA ???\u7531\u044a????\u317b? 128,192,256 bit \uf9cd?\uf9de???\u2478???') Input Key Size : " + keyEnc.length * 16);
        }
        this.reset();
        this.keySize = keyEnc.length * 8;
        switch (this.keySize) {
            case 128: {
                this.numberOfRounds = 12;
                break;
            }
            case 192: {
                this.numberOfRounds = 14;
                break;
            }
            case 256: {
                this.numberOfRounds = 16;
            }
        }
        this.decRoundKeys = null;
        this.encRoundKeys = null;
        this.masterKey = (byte[])keyEnc.clone();
        this.setupEncRoundKeys();
        this.setupDecRoundKeys();
    }

    private void setupEncRoundKeys() throws InvalidKeyException {
        if (this.keySize == 0) {
            throw new InvalidKeyException("keySize");
        }
        if (this.masterKey == null) {
            throw new InvalidKeyException("masterKey");
        }
        if (this.encRoundKeys == null) {
            this.encRoundKeys = new int[4 * (this.numberOfRounds + 1)];
        }
        this.decRoundKeys = null;
        Aria.doEncKeySetup(this.masterKey, this.encRoundKeys, this.keySize);
    }

    private void setupDecRoundKeys() throws InvalidKeyException {
        if (this.keySize == 0) {
            throw new InvalidKeyException("keySize");
        }
        if (this.encRoundKeys == null) {
            if (this.masterKey == null) {
                throw new InvalidKeyException("masterKey");
            }
            this.setupEncRoundKeys();
        }
        this.decRoundKeys = (int[])this.encRoundKeys.clone();
        Aria.doDecKeySetup(this.masterKey, this.decRoundKeys, this.keySize);
    }

    private static void doCrypt(byte[] i, int ioffset, int[] rk, int nr, byte[] o, int ooffset) {
        int j = 0;
        int t0 = Aria.toInt(i[0 + ioffset], i[1 + ioffset], i[2 + ioffset], i[3 + ioffset]);
        int t1 = Aria.toInt(i[4 + ioffset], i[5 + ioffset], i[6 + ioffset], i[7 + ioffset]);
        int t2 = Aria.toInt(i[8 + ioffset], i[9 + ioffset], i[10 + ioffset], i[11 + ioffset]);
        int t3 = Aria.toInt(i[12 + ioffset], i[13 + ioffset], i[14 + ioffset], i[15 + ioffset]);
        for (int r = 1; r < nr / 2; ++r) {
            t0 ^= rk[j++];
            t1 ^= rk[j++];
            t2 ^= rk[j++];
            t3 ^= rk[j++];
            t0 = TS1[t0 >>> 24 & 0xFF] ^ TS2[t0 >>> 16 & 0xFF] ^ TX1[t0 >>> 8 & 0xFF] ^ TX2[t0 & 0xFF];
            t1 = TS1[t1 >>> 24 & 0xFF] ^ TS2[t1 >>> 16 & 0xFF] ^ TX1[t1 >>> 8 & 0xFF] ^ TX2[t1 & 0xFF];
            t2 = TS1[t2 >>> 24 & 0xFF] ^ TS2[t2 >>> 16 & 0xFF] ^ TX1[t2 >>> 8 & 0xFF] ^ TX2[t2 & 0xFF];
            t3 = TS1[t3 >>> 24 & 0xFF] ^ TS2[t3 >>> 16 & 0xFF] ^ TX1[t3 >>> 8 & 0xFF] ^ TX2[t3 & 0xFF];
            t1 ^= t2;
            t2 ^= t3;
            t3 ^= t1;
            t2 ^= (t0 ^= t1);
            t1 ^= t2;
            t1 = Aria.badc(t1);
            t2 = Aria.cdab(t2);
            t3 = Aria.dcba(t3);
            t1 ^= t2;
            t2 ^= t3;
            t3 ^= t1;
            t2 ^= (t0 ^= t1);
            t1 ^= t2;
            t0 ^= rk[j++];
            t1 ^= rk[j++];
            t2 ^= rk[j++];
            t3 ^= rk[j++];
            t0 = TX1[t0 >>> 24 & 0xFF] ^ TX2[t0 >>> 16 & 0xFF] ^ TS1[t0 >>> 8 & 0xFF] ^ TS2[t0 & 0xFF];
            t1 = TX1[t1 >>> 24 & 0xFF] ^ TX2[t1 >>> 16 & 0xFF] ^ TS1[t1 >>> 8 & 0xFF] ^ TS2[t1 & 0xFF];
            t2 = TX1[t2 >>> 24 & 0xFF] ^ TX2[t2 >>> 16 & 0xFF] ^ TS1[t2 >>> 8 & 0xFF] ^ TS2[t2 & 0xFF];
            t3 = TX1[t3 >>> 24 & 0xFF] ^ TX2[t3 >>> 16 & 0xFF] ^ TS1[t3 >>> 8 & 0xFF] ^ TS2[t3 & 0xFF];
            t1 ^= t2;
            t2 ^= t3;
            t3 ^= t1;
            t2 ^= (t0 ^= t1);
            t1 ^= t2;
            t3 = Aria.badc(t3);
            t0 = Aria.cdab(t0);
            t1 = Aria.dcba(t1);
            t1 ^= t2;
            t2 ^= t3;
            t3 ^= t1;
            t2 ^= (t0 ^= t1);
            t1 ^= t2;
        }
        t0 ^= rk[j++];
        t1 ^= rk[j++];
        t2 ^= rk[j++];
        t3 ^= rk[j++];
        t0 = TS1[t0 >>> 24 & 0xFF] ^ TS2[t0 >>> 16 & 0xFF] ^ TX1[t0 >>> 8 & 0xFF] ^ TX2[t0 & 0xFF];
        t1 = TS1[t1 >>> 24 & 0xFF] ^ TS2[t1 >>> 16 & 0xFF] ^ TX1[t1 >>> 8 & 0xFF] ^ TX2[t1 & 0xFF];
        t2 = TS1[t2 >>> 24 & 0xFF] ^ TS2[t2 >>> 16 & 0xFF] ^ TX1[t2 >>> 8 & 0xFF] ^ TX2[t2 & 0xFF];
        t3 = TS1[t3 >>> 24 & 0xFF] ^ TS2[t3 >>> 16 & 0xFF] ^ TX1[t3 >>> 8 & 0xFF] ^ TX2[t3 & 0xFF];
        t1 ^= t2;
        t2 ^= t3;
        t3 ^= t1;
        t2 ^= (t0 ^= t1);
        t1 ^= t2;
        t1 = Aria.badc(t1);
        t2 = Aria.cdab(t2);
        t3 = Aria.dcba(t3);
        t1 ^= t2;
        t2 ^= t3;
        t3 ^= t1;
        t2 ^= (t0 ^= t1);
        t1 ^= t2;
        t0 ^= rk[j++];
        t1 ^= rk[j++];
        t2 ^= rk[j++];
        t3 ^= rk[j++];
        o[0 + ooffset] = (byte)(X1[0xFF & t0 >>> 24] ^ rk[j] >>> 24);
        o[1 + ooffset] = (byte)(X2[0xFF & t0 >>> 16] ^ rk[j] >>> 16);
        o[2 + ooffset] = (byte)(S1[0xFF & t0 >>> 8] ^ rk[j] >>> 8);
        o[3 + ooffset] = (byte)(S2[0xFF & t0] ^ rk[j]);
        o[4 + ooffset] = (byte)(X1[0xFF & t1 >>> 24] ^ rk[j + 1] >>> 24);
        o[5 + ooffset] = (byte)(X2[0xFF & t1 >>> 16] ^ rk[j + 1] >>> 16);
        o[6 + ooffset] = (byte)(S1[0xFF & t1 >>> 8] ^ rk[j + 1] >>> 8);
        o[7 + ooffset] = (byte)(S2[0xFF & t1] ^ rk[j + 1]);
        o[8 + ooffset] = (byte)(X1[0xFF & t2 >>> 24] ^ rk[j + 2] >>> 24);
        o[9 + ooffset] = (byte)(X2[0xFF & t2 >>> 16] ^ rk[j + 2] >>> 16);
        o[10 + ooffset] = (byte)(S1[0xFF & t2 >>> 8] ^ rk[j + 2] >>> 8);
        o[11 + ooffset] = (byte)(S2[0xFF & t2] ^ rk[j + 2]);
        o[12 + ooffset] = (byte)(X1[0xFF & t3 >>> 24] ^ rk[j + 3] >>> 24);
        o[13 + ooffset] = (byte)(X2[0xFF & t3 >>> 16] ^ rk[j + 3] >>> 16);
        o[14 + ooffset] = (byte)(S1[0xFF & t3 >>> 8] ^ rk[j + 3] >>> 8);
        o[15 + ooffset] = (byte)(S2[0xFF & t3] ^ rk[j + 3]);
    }

    private static void doEncKeySetup(byte[] mk, int[] rk, int keyBits) {
        int j = 0;
        int[] w0 = new int[4];
        int[] w1 = new int[4];
        int[] w2 = new int[4];
        int[] w3 = new int[4];
        w0[0] = Aria.toInt(mk[0], mk[1], mk[2], mk[3]);
        w0[1] = Aria.toInt(mk[4], mk[5], mk[6], mk[7]);
        w0[2] = Aria.toInt(mk[8], mk[9], mk[10], mk[11]);
        w0[3] = Aria.toInt(mk[12], mk[13], mk[14], mk[15]);
        int q = (keyBits - 128) / 64;
        int t0 = w0[0] ^ KRK[q][0];
        int t1 = w0[1] ^ KRK[q][1];
        int t2 = w0[2] ^ KRK[q][2];
        int t3 = w0[3] ^ KRK[q][3];
        t0 = TS1[t0 >>> 24 & 0xFF] ^ TS2[t0 >>> 16 & 0xFF] ^ TX1[t0 >>> 8 & 0xFF] ^ TX2[t0 & 0xFF];
        t1 = TS1[t1 >>> 24 & 0xFF] ^ TS2[t1 >>> 16 & 0xFF] ^ TX1[t1 >>> 8 & 0xFF] ^ TX2[t1 & 0xFF];
        t2 = TS1[t2 >>> 24 & 0xFF] ^ TS2[t2 >>> 16 & 0xFF] ^ TX1[t2 >>> 8 & 0xFF] ^ TX2[t2 & 0xFF];
        t3 = TS1[t3 >>> 24 & 0xFF] ^ TS2[t3 >>> 16 & 0xFF] ^ TX1[t3 >>> 8 & 0xFF] ^ TX2[t3 & 0xFF];
        t1 ^= t2;
        t2 ^= t3;
        t3 ^= t1;
        t2 ^= (t0 ^= t1);
        t1 ^= t2;
        t1 = Aria.badc(t1);
        t2 = Aria.cdab(t2);
        t3 = Aria.dcba(t3);
        t1 ^= t2;
        t2 ^= t3;
        t3 ^= t1;
        t2 ^= (t0 ^= t1);
        t1 ^= t2;
        if (keyBits > 128) {
            w1[0] = Aria.toInt(mk[16], mk[17], mk[18], mk[19]);
            w1[1] = Aria.toInt(mk[20], mk[21], mk[22], mk[23]);
            if (keyBits > 192) {
                w1[2] = Aria.toInt(mk[24], mk[25], mk[26], mk[27]);
                w1[3] = Aria.toInt(mk[28], mk[29], mk[30], mk[31]);
            } else {
                w1[3] = 0;
                w1[2] = 0;
            }
        } else {
            w1[3] = 0;
            w1[2] = 0;
            w1[1] = 0;
            w1[0] = 0;
        }
        w1[0] = w1[0] ^ t0;
        w1[1] = w1[1] ^ t1;
        w1[2] = w1[2] ^ t2;
        w1[3] = w1[3] ^ t3;
        t0 = w1[0];
        t1 = w1[1];
        t2 = w1[2];
        t3 = w1[3];
        q = q == 2 ? 0 : q + 1;
        t0 ^= KRK[q][0];
        t1 ^= KRK[q][1];
        t2 ^= KRK[q][2];
        t3 ^= KRK[q][3];
        t0 = TX1[t0 >>> 24 & 0xFF] ^ TX2[t0 >>> 16 & 0xFF] ^ TS1[t0 >>> 8 & 0xFF] ^ TS2[t0 & 0xFF];
        t1 = TX1[t1 >>> 24 & 0xFF] ^ TX2[t1 >>> 16 & 0xFF] ^ TS1[t1 >>> 8 & 0xFF] ^ TS2[t1 & 0xFF];
        t2 = TX1[t2 >>> 24 & 0xFF] ^ TX2[t2 >>> 16 & 0xFF] ^ TS1[t2 >>> 8 & 0xFF] ^ TS2[t2 & 0xFF];
        t3 = TX1[t3 >>> 24 & 0xFF] ^ TX2[t3 >>> 16 & 0xFF] ^ TS1[t3 >>> 8 & 0xFF] ^ TS2[t3 & 0xFF];
        t1 ^= t2;
        t2 ^= t3;
        t3 ^= t1;
        t2 ^= (t0 ^= t1);
        t1 ^= t2;
        t3 = Aria.badc(t3);
        t0 = Aria.cdab(t0);
        t1 = Aria.dcba(t1);
        t1 ^= t2;
        t2 ^= t3;
        t3 ^= t1;
        t2 ^= (t0 ^= t1);
        t1 ^= t2;
        w2[0] = t0 ^= w0[0];
        w2[1] = t1 ^= w0[1];
        w2[2] = t2 ^= w0[2];
        w2[3] = t3 ^= w0[3];
        q = q == 2 ? 0 : q + 1;
        t0 ^= KRK[q][0];
        t1 ^= KRK[q][1];
        t2 ^= KRK[q][2];
        t3 ^= KRK[q][3];
        t0 = TS1[t0 >>> 24 & 0xFF] ^ TS2[t0 >>> 16 & 0xFF] ^ TX1[t0 >>> 8 & 0xFF] ^ TX2[t0 & 0xFF];
        t1 = TS1[t1 >>> 24 & 0xFF] ^ TS2[t1 >>> 16 & 0xFF] ^ TX1[t1 >>> 8 & 0xFF] ^ TX2[t1 & 0xFF];
        t2 = TS1[t2 >>> 24 & 0xFF] ^ TS2[t2 >>> 16 & 0xFF] ^ TX1[t2 >>> 8 & 0xFF] ^ TX2[t2 & 0xFF];
        t3 = TS1[t3 >>> 24 & 0xFF] ^ TS2[t3 >>> 16 & 0xFF] ^ TX1[t3 >>> 8 & 0xFF] ^ TX2[t3 & 0xFF];
        t1 ^= t2;
        t2 ^= t3;
        t3 ^= t1;
        t2 ^= (t0 ^= t1);
        t1 ^= t2;
        t1 = Aria.badc(t1);
        t2 = Aria.cdab(t2);
        t3 = Aria.dcba(t3);
        t1 ^= t2;
        t2 ^= t3;
        t3 ^= t1;
        t2 ^= (t0 ^= t1);
        w3[0] = t0 ^ w1[0];
        w3[1] = (t1 ^= t2) ^ w1[1];
        w3[2] = t2 ^ w1[2];
        w3[3] = t3 ^ w1[3];
        Aria.gsrk(w0, w1, 19, rk, j);
        Aria.gsrk(w1, w2, 19, rk, j += 4);
        Aria.gsrk(w2, w3, 19, rk, j += 4);
        Aria.gsrk(w3, w0, 19, rk, j += 4);
        Aria.gsrk(w0, w1, 31, rk, j += 4);
        Aria.gsrk(w1, w2, 31, rk, j += 4);
        Aria.gsrk(w2, w3, 31, rk, j += 4);
        Aria.gsrk(w3, w0, 31, rk, j += 4);
        Aria.gsrk(w0, w1, 67, rk, j += 4);
        Aria.gsrk(w1, w2, 67, rk, j += 4);
        Aria.gsrk(w2, w3, 67, rk, j += 4);
        Aria.gsrk(w3, w0, 67, rk, j += 4);
        Aria.gsrk(w0, w1, 97, rk, j += 4);
        j += 4;
        if (keyBits > 128) {
            Aria.gsrk(w1, w2, 97, rk, j);
            Aria.gsrk(w2, w3, 97, rk, j += 4);
            j += 4;
        }
        if (keyBits > 192) {
            Aria.gsrk(w3, w0, 97, rk, j);
            Aria.gsrk(w0, w1, 109, rk, j += 4);
        }
    }

    private static void doDecKeySetup(byte[] mk, int[] rk, int keyBits) {
        int a = 0;
        int[] t = new int[4];
        int z = 32 + keyBits / 8;
        Aria.swapBlocks(rk, 0, z);
        a += 4;
        z -= 4;
        while (a < z) {
            Aria.swapAndDiffuse(rk, a, z, t);
            a += 4;
            z -= 4;
        }
        Aria.diff(rk, a, t, 0);
        rk[a] = t[0];
        rk[a + 1] = t[1];
        rk[a + 2] = t[2];
        rk[a + 3] = t[3];
    }

    private static int toInt(byte b0, byte b1, byte b2, byte b3) {
        return (b0 & 0xFF) << 24 ^ (b1 & 0xFF) << 16 ^ (b2 & 0xFF) << 8 ^ b3 & 0xFF;
    }

    private static void toByteArray(int i, byte[] b, int offset) {
        b[offset] = (byte)(i >>> 24);
        b[offset + 1] = (byte)(i >>> 16);
        b[offset + 2] = (byte)(i >>> 8);
        b[offset + 3] = (byte)i;
    }

    private static int m(int t) {
        return 65793 * (t >>> 24 & 0xFF) ^ 0x1000101 * (t >>> 16 & 0xFF) ^ 0x1010001 * (t >>> 8 & 0xFF) ^ 0x1010100 * (t & 0xFF);
    }

    private static final int badc(int t) {
        return t << 8 & 0xFF00FF00 ^ t >>> 8 & 0xFF00FF;
    }

    private static final int cdab(int t) {
        return t << 16 & 0xFFFF0000 ^ t >>> 16 & 0xFFFF;
    }

    private static final int dcba(int t) {
        return (t & 0xFF) << 24 ^ (t & 0xFF00) << 8 ^ (t & 0xFF0000) >>> 8 ^ (t & 0xFF000000) >>> 24;
    }

    private static final void gsrk(int[] x, int[] y, int rot, int[] rk, int offset) {
        int q = 4 - rot / 32;
        int r = rot % 32;
        int s = 32 - r;
        rk[offset] = x[0] ^ y[q % 4] >>> r ^ y[(q + 3) % 4] << s;
        rk[offset + 1] = x[1] ^ y[(q + 1) % 4] >>> r ^ y[q % 4] << s;
        rk[offset + 2] = x[2] ^ y[(q + 2) % 4] >>> r ^ y[(q + 1) % 4] << s;
        rk[offset + 3] = x[3] ^ y[(q + 3) % 4] >>> r ^ y[(q + 2) % 4] << s;
    }

    private static final void diff(int[] i, int offset1, int[] o, int offset2) {
        int t0 = Aria.m(i[offset1]);
        int t1 = Aria.m(i[offset1 + 1]);
        int t2 = Aria.m(i[offset1 + 2]);
        int t3 = Aria.m(i[offset1 + 3]);
        t1 ^= t2;
        t2 ^= t3;
        t3 ^= t1;
        t2 ^= (t0 ^= t1);
        t1 ^= t2;
        t1 = Aria.badc(t1);
        t2 = Aria.cdab(t2);
        t3 = Aria.dcba(t3);
        t1 ^= t2;
        t2 ^= t3;
        t3 ^= t1;
        t2 ^= (t0 ^= t1);
        o[offset2] = t0;
        o[offset2 + 1] = t1 ^= t2;
        o[offset2 + 2] = t2;
        o[offset2 + 3] = t3;
    }

    private static final void swapBlocks(int[] arr, int offset1, int offset2) {
        for (int i = 0; i < 4; ++i) {
            int t = arr[offset1 + i];
            arr[offset1 + i] = arr[offset2 + i];
            arr[offset2 + i] = t;
        }
    }

    private static final void swapAndDiffuse(int[] arr, int offset1, int offset2, int[] tmp) {
        Aria.diff(arr, offset1, tmp, 0);
        Aria.diff(arr, offset2, arr, offset1);
        arr[offset2] = tmp[0];
        arr[offset2 + 1] = tmp[1];
        arr[offset2 + 2] = tmp[2];
        arr[offset2 + 3] = tmp[3];
    }

    static {
        int k;
        int s;
        int j;
        int p;
        int t;
        int i;
        int i2;
        HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        KRK = new int[][]{{1367130551, 656542356, -32265240, -90542368}, {1840335564, -1641953248, -14110251, -279059792}, {-611174627, 556198256, 52729717, 82364686}};
        S1 = new byte[256];
        S2 = new byte[256];
        X1 = new byte[256];
        X2 = new byte[256];
        TS1 = new int[256];
        TS2 = new int[256];
        TX1 = new int[256];
        TX2 = new int[256];
        int[] exp = new int[256];
        int[] log = new int[256];
        exp[0] = 1;
        for (i2 = 1; i2 < 256; ++i2) {
            int j2 = exp[i2 - 1] << 1 ^ exp[i2 - 1];
            if ((j2 & 0x100) != 0) {
                j2 ^= 0x11B;
            }
            exp[i2] = j2;
        }
        for (i2 = 1; i2 < 255; ++i2) {
            log[exp[i2]] = i2;
        }
        int[][] A = new int[][]{{1, 0, 0, 0, 1, 1, 1, 1}, {1, 1, 0, 0, 0, 1, 1, 1}, {1, 1, 1, 0, 0, 0, 1, 1}, {1, 1, 1, 1, 0, 0, 0, 1}, {1, 1, 1, 1, 1, 0, 0, 0}, {0, 1, 1, 1, 1, 1, 0, 0}, {0, 0, 1, 1, 1, 1, 1, 0}, {0, 0, 0, 1, 1, 1, 1, 1}};
        int[][] B = new int[][]{{0, 1, 0, 1, 1, 1, 1, 0}, {0, 0, 1, 1, 1, 1, 0, 1}, {1, 1, 0, 1, 0, 1, 1, 1}, {1, 0, 0, 1, 1, 1, 0, 1}, {0, 0, 1, 0, 1, 1, 0, 0}, {1, 0, 0, 0, 0, 0, 0, 1}, {0, 1, 0, 1, 1, 1, 0, 1}, {1, 1, 0, 1, 0, 0, 1, 1}};
        for (i = 0; i < 256; ++i) {
            t = 0;
            p = i == 0 ? 0 : exp[255 - log[i]];
            for (j = 0; j < 8; ++j) {
                s = 0;
                for (k = 0; k < 8; ++k) {
                    if ((p >>> 7 - k & 1) == 0) continue;
                    s ^= A[k][j];
                }
                t = t << 1 ^ s;
            }
            Aria.S1[i] = (byte)(t ^= 0x63);
            Aria.X1[t] = (byte)i;
        }
        for (i = 0; i < 256; ++i) {
            t = 0;
            p = i == 0 ? 0 : exp[247 * log[i] % 255];
            for (j = 0; j < 8; ++j) {
                s = 0;
                for (k = 0; k < 8; ++k) {
                    if ((p >>> k & 1) == 0) continue;
                    s ^= B[7 - j][k];
                }
                t = t << 1 ^ s;
            }
            Aria.S2[i] = (byte)(t ^= 0xE2);
            Aria.X2[t] = (byte)i;
        }
        for (i = 0; i < 256; ++i) {
            Aria.TS1[i] = 65793 * (S1[i] & 0xFF);
            Aria.TS2[i] = 0x1000101 * (S2[i] & 0xFF);
            Aria.TX1[i] = 0x1010001 * (X1[i] & 0xFF);
            Aria.TX2[i] = 0x1010100 * (X2[i] & 0xFF);
        }
    }
}

