/*
 * Decompiled with CFR 0.152.
 */
package com.initech.provider.crypto.cipher;

import com.initech.cryptox.SecretKeyFactorySpi;
import com.initech.cryptox.spec.SecretKeySpec;
import com.initech.provider.AutoJCE;
import com.initech.provider.crypto.cipher.AriaKey;
import com.initech.provider.crypto.spec.AriaKeySpec;
import java.security.InvalidKeyException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import javax.crypto.SecretKey;

public class AriaKeyFactory
extends SecretKeyFactorySpi {
    protected SecretKey engineGenerateSecret(KeySpec keySpec) throws InvalidKeySpecException {
        return this.engineGenerateSecretX(keySpec);
    }

    protected com.initech.cryptox.SecretKey engineGenerateSecretX(KeySpec keySpec) throws InvalidKeySpecException {
        if (keySpec instanceof AriaKeySpec) {
            try {
                return new AriaKey(((AriaKeySpec)keySpec).getKey());
            }
            catch (InvalidKeyException e) {
                throw new InvalidKeySpecException(e.getMessage());
            }
        }
        if (keySpec instanceof javax.crypto.spec.SecretKeySpec) {
            SecretKeySpec skspec = (SecretKeySpec)(keySpec = (KeySpec)AutoJCE.toJCEX(keySpec));
            String alg = skspec.getAlgorithm();
            if (!(alg.toUpperCase().startsWith("ARIA") || alg.toUpperCase().startsWith("ARIAX") || alg.toUpperCase().startsWith("SSSS"))) {
                throw new InvalidKeySpecException("SecretKeySpec not for ARIA");
            }
            if (!"RAW".equals(skspec.getFormat())) {
                throw new InvalidKeySpecException("Unknown encoding format in KeySpec");
            }
            try {
                return new AriaKey(skspec.getEncoded());
            }
            catch (InvalidKeyException e) {
                throw new InvalidKeySpecException(e.getMessage());
            }
        }
        throw new InvalidKeySpecException(keySpec.getClass().getName() + " not valid for ARIA.");
    }

    protected KeySpec engineGetKeySpec(com.initech.cryptox.SecretKey key, Class keySpec) throws InvalidKeySpecException {
        if (key instanceof AriaKey) {
            if (SecretKeySpec.class.isAssignableFrom(keySpec)) {
                return new SecretKeySpec(key.getEncoded(), "ARIA");
            }
            if (AriaKeySpec.class.isAssignableFrom(keySpec)) {
                try {
                    return new AriaKeySpec(key.getEncoded());
                }
                catch (InvalidKeyException e) {
                    throw new InvalidKeySpecException(e.toString());
                }
            }
        }
        throw new InvalidKeySpecException("not implemented");
    }

    protected SecretKey engineTranslateKey(com.initech.cryptox.SecretKey key) throws InvalidKeyException {
        if (!key.getAlgorithm().equals("ARIA")) {
            throw new InvalidKeyException("not a ARIA key");
        }
        return new AriaKey(key.getEncoded());
    }

    protected com.initech.cryptox.SecretKey engineTranslateKeyX(com.initech.cryptox.SecretKey key) throws InvalidKeyException {
        if (!key.getAlgorithm().equals("ARIA")) {
            throw new InvalidKeyException("not a ARIA key");
        }
        return new AriaKey(key.getEncoded());
    }
}

