/*
 * Decompiled with CFR 0.152.
 */
package com.initech.provider.crypto.cipher;

import com.initech.cryptox.BadPaddingException;
import com.initech.cryptox.CipherSpi;
import com.initech.cryptox.IllegalBlockSizeException;
import com.initech.cryptox.NoSuchPaddingException;
import com.initech.cryptox.SecretKeyFactory;
import com.initech.cryptox.ShortBufferException;
import com.initech.cryptox.spec.SecretKeySpec;
import com.initech.provider.crypto.InitechProvider;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;

public abstract class BlockCipher
extends CipherSpi {
    protected int cipherMode;
    protected byte[] bufferedData;
    protected int bufferedLength;
    protected int blockSize;
    protected SecureRandom random = null;

    protected abstract int encryptBlock(byte[] var1, int var2, int var3, byte[] var4, int var5) throws IllegalBlockSizeException;

    protected abstract int decryptBlock(byte[] var1, int var2, int var3, byte[] var4, int var5);

    protected abstract void setKey(Key var1) throws InvalidKeyException;

    protected int _engineGetKeySize(Key key) throws InvalidKeyException {
        byte[] k = key.getEncoded();
        if (k.length != this.blockSize) {
            throw new InvalidKeyException();
        }
        return this.blockSize * 8;
    }

    protected int _engineGetBlockSize() {
        return this.blockSize;
    }

    protected void setBlockSize(int bytes) {
        this.blockSize = bytes;
    }

    protected void checkBufferedData() {
        if (this.bufferedData == null || this.bufferedData.length != this._engineGetBlockSize()) {
            this.bufferedData = new byte[this._engineGetBlockSize()];
            this.bufferedLength = 0;
        }
    }

    protected final int getBufferedDataLength() {
        return this.bufferedLength;
    }

    protected final void getBufferedData(byte[] output, int offset) {
        System.arraycopy(this.bufferedData, 0, output, offset, this.bufferedLength);
        this.bufferedLength = 0;
    }

    protected int addToBufferedData(byte[] input, int offset, int length) {
        System.arraycopy(input, offset, this.bufferedData, this.bufferedLength, length);
        return this.bufferedLength += length;
    }

    protected byte[] _engineGetIV() {
        return null;
    }

    protected int _engineGetOutputSize(int inputLength) {
        int blockSize = this._engineGetBlockSize();
        if (inputLength == 0) {
            return 0;
        }
        if (inputLength % blockSize != 0) {
            return 0;
        }
        return inputLength;
    }

    protected void _engineInit(int opmode, Key key, AlgorithmParameterSpec params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.cipherMode = opmode;
        if (this.cipherMode != 2 && this.cipherMode != 1) {
            throw new InvalidParameterException("Invalid operation mode");
        }
        this.random = random;
        this.setKey(key);
        this.checkBufferedData();
    }

    protected void _engineInit(int opmode, Key key, SecureRandom random) throws InvalidKeyException {
        try {
            this._engineInit(opmode, key, (AlgorithmParameterSpec)null, random);
        }
        catch (InvalidAlgorithmParameterException e) {
            // empty catch block
        }
    }

    protected void _engineInit(int opmode, Key key, AlgorithmParameters params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        try {
            this._engineInit(opmode, key, (AlgorithmParameterSpec)null, random);
        }
        catch (InvalidAlgorithmParameterException e) {
            // empty catch block
        }
    }

    protected void _engineSetPadding(String paddingName) throws NoSuchPaddingException {
        if (!paddingName.equals("NoPadding") && paddingName != null) {
            throw new NoSuchPaddingException("This is NoPadding mode. Cannot change to " + paddingName);
        }
    }

    protected void _engineSetMode(String modeName) throws NoSuchAlgorithmException {
        if (!modeName.equals("ECB") && !modeName.equals("")) {
            throw new NoSuchAlgorithmException("This is ECB mode. Cannot change to " + modeName);
        }
    }

    protected AlgorithmParameters _engineGetParameters() {
        return null;
    }

    protected byte[] _engineUpdate(byte[] input, int inputOffset, int inputLength) {
        int length = 0;
        byte[] out = new byte[this._engineGetOutputSize(inputLength)];
        try {
            length = this._engineUpdate(input, inputOffset, inputLength, out, 0);
        }
        catch (ShortBufferException e) {
            e.printStackTrace();
        }
        if (length < out.length) {
            byte[] shorter = new byte[length];
            System.arraycopy(out, 0, shorter, 0, length);
            out = shorter;
        }
        return out;
    }

    protected int _engineUpdate(byte[] input, int inputOffset, int inputLength, byte[] output, int outputOffset) throws ShortBufferException {
        int outputLength;
        block5: {
            int lastblockOffset;
            int blockSize;
            byte[] totalInput;
            block4: {
                int sBufferLength = this.getBufferedDataLength();
                totalInput = new byte[inputLength + sBufferLength];
                System.arraycopy(this.bufferedData, 0, totalInput, 0, this.bufferedLength);
                this.bufferedLength = 0;
                System.arraycopy(input, inputOffset, totalInput, sBufferLength, inputLength);
                blockSize = this._engineGetBlockSize();
                int lastblockSize = totalInput.length % blockSize;
                lastblockOffset = totalInput.length - lastblockSize;
                outputLength = 0;
                if (this.cipherMode != 1) break block4;
                for (int i = 0; i < lastblockOffset; i += blockSize) {
                    try {
                        outputLength += this.encryptBlock(totalInput, i, blockSize, output, outputOffset + outputLength);
                        continue;
                    }
                    catch (IllegalBlockSizeException e) {
                        throw new ShortBufferException(e.toString());
                    }
                }
                break block5;
            }
            if (this.cipherMode != 2) break block5;
            for (int i = 0; i < lastblockOffset; i += blockSize) {
                outputLength += this.decryptBlock(totalInput, i, blockSize, output, outputOffset + outputLength);
            }
        }
        return outputLength;
    }

    protected byte[] _engineDoFinal(byte[] input, int inputOffset, int inputLength) throws IllegalBlockSizeException, BadPaddingException {
        int length = 0;
        byte[] out = new byte[this._engineGetOutputSize(inputLength)];
        length = this._engineDoFinal(input, inputOffset, inputLength, out, 0);
        if (length < out.length) {
            byte[] shorter = new byte[length];
            System.arraycopy(out, 0, shorter, 0, length);
            out = shorter;
        }
        return out;
    }

    protected int _engineDoFinal(byte[] input, int inputOffset, int inputLength, byte[] output, int outputOffset) throws IllegalBlockSizeException, BadPaddingException {
        int outputLength;
        block8: {
            int end;
            int off;
            block7: {
                outputLength = 0;
                off = inputOffset;
                end = inputOffset + inputLength;
                if (this.bufferedLength > 0) {
                    int tocpy = this.blockSize - this.bufferedLength;
                    if (tocpy > inputLength) {
                        System.arraycopy(input, off, this.bufferedData, this.bufferedLength, inputLength);
                        return 0;
                    }
                    System.arraycopy(input, off, this.bufferedData, this.bufferedLength, tocpy);
                    if (this.cipherMode == 1) {
                        outputLength += this.encryptBlock(this.bufferedData, off, this.blockSize, output, outputOffset);
                    } else if (this.cipherMode == 2) {
                        outputLength += this.decryptBlock(this.bufferedData, off, this.blockSize, output, outputOffset);
                    }
                    this.bufferedLength = 0;
                    off += tocpy;
                    outputOffset += this.blockSize;
                }
                if (this.cipherMode != 1) break block7;
                while (off < end) {
                    outputLength += this.encryptBlock(input, off, this.blockSize, output, outputOffset);
                    off += this.blockSize;
                    outputOffset += this.blockSize;
                }
                break block8;
            }
            if (this.cipherMode != 2) break block8;
            while (off < end) {
                outputLength += this.decryptBlock(input, off, this.blockSize, output, outputOffset);
                off += this.blockSize;
                outputOffset += this.blockSize;
            }
        }
        return outputLength;
    }

    protected byte[] _engineWrap(Key key) throws IllegalBlockSizeException, InvalidKeyException {
        byte[] ret = null;
        try {
            byte[] encKey = key.getEncoded();
            if (encKey == null || encKey.length == 0) {
                throw new InvalidKeyException("Cannot get an encoding of the key to be wrapped");
            }
            ret = this._engineDoFinal(encKey, 0, encKey.length);
        }
        catch (BadPaddingException badPaddingException) {
            // empty catch block
        }
        return ret;
    }

    protected Key _engineUnwrap(byte[] wkey, String alg, int type) throws InvalidKeyException, NoSuchAlgorithmException {
        Key obj = null;
        byte[] decKey = null;
        try {
            decKey = this._engineDoFinal(wkey, 0, wkey.length);
        }
        catch (BadPaddingException ex) {
            throw new InvalidKeyException();
        }
        catch (IllegalBlockSizeException ex) {
            throw new InvalidKeyException();
        }
        SecretKeyFactory sf = null;
        KeyFactory kf = null;
        KeySpec spec = null;
        try {
            switch (type) {
                case 3: {
                    spec = new SecretKeySpec(decKey, alg);
                    sf = SecretKeyFactory.getInstance(alg, InitechProvider.NAME);
                    obj = sf.generateSecret(spec);
                    break;
                }
                case 2: {
                    spec = new PKCS8EncodedKeySpec(decKey);
                    kf = KeyFactory.getInstance(alg, InitechProvider.NAME);
                    obj = kf.generatePrivate(spec);
                    break;
                }
                case 1: {
                    spec = new X509EncodedKeySpec(decKey);
                    kf = KeyFactory.getInstance(alg, InitechProvider.NAME);
                    obj = kf.generatePublic(spec);
                }
            }
        }
        catch (InvalidKeySpecException ex) {
            throw new InvalidKeyException();
        }
        catch (NoSuchProviderException ex) {
            throw new InvalidKeyException();
        }
        return obj;
    }
}

