/*
 * Decompiled with CFR 0.152.
 */
package com.initech.provider.crypto.cipher;

import com.initech.cryptox.Cipher;
import com.initech.provider.crypto.cipher.PaddableWrapper;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.ShortBufferException;

public class CBCWrapper
extends PaddableWrapper {
    protected byte[] amalgam = null;
    protected byte[] ciphertext = null;

    public CBCWrapper(Cipher cipher) {
        super(cipher);
    }

    protected void _engineInit(int opmode, Key key, AlgorithmParameterSpec params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        super._engineInit(opmode, key, params, random);
        this.amalgam = new byte[this.blockSize];
        this.ciphertext = new byte[this.blockSize];
    }

    protected int engineTransformBlock(byte[] input, int inputOffset, int inputLength, byte[] output, int outputOffset) throws com.initech.cryptox.ShortBufferException {
        if (this.cipherMode == 1) {
            int ret = this.encryptBlock(input, inputOffset, inputLength, output, outputOffset);
            return ret;
        }
        if (this.cipherMode == 2) {
            int ret = this.decryptBlock(input, inputOffset, inputLength, output, outputOffset);
            return ret;
        }
        return 0;
    }

    protected int encryptBlock(byte[] in, int inOff, int inLen, byte[] out, int outOff) {
        for (int i = 0; i < this.blockSize; ++i) {
            this.amalgam[i] = (byte)(in[inOff + i] ^ this.iv[i]);
        }
        try {
            this.delegationCipher.doFinal(this.amalgam, 0, this.blockSize, this.ciphertext, 0);
        }
        catch (IllegalBlockSizeException e) {
        }
        catch (BadPaddingException e) {
        }
        catch (ShortBufferException e) {
            // empty catch block
        }
        try {
            System.arraycopy(this.ciphertext, 0, out, outOff, this.blockSize);
            System.arraycopy(this.ciphertext, 0, this.iv, 0, this.blockSize);
        }
        catch (RuntimeException e) {
            System.out.println("Algorithm" + this.delegationCipher.getAlgorithm());
            System.out.println("paddingName[" + this.paddingName + "],ciphertext[" + this.ciphertext.length + "], 0, out[" + out.length + "], outOff[" + outOff + "], blockSize[" + this.blockSize + "]");
            System.out.println("paddingName[" + this.paddingName + "],ciphertext[" + this.ciphertext.length + "], 0, iv[" + this.iv.length + "], 0, blockSize[" + this.blockSize + "]");
            throw e;
        }
        return this.blockSize;
    }

    protected int decryptBlock(byte[] in, int inOff, int inLen, byte[] out, int outOff) {
        System.arraycopy(in, inOff, this.ciphertext, 0, this.blockSize);
        try {
            this.delegationCipher.doFinal(this.ciphertext, 0, this.blockSize, this.amalgam, 0);
        }
        catch (IllegalBlockSizeException e) {
        }
        catch (BadPaddingException e) {
        }
        catch (ShortBufferException e) {
            // empty catch block
        }
        for (int i = 0; i < this.blockSize; ++i) {
            out[outOff + i] = (byte)(this.amalgam[i] ^ this.iv[i]);
        }
        System.arraycopy(this.ciphertext, 0, this.iv, 0, this.blockSize);
        return this.blockSize;
    }

    protected void _engineSetMode(String modeName) throws NoSuchAlgorithmException {
        if (!modeName.equals("CBC") && !modeName.equals("")) {
            throw new NoSuchAlgorithmException("This is CBC mode. Cannot change to " + modeName);
        }
    }
}

