/*
 * Decompiled with CFR 0.152.
 */
package com.initech.provider.crypto.cipher;

import com.initech.cryptox.SecretKeyFactorySpi;
import com.initech.cryptox.spec.SecretKeySpec;
import com.initech.provider.AutoJCE;
import com.initech.provider.crypto.cipher.DESKey;
import java.security.InvalidKeyException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import javax.crypto.SecretKey;
import javax.crypto.spec.DESKeySpec;

public class DESKeyFactory
extends SecretKeyFactorySpi {
    protected SecretKey engineGenerateSecret(KeySpec keySpec) throws InvalidKeySpecException {
        return this.engineGenerateSecretX(keySpec);
    }

    protected com.initech.cryptox.SecretKey engineGenerateSecretX(KeySpec keySpec) throws InvalidKeySpecException {
        if (keySpec instanceof DESKeySpec) {
            keySpec = (com.initech.cryptox.spec.DESKeySpec)AutoJCE.toJCEX(keySpec);
            return new DESKey(((com.initech.cryptox.spec.DESKeySpec)keySpec).getKey());
        }
        if (keySpec instanceof javax.crypto.spec.SecretKeySpec) {
            SecretKeySpec skspec = (SecretKeySpec)(keySpec = (KeySpec)AutoJCE.toJCEX(keySpec));
            if (skspec.getAlgorithm().indexOf("DES") == -1) {
                throw new InvalidKeySpecException("SecretKeySpec not for DES");
            }
            if (!"RAW".equals(skspec.getFormat())) {
                throw new InvalidKeySpecException("Unknown encoding format in KeySpec");
            }
            return new DESKey(skspec.getEncoded());
        }
        throw new InvalidKeySpecException(keySpec.getClass().getName() + " not valid for DES.");
    }

    protected KeySpec engineGetKeySpec(com.initech.cryptox.SecretKey key, Class keySpec) throws InvalidKeySpecException {
        if (key instanceof DESKey) {
            if (SecretKeySpec.class.isAssignableFrom(keySpec)) {
                return new SecretKeySpec(key.getEncoded(), "DES");
            }
            if (com.initech.cryptox.spec.DESKeySpec.class.isAssignableFrom(keySpec)) {
                try {
                    return new com.initech.cryptox.spec.DESKeySpec(key.getEncoded());
                }
                catch (InvalidKeyException e) {
                    throw new InvalidKeySpecException(e.toString());
                }
            }
        }
        throw new InvalidKeySpecException("not implemented");
    }

    protected SecretKey engineTranslateKey(SecretKey key) throws InvalidKeyException {
        if (!key.getAlgorithm().equals("DES")) {
            throw new InvalidKeyException("not a DES key");
        }
        return new DESKey(key.getEncoded());
    }

    protected com.initech.cryptox.SecretKey engineTranslateKey(com.initech.cryptox.SecretKey key) throws InvalidKeyException {
        if (!key.getAlgorithm().equals("DES")) {
            throw new InvalidKeyException("not a DES key");
        }
        return new DESKey(key.getEncoded());
    }
}

