/*
 * Decompiled with CFR 0.152.
 */
package com.initech.provider.crypto.cipher;

import com.initech.asn1.ASN1Decoder;
import com.initech.asn1.ASN1Encoder;
import com.initech.asn1.ASN1Exception;
import com.initech.asn1.ASN1Type;
import com.initech.asn1.BERDecoder;
import com.initech.asn1.DEREncoder;
import com.initech.cryptox.AlgorithmParametersSpi;
import com.initech.provider.AutoJCE;
import com.initech.provider.crypto.spec.KeySizeSpec;
import java.io.IOException;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import javax.crypto.spec.IvParameterSpec;

public class DESParameters
extends AlgorithmParametersSpi
implements ASN1Type {
    private static final long serialVersionUID = 7355413857276846263L;
    public static int keysize = 8;
    protected byte[] initialVector;

    public DESParameters() {
    }

    public DESParameters(byte[] asn1OctetString) throws ASN1Exception {
        BERDecoder ivParam = new BERDecoder(asn1OctetString);
        this.decode(ivParam);
    }

    protected byte[] _engineGetEncoded() throws IOException {
        DEREncoder enc = new DEREncoder();
        try {
            this.encode(enc);
            return enc.toByteArray();
        }
        catch (ASN1Exception e) {
            throw new IOException(e.toString());
        }
    }

    protected byte[] _engineGetEncoded(String format) throws IOException {
        return this._engineGetEncoded();
    }

    protected AlgorithmParameterSpec _engineGetParameterSpec(Class paramSpec) throws InvalidParameterSpecException {
        if (IvParameterSpec.class.isAssignableFrom(paramSpec)) {
            return new IvParameterSpec(this.initialVector);
        }
        if (KeySizeSpec.class.isAssignableFrom(paramSpec)) {
            return new KeySizeSpec(keysize);
        }
        throw new InvalidParameterSpecException("Not a IvParameterSpec assignable spec");
    }

    protected void _engineInit(AlgorithmParameterSpec paramSpec) throws InvalidParameterSpecException {
        if (!((paramSpec = (AlgorithmParameterSpec)AutoJCE.toJCEX(paramSpec)) instanceof IvParameterSpec)) {
            throw new InvalidParameterSpecException("Not a IvParameterSpec");
        }
        this.initialVector = ((IvParameterSpec)paramSpec).getIV();
    }

    protected void _engineInit(byte[] params) throws IOException {
        try {
            this.decode(new BERDecoder(params));
        }
        catch (ASN1Exception e) {
            throw new IOException(e.toString());
        }
    }

    protected void _engineInit(byte[] params, String format) throws IOException {
        this._engineInit(params);
    }

    protected String _engineToString() {
        return "Initech DESParameter";
    }

    public void decode(ASN1Decoder dec) throws ASN1Exception {
        this.initialVector = dec.decodeOctetString();
    }

    public void encode(ASN1Encoder enc) throws ASN1Exception {
        enc.encodeOctetString(this.initialVector);
    }
}

