/*
 * Decompiled with CFR 0.152.
 */
package com.initech.provider.crypto.cipher;

import com.initech.cryptox.IllegalBlockSizeException;
import com.initech.provider.crypto.cipher.BlockCipher;
import com.initech.provider.crypto.cipher.DES;
import com.initech.provider.crypto.cipher.DESedeKey;
import java.security.InvalidKeyException;
import java.security.Key;

public class DESede
extends BlockCipher {
    protected static final int BLOCK_SIZE = 8;
    DES des1 = new DES();
    DES des2 = new DES();
    DES des3 = new DES();
    byte[] _buf = new byte[16];

    public DESede() {
        this.setBlockSize(8);
    }

    protected final int engineGetKeySize(Key key) throws InvalidKeyException {
        byte[] k = key.getEncoded();
        if (k.length != 24) {
            throw new InvalidKeyException();
        }
        return 112;
    }

    public void setKey(Key key) throws InvalidKeyException {
        DESedeKey tk;
        if (key instanceof DESedeKey) {
            tk = (DESedeKey)key;
            if (this.cipherMode == 1) {
                this.des1.cipherMode = 1;
                this.des2.cipherMode = 2;
                this.des3.cipherMode = 1;
            } else {
                this.des1.cipherMode = 2;
                this.des2.cipherMode = 1;
                this.des3.cipherMode = 2;
            }
        } else {
            throw new InvalidKeyException("this key is not Triple DES key");
        }
        this.des1.setKey(tk.getKey1());
        this.des2.setKey(tk.getKey2());
        this.des3.setKey(tk.getKey3());
    }

    public int encryptBlock(byte[] input, int inOff, int len, byte[] output, int outOff) throws IllegalBlockSizeException {
        this.des1.encryptBlock(input, inOff, len, this._buf, 0);
        this.des2.decryptBlock(this._buf, 0, len, this._buf, 8);
        this.des3.encryptBlock(this._buf, 8, len, output, outOff);
        return 8;
    }

    public int decryptBlock(byte[] input, int inOff, int len, byte[] output, int outOff) {
        this.des3.decryptBlock(input, inOff, len, this._buf, 0);
        try {
            this.des2.encryptBlock(this._buf, 0, len, this._buf, 8);
        }
        catch (Exception e) {
            // empty catch block
        }
        this.des1.decryptBlock(this._buf, 8, len, output, outOff);
        return 8;
    }
}

