/*
 * Decompiled with CFR 0.152.
 */
package com.initech.provider.crypto.cipher;

import com.initech.cryptox.Zeroizable;
import com.initech.provider.crypto.cipher.DESKey;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import javax.crypto.SecretKey;

public class DESedeKey
implements Zeroizable,
SecretKey,
com.initech.cryptox.SecretKey,
Externalizable {
    private DESKey deskey1;
    private DESKey deskey2;
    private DESKey deskey3;

    public DESedeKey() {
    }

    public DESedeKey(byte[] rawKey) {
        byte[] key = new byte[8];
        System.arraycopy(rawKey, 0, key, 0, 8);
        this.deskey1 = new DESKey(key);
        System.arraycopy(rawKey, 8, key, 0, 8);
        this.deskey2 = new DESKey(key);
        System.arraycopy(rawKey, 16, key, 0, 8);
        this.deskey3 = new DESKey(key);
    }

    public DESedeKey(byte[] rawKey1, byte[] rawKey2, byte[] rawKey3) {
        this.deskey1 = new DESKey(rawKey1);
        this.deskey2 = new DESKey(rawKey2);
        this.deskey3 = new DESKey(rawKey3);
    }

    public DESKey getKey1() {
        return this.deskey1;
    }

    public DESKey getKey2() {
        return this.deskey2;
    }

    public DESKey getKey3() {
        return this.deskey3;
    }

    public String getAlgorithm() {
        return "DESede";
    }

    public String getFormat() {
        return "RAW";
    }

    public byte[] getEncoded() {
        byte[] tmp = new byte[24];
        System.arraycopy(this.deskey1.getEncoded(), 0, tmp, 0, 8);
        System.arraycopy(this.deskey2.getEncoded(), 0, tmp, 8, 8);
        System.arraycopy(this.deskey3.getEncoded(), 0, tmp, 16, 8);
        return tmp;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.deskey1);
        out.writeObject(this.deskey2);
        out.writeObject(this.deskey3);
    }

    public void readExternal(ObjectInput in) throws IOException {
        try {
            this.deskey1 = (DESKey)in.readObject();
            this.deskey2 = (DESKey)in.readObject();
            this.deskey3 = (DESKey)in.readObject();
        }
        catch (Exception e) {
            throw new IOException(":" + e.toString());
        }
    }

    public void zeroize() {
        if (this.deskey1 != null) {
            this.deskey1.zeroize();
        }
        if (this.deskey2 != null) {
            this.deskey2.zeroize();
        }
        if (this.deskey3 != null) {
            this.deskey3.zeroize();
        }
    }
}

