/*
 * Decompiled with CFR 0.152.
 */
package com.initech.provider.crypto.cipher;

import com.initech.cryptox.SecretKeyFactorySpi;
import com.initech.cryptox.spec.SecretKeySpec;
import com.initech.provider.AutoJCE;
import com.initech.provider.crypto.cipher.DESedeKey;
import java.security.InvalidKeyException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import javax.crypto.SecretKey;
import javax.crypto.spec.DESedeKeySpec;

public class DESedeKeyFactory
extends SecretKeyFactorySpi {
    protected SecretKey engineGenerateSecret(KeySpec keySpec) throws InvalidKeySpecException {
        return this.engineGenerateSecretX(keySpec);
    }

    protected com.initech.cryptox.SecretKey engineGenerateSecretX(KeySpec keySpec) throws InvalidKeySpecException {
        if (keySpec instanceof DESedeKeySpec) {
            keySpec = (com.initech.cryptox.spec.DESedeKeySpec)AutoJCE.toJCEX(keySpec);
            return new DESedeKey(((com.initech.cryptox.spec.DESedeKeySpec)keySpec).getKey());
        }
        if (keySpec instanceof javax.crypto.spec.SecretKeySpec) {
            SecretKeySpec skspec = (SecretKeySpec)(keySpec = (KeySpec)AutoJCE.toJCEX(keySpec));
            if (skspec.getAlgorithm().indexOf("DESede") == -1) {
                throw new InvalidKeySpecException("SecretKeySpec not for DESede");
            }
            if (!"RAW".equals(skspec.getFormat())) {
                throw new InvalidKeySpecException("Unknown encoding format in KeySpec");
            }
            return new DESedeKey(skspec.getEncoded());
        }
        throw new InvalidKeySpecException(keySpec.getClass().getName() + " not valid for DESede.");
    }

    protected KeySpec engineGetKeySpec(com.initech.cryptox.SecretKey key, Class keySpec) throws InvalidKeySpecException {
        if (key instanceof DESedeKey) {
            if (SecretKeySpec.class.isAssignableFrom(keySpec)) {
                return new SecretKeySpec(key.getEncoded(), "DESede");
            }
            if (com.initech.cryptox.spec.DESedeKeySpec.class.isAssignableFrom(keySpec)) {
                try {
                    return new com.initech.cryptox.spec.DESedeKeySpec(key.getEncoded());
                }
                catch (InvalidKeyException e) {
                    throw new InvalidKeySpecException(e.toString());
                }
            }
        }
        throw new InvalidKeySpecException("not implemented");
    }

    protected SecretKey engineTranslateKey(SecretKey key) throws InvalidKeyException {
        if (!key.getAlgorithm().equals("DESede")) {
            throw new InvalidKeyException("not a DESede key");
        }
        return new DESedeKey(key.getEncoded());
    }

    protected com.initech.cryptox.SecretKey engineTranslateKeyX(com.initech.cryptox.SecretKey key) throws InvalidKeyException {
        if (!key.getAlgorithm().equals("DESede")) {
            throw new InvalidKeyException("not a DESede key");
        }
        return new DESedeKey(key.getEncoded());
    }
}

