/*
 * Decompiled with CFR 0.152.
 */
package com.initech.provider.crypto.cipher;

import com.initech.cryptox.Cipher;
import com.initech.provider.crypto.cipher.PaddableWrapper;
import java.security.NoSuchAlgorithmException;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.ShortBufferException;

public class ECBWrapper
extends PaddableWrapper {
    public ECBWrapper(Cipher delegationCipher) {
        super(delegationCipher);
    }

    protected int engineTransformBlock(byte[] input, int inputOffset, int inputLength, byte[] output, int outputOffset) throws com.initech.cryptox.ShortBufferException {
        if (this.cipherMode == 1) {
            return this.encryptBlock(input, inputOffset, inputLength, output, outputOffset);
        }
        if (this.cipherMode == 2) {
            return this.decryptBlock(input, inputOffset, inputLength, output, outputOffset);
        }
        return 0;
    }

    protected int encryptBlock(byte[] in, int inOff, int inLen, byte[] out, int outOff) {
        int blockSize = this.delegationCipher.getBlockSize();
        try {
            this.delegationCipher.doFinal(in, inOff, inLen, out, outOff);
        }
        catch (ShortBufferException e) {
        }
        catch (IllegalBlockSizeException e) {
        }
        catch (BadPaddingException e) {
            // empty catch block
        }
        return blockSize;
    }

    protected int decryptBlock(byte[] in, int inOff, int inLen, byte[] out, int outOff) {
        int blockSize = this.delegationCipher.getBlockSize();
        try {
            this.delegationCipher.doFinal(in, inOff, inLen, out, outOff);
        }
        catch (ShortBufferException e) {
        }
        catch (IllegalBlockSizeException e) {
        }
        catch (BadPaddingException e) {
            // empty catch block
        }
        return blockSize;
    }

    protected void _engineSetMode(String modeName) throws NoSuchAlgorithmException {
        if (!modeName.equals("ECB") && !modeName.equals("")) {
            throw new NoSuchAlgorithmException("This is ECB mode. Cannot change to " + modeName);
        }
    }
}

