/*
 * Decompiled with CFR 0.152.
 */
package com.initech.provider.crypto.cipher;

import com.initech.cryptox.IllegalBlockSizeException;
import com.initech.provider.crypto.cipher.BlockCipher;
import java.security.InvalidKeyException;
import java.security.Key;

public class Lea
extends BlockCipher {
    private static final int BLOCK_SIZE = 16;
    private static final int LEA128_RND = 24;
    private static final int LEA192_RND = 28;
    private static final int LEA256_RND = 32;
    private static int LEA_RND = 0;
    private int keysize = 0;
    private int[][] pdRndKeys = null;

    public Lea() {
        this.setBlockSize(16);
    }

    protected int encryptBlock(byte[] input, int inputOffset, int inputLength, byte[] output, int outputOffset) throws IllegalBlockSizeException {
        byte[] e = new byte[4];
        int X0 = this.SWAP(Lea.toInt(input[0 + inputOffset], input[1 + inputOffset], input[2 + inputOffset], input[3 + inputOffset]));
        int X1 = this.SWAP(Lea.toInt(input[4 + inputOffset], input[5 + inputOffset], input[6 + inputOffset], input[7 + inputOffset]));
        int X2 = this.SWAP(Lea.toInt(input[8 + inputOffset], input[9 + inputOffset], input[10 + inputOffset], input[11 + inputOffset]));
        int X3 = this.SWAP(Lea.toInt(input[12 + inputOffset], input[13 + inputOffset], input[14 + inputOffset], input[15 + inputOffset]));
        if (this.keysize == 128) {
            LEA_RND = 24;
        } else if (this.keysize == 192) {
            LEA_RND = 28;
        } else if (this.keysize == 256) {
            LEA_RND = 32;
        }
        for (int i = 0; i < LEA_RND; ++i) {
            X3 = (int)this.ROR((X2 ^ this.pdRndKeys[i][4]) + (X3 ^ this.pdRndKeys[i][5]), 3);
            X2 = (int)this.ROR((X1 ^ this.pdRndKeys[i][2]) + (X2 ^ this.pdRndKeys[i][3]), 5);
            X1 = (int)this.ROL((X0 ^ this.pdRndKeys[i][0]) + (X1 ^ this.pdRndKeys[i][1]), 9);
            int temp = X0;
            X0 = X1;
            X1 = X2;
            X2 = X3;
            X3 = temp;
        }
        e = Lea.getLittleEndian(X0);
        System.arraycopy(e, 0, output, 0 + outputOffset, 4);
        e = Lea.getLittleEndian(X1);
        System.arraycopy(e, 0, output, 4 + outputOffset, 4);
        e = Lea.getLittleEndian(X2);
        System.arraycopy(e, 0, output, 8 + outputOffset, 4);
        e = Lea.getLittleEndian(X3);
        System.arraycopy(e, 0, output, 12 + outputOffset, 4);
        return inputLength;
    }

    protected int decryptBlock(byte[] input, int inputOffset, int inputLength, byte[] output, int outputOffset) {
        byte[] e = new byte[4];
        int X0 = this.SWAP(Lea.toInt(input[0 + inputOffset], input[1 + inputOffset], input[2 + inputOffset], input[3 + inputOffset]));
        int X1 = this.SWAP(Lea.toInt(input[4 + inputOffset], input[5 + inputOffset], input[6 + inputOffset], input[7 + inputOffset]));
        int X2 = this.SWAP(Lea.toInt(input[8 + inputOffset], input[9 + inputOffset], input[10 + inputOffset], input[11 + inputOffset]));
        int X3 = this.SWAP(Lea.toInt(input[12 + inputOffset], input[13 + inputOffset], input[14 + inputOffset], input[15 + inputOffset]));
        if (this.keysize == 128) {
            LEA_RND = 24;
        } else if (this.keysize == 192) {
            LEA_RND = 28;
        } else if (this.keysize == 256) {
            LEA_RND = 28;
        }
        for (int i = 0; i < LEA_RND; ++i) {
            int temp = X3;
            X3 = X2;
            X2 = X1;
            X1 = X0;
            X0 = temp;
            X1 = (int)(this.ROR(X1, 9) - (long)(X0 ^ this.pdRndKeys[23 - i][0]) ^ (long)this.pdRndKeys[23 - i][1]);
            X2 = (int)(this.ROL(X2, 5) - (long)(X1 ^ this.pdRndKeys[23 - i][2]) ^ (long)this.pdRndKeys[23 - i][3]);
            X3 = (int)(this.ROL(X3, 3) - (long)(X2 ^ this.pdRndKeys[23 - i][4]) ^ (long)this.pdRndKeys[23 - i][5]);
        }
        e = Lea.getLittleEndian(X0);
        System.arraycopy(e, 0, output, 0 + outputOffset, 4);
        e = Lea.getLittleEndian(X1);
        System.arraycopy(e, 0, output, 4 + outputOffset, 4);
        e = Lea.getLittleEndian(X2);
        System.arraycopy(e, 0, output, 8 + outputOffset, 4);
        e = Lea.getLittleEndian(X3);
        System.arraycopy(e, 0, output, 12 + outputOffset, 4);
        return inputLength;
    }

    protected int SWAP(int x) {
        return (int)(this.ROL(x, 8) & 0xFF00FFL | this.ROR(x, 8) & 0xFFFFFFFFFF00FF00L);
    }

    protected long ROL(int W, int i) {
        return ((long)(W << (i & 0x1F)) | ((long)W & 0xFFFFFFFFL) >> 32 - (i & 0x1F)) & 0xFFFFFFFFL;
    }

    protected long ROR(int W, int i) {
        return (((long)W & 0xFFFFFFFFL) >> (i & 0x1F) | (long)(W << 32 - (i & 0x1F))) & 0xFFFFFFFFL;
    }

    private static int toInt(byte b0, byte b1, byte b2, byte b3) {
        return (b0 & 0xFF) << 24 ^ (b1 & 0xFF) << 16 ^ (b2 & 0xFF) << 8 ^ b3 & 0xFF;
    }

    private static int getBigendian(byte[] v) {
        int[] arr = new int[4];
        for (int i = 0; i < 4; ++i) {
            arr[i] = v[3 - i] & 0xFF;
        }
        return (arr[0] << 24) + (arr[1] << 16) + (arr[2] << 8) + (arr[3] << 0);
    }

    private static byte[] getLittleEndian(int v) {
        byte[] buf = new byte[4];
        buf[3] = (byte)(v >>> 24 & 0xFF);
        buf[2] = (byte)(v >>> 16 & 0xFF);
        buf[1] = (byte)(v >>> 8 & 0xFF);
        buf[0] = (byte)(v >>> 0 & 0xFF);
        return buf;
    }

    private static void toByteArray(int i, byte[] b, int offset) {
        b[offset] = (byte)(i >>> 24);
        b[offset + 1] = (byte)(i >>> 16);
        b[offset + 2] = (byte)(i >>> 8);
        b[offset + 3] = (byte)i;
    }

    protected void setKey(Key key) throws InvalidKeyException {
        block6: {
            int[] delta;
            int[] T;
            byte[] mk;
            block7: {
                block5: {
                    if (key == null) {
                        throw new InvalidKeyException("Input key is null.('LEA ???\u7531\u044a????\u317b? 128,192,256 bit \uf9cd?\uf9de???\u2478???')");
                    }
                    mk = key.getEncoded();
                    if (mk.length != 16 && mk.length != 24 && mk.length != 32) {
                        throw new InvalidKeyException("Invaild key size.('LEA ???\u7531\u044a????\u317b? 128,192,256 bit \uf9cd?\uf9de???\u2478???') Input Key Size : " + mk.length * 16);
                    }
                    this.keysize = mk.length * 8;
                    T = null;
                    delta = new int[]{-1007687205, 1147300610, 2044886154, 2027892972, 1902027934, -947529206, -531697110, -440137385};
                    if (this.keysize != 128) break block5;
                    this.pdRndKeys = new int[24][6];
                    T = new int[]{this.SWAP(Lea.toInt(mk[0], mk[1], mk[2], mk[3])), this.SWAP(Lea.toInt(mk[4], mk[5], mk[6], mk[7])), this.SWAP(Lea.toInt(mk[8], mk[9], mk[10], mk[11])), this.SWAP(Lea.toInt(mk[12], mk[13], mk[14], mk[15]))};
                    for (int i = 0; i < 24; ++i) {
                        T[0] = (int)this.ROL((int)((long)T[0] + this.ROL(delta[i & 3], i)), 1);
                        T[1] = (int)this.ROL((int)((long)T[1] + this.ROL(delta[i & 3], i + 1)), 3);
                        T[2] = (int)this.ROL((int)((long)T[2] + this.ROL(delta[i & 3], i + 2)), 6);
                        T[3] = (int)this.ROL((int)((long)T[3] + this.ROL(delta[i & 3], i + 3)), 11);
                        this.pdRndKeys[i][0] = T[0];
                        this.pdRndKeys[i][1] = T[1];
                        this.pdRndKeys[i][2] = T[2];
                        this.pdRndKeys[i][3] = T[1];
                        this.pdRndKeys[i][4] = T[3];
                        this.pdRndKeys[i][5] = T[1];
                    }
                    break block6;
                }
                if (this.keysize != 192) break block7;
                this.pdRndKeys = new int[28][6];
                T = new int[]{this.SWAP(Lea.toInt(mk[0], mk[1], mk[2], mk[3])), this.SWAP(Lea.toInt(mk[4], mk[5], mk[6], mk[7])), this.SWAP(Lea.toInt(mk[8], mk[9], mk[10], mk[11])), this.SWAP(Lea.toInt(mk[12], mk[13], mk[14], mk[15])), this.SWAP(Lea.toInt(mk[16], mk[17], mk[18], mk[19])), this.SWAP(Lea.toInt(mk[20], mk[21], mk[22], mk[23]))};
                for (int i = 0; i < 28; ++i) {
                    T[0] = (int)this.ROL((int)((long)T[0] + this.ROL(delta[i % 6], i & 0x1F)), 1);
                    T[1] = (int)this.ROL((int)((long)T[1] + this.ROL(delta[i % 6], i + 1 & 0x1F)), 3);
                    T[2] = (int)this.ROL((int)((long)T[2] + this.ROL(delta[i % 6], i + 2 & 0x1F)), 6);
                    T[3] = (int)this.ROL((int)((long)T[3] + this.ROL(delta[i % 6], i + 3 & 0x1F)), 11);
                    T[4] = (int)this.ROL((int)((long)T[4] + this.ROL(delta[i % 6], i + 4 & 0x1F)), 13);
                    T[5] = (int)this.ROL((int)((long)T[5] + this.ROL(delta[i % 6], i + 5 & 0x1F)), 17);
                    this.pdRndKeys[i][0] = T[0];
                    this.pdRndKeys[i][1] = T[1];
                    this.pdRndKeys[i][2] = T[2];
                    this.pdRndKeys[i][3] = T[3];
                    this.pdRndKeys[i][4] = T[4];
                    this.pdRndKeys[i][5] = T[5];
                }
                break block6;
            }
            if (this.keysize != 256) break block6;
            this.pdRndKeys = new int[32][6];
            T = new int[]{this.SWAP(Lea.toInt(mk[0], mk[1], mk[2], mk[3])), this.SWAP(Lea.toInt(mk[4], mk[5], mk[6], mk[7])), this.SWAP(Lea.toInt(mk[8], mk[9], mk[10], mk[11])), this.SWAP(Lea.toInt(mk[12], mk[13], mk[14], mk[15])), this.SWAP(Lea.toInt(mk[16], mk[17], mk[18], mk[19])), this.SWAP(Lea.toInt(mk[20], mk[21], mk[22], mk[23])), this.SWAP(Lea.toInt(mk[24], mk[25], mk[26], mk[27])), this.SWAP(Lea.toInt(mk[28], mk[29], mk[30], mk[31]))};
            for (int i = 0; i < 32; ++i) {
                T[6 * i & 7] = (int)this.ROL((int)((long)T[6 * i & 7] + this.ROL(delta[i & 7], i & 0x1F)), 1);
                T[6 * i + 1 & 7] = (int)this.ROL((int)((long)T[6 * i + 1 & 7] + this.ROL(delta[i & 7], i + 1 & 0x1F)), 3);
                T[6 * i + 2 & 7] = (int)this.ROL((int)((long)T[6 * i + 2 & 7] + this.ROL(delta[i & 7], i + 2 & 0x1F)), 6);
                T[6 * i + 3 & 7] = (int)this.ROL((int)((long)T[6 * i + 3 & 7] + this.ROL(delta[i & 7], i + 3 & 0x1F)), 11);
                T[6 * i + 4 & 7] = (int)this.ROL((int)((long)T[6 * i + 4 & 7] + this.ROL(delta[i & 7], i + 4 & 0x1F)), 13);
                T[6 * i + 5 & 7] = (int)this.ROL((int)((long)T[6 * i + 5 & 7] + this.ROL(delta[i & 7], i + 5 & 0x1F)), 17);
                this.pdRndKeys[i][0] = T[6 * i & 7];
                this.pdRndKeys[i][1] = T[6 * i + 1 & 7];
                this.pdRndKeys[i][2] = T[6 * i + 2 & 7];
                this.pdRndKeys[i][3] = T[6 * i + 3 & 7];
                this.pdRndKeys[i][4] = T[6 * i + 4 & 7];
                this.pdRndKeys[i][5] = T[6 * i + 5 & 7];
            }
        }
    }
}

