/*
 * Decompiled with CFR 0.152.
 */
package com.initech.provider.crypto.cipher;

import com.initech.cryptox.Zeroizable;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.security.InvalidKeyException;
import javax.crypto.SecretKey;

public class LeaKey
implements Zeroizable,
SecretKey,
com.initech.cryptox.SecretKey,
Externalizable {
    private byte[] key;

    public LeaKey() {
    }

    public LeaKey(byte[] rawKey) throws InvalidKeyException {
        if (rawKey.length != 16 && rawKey.length != 24 && rawKey.length != 32) {
            throw new InvalidKeyException("Invaild key size.('LeaKey ???\u7531\u044a????\u317b? 128,192,256 bit \uf9cd?\uf9de???\u2478???')");
        }
        this.key = new byte[rawKey.length];
        System.arraycopy(rawKey, 0, this.key, 0, rawKey.length);
    }

    public String getAlgorithm() {
        return "LEA";
    }

    public String getFormat() {
        return "RAW";
    }

    public byte[] getEncoded() {
        byte[] tmp = new byte[this.key.length];
        System.arraycopy(this.key, 0, tmp, 0, this.key.length);
        return tmp;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.write((byte)this.key.length);
        out.write(this.key);
    }

    public void readExternal(ObjectInput in) throws IOException {
        int len = in.read();
        if (len != 16 && len != 24 && len != 32) {
            throw new IOException("InvalidKeyException : Invaild key size.('LEA ???\u7531\u044a????\u317b? 128,192,256 bit \uf9cd?\uf9de???\u2478???')");
        }
        this.key = new byte[len];
        in.readFully(this.key, 0, len);
    }

    public void zeroize() {
        for (int i = 0; i < this.key.length; ++i) {
            this.key[i] = 0;
        }
    }
}

