/*
 * Decompiled with CFR 0.152.
 */
package com.initech.provider.crypto.cipher;

import com.initech.cryptox.SecretKeyFactorySpi;
import com.initech.cryptox.spec.SecretKeySpec;
import com.initech.provider.AutoJCE;
import com.initech.provider.crypto.cipher.LeaKey;
import com.initech.provider.crypto.spec.LeaKeySpec;
import java.security.InvalidKeyException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import javax.crypto.SecretKey;

public class LeaKeyFactory
extends SecretKeyFactorySpi {
    protected SecretKey engineGenerateSecret(KeySpec keySpec) throws InvalidKeySpecException {
        return this.engineGenerateSecretX(keySpec);
    }

    protected com.initech.cryptox.SecretKey engineGenerateSecretX(KeySpec keySpec) throws InvalidKeySpecException {
        if (keySpec instanceof LeaKeySpec) {
            try {
                return new LeaKey(((LeaKeySpec)keySpec).getKey());
            }
            catch (InvalidKeyException e) {
                throw new InvalidKeySpecException(e.getMessage());
            }
        }
        if (keySpec instanceof javax.crypto.spec.SecretKeySpec) {
            SecretKeySpec skspec = (SecretKeySpec)(keySpec = (KeySpec)AutoJCE.toJCEX(keySpec));
            String alg = skspec.getAlgorithm();
            if (!(alg.toUpperCase().startsWith("LEA") || alg.toUpperCase().startsWith("LEAX") || alg.toUpperCase().startsWith("SSSS"))) {
                throw new InvalidKeySpecException("SecretKeySpec not for LEA");
            }
            if (!"RAW".equals(skspec.getFormat())) {
                throw new InvalidKeySpecException("Unknown encoding format in KeySpec");
            }
            try {
                return new LeaKey(skspec.getEncoded());
            }
            catch (InvalidKeyException e) {
                throw new InvalidKeySpecException(e.getMessage());
            }
        }
        throw new InvalidKeySpecException(keySpec.getClass().getName() + " not valid for LEA.");
    }

    protected KeySpec engineGetKeySpec(com.initech.cryptox.SecretKey key, Class keySpec) throws InvalidKeySpecException {
        if (key instanceof LeaKey) {
            if (SecretKeySpec.class.isAssignableFrom(keySpec)) {
                return new SecretKeySpec(key.getEncoded(), "LEA");
            }
            if (LeaKeySpec.class.isAssignableFrom(keySpec)) {
                try {
                    return new LeaKeySpec(key.getEncoded());
                }
                catch (InvalidKeyException e) {
                    throw new InvalidKeySpecException(e.toString());
                }
            }
        }
        throw new InvalidKeySpecException("not implemented");
    }

    protected SecretKey engineTranslateKey(com.initech.cryptox.SecretKey key) throws InvalidKeyException {
        if (!key.getAlgorithm().equals("LEA")) {
            throw new InvalidKeyException("not a LEA key");
        }
        return new LeaKey(key.getEncoded());
    }

    protected com.initech.cryptox.SecretKey engineTranslateKeyX(com.initech.cryptox.SecretKey key) throws InvalidKeyException {
        if (!key.getAlgorithm().equals("LEA")) {
            throw new InvalidKeyException("not a LEA key");
        }
        return new LeaKey(key.getEncoded());
    }
}

