/*
 * Decompiled with CFR 0.152.
 */
package com.initech.provider.crypto.cipher;

import com.initech.cryptox.Cipher;
import com.initech.cryptox.ShortBufferException;
import com.initech.provider.crypto.cipher.PaddableWrapper;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Arrays;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;

public class OFBISOWrapper
extends PaddableWrapper {
    public OFBISOWrapper(Cipher delegationCipher) {
        super(delegationCipher);
    }

    protected int engineTransformBlock(byte[] input, int inputOffset, int inputLength, byte[] output, int outputOffset) throws ShortBufferException {
        if (this.cipherMode == 1) {
            return this.encryptBlock(input, inputOffset, inputLength, output, outputOffset);
        }
        if (this.cipherMode == 2) {
            return this.decryptBlock(input, inputOffset, inputLength, output, outputOffset);
        }
        return 0;
    }

    protected int encryptBlock(byte[] in, int inOff, int inLen, byte[] out, int outOff) {
        int blockSize = this.delegationCipher.getBlockSize();
        try {
            this.iv = this.delegationCipher.doFinal(this.iv);
        }
        catch (IllegalBlockSizeException e) {
        }
        catch (BadPaddingException e) {
            // empty catch block
        }
        int realLength = out.length - outOff < blockSize ? out.length - outOff : blockSize;
        for (int i = 0; i < realLength; ++i) {
            out[i + outOff] = (byte)(in[inOff + i] ^ this.iv[i]);
        }
        return realLength;
    }

    protected int decryptBlock(byte[] in, int inOff, int inLen, byte[] out, int outOff) {
        return this.encryptBlock(in, inOff, inLen, out, outOff);
    }

    protected void engineSetMode(String modeName) throws NoSuchAlgorithmException {
        if (!modeName.equals("OFBISO") && !modeName.equals("")) {
            throw new NoSuchAlgorithmException("This is OFBISO mode. Cannot change to " + modeName);
        }
    }

    protected int getPaddingLength(int lastBytesLeft) {
        return lastBytesLeft;
    }

    protected void getPadded(int paddingLength, byte[] in, int inOff) {
        for (int i = inOff; i < inOff + paddingLength; ++i) {
            in[i] = 0;
        }
    }

    protected int _engineDoFinal(byte[] input, int inputOffset, int inputLength, byte[] output, int outputOffset) throws com.initech.cryptox.IllegalBlockSizeException, com.initech.cryptox.BadPaddingException {
        int outputLength = 0;
        int blockSize = this.delegationCipher.getBlockSize();
        try {
            int sBufferLength = this.bufferedLength;
            byte[] totalInput = new byte[inputLength + sBufferLength];
            this.getBufferedData(totalInput, 0);
            if (inputLength > 0) {
                System.arraycopy(input, inputOffset, totalInput, sBufferLength, inputLength);
            }
            for (int i = 0; i < totalInput.length; i += blockSize) {
                outputLength += this.engineTransformBlock(totalInput, i, blockSize, output, outputOffset + outputLength);
            }
            Arrays.fill(totalInput, (byte)0);
            return outputLength;
        }
        catch (ShortBufferException e) {
            throw new com.initech.cryptox.IllegalBlockSizeException(e.getMessage());
        }
    }

    protected void _engineInit(int opmode, Key key, AlgorithmParameterSpec params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        super._engineInit(1, key, params, random);
    }
}

