/*
 * Decompiled with CFR 0.152.
 */
package com.initech.provider.crypto.cipher;

import com.initech.cryptox.Cipher;
import com.initech.provider.crypto.cipher.StreamWrapper;
import java.security.NoSuchAlgorithmException;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;

public abstract class OFBWrapper
extends StreamWrapper {
    public OFBWrapper(Cipher delegationCipher) {
        super(delegationCipher);
    }

    protected void _engineSetMode(String modeName) throws NoSuchAlgorithmException {
        if (!modeName.equals("OFB") && !modeName.equals("")) {
            throw new NoSuchAlgorithmException("This is OFB mode. Cannot change to " + modeName);
        }
    }

    protected byte encryptByte(byte p) {
        byte[] encryptedBlock = null;
        try {
            encryptedBlock = this.delegationCipher.doFinal(this.iv);
        }
        catch (IllegalBlockSizeException e) {
        }
        catch (BadPaddingException e) {
            // empty catch block
        }
        byte left = 0;
        byte c = 0;
        if (encryptedBlock != null) {
            left = encryptedBlock[0];
            c = (byte)(p ^ left);
            this.shiftBuffer(left);
        }
        return c;
    }

    protected byte decryptByte(byte c) {
        byte[] encryptedBlock = null;
        try {
            encryptedBlock = this.delegationCipher.doFinal(this.iv);
        }
        catch (IllegalBlockSizeException e) {
        }
        catch (BadPaddingException e) {
            // empty catch block
        }
        byte left = 0;
        byte p = 0;
        if (encryptedBlock != null) {
            left = encryptedBlock[0];
            p = (byte)(c ^ left);
            this.shiftBuffer(left);
        }
        return p;
    }

    protected void encryptBlock(byte[] in, int inOffset, byte[] out, int outOffset, int bsize) {
        byte[] encryptedBlock = null;
        try {
            encryptedBlock = this.delegationCipher.doFinal(this.iv);
        }
        catch (IllegalBlockSizeException e) {
        }
        catch (BadPaddingException e) {
            // empty catch block
        }
        if (encryptedBlock != null) {
            for (int i = 0; i < bsize; ++i) {
                out[outOffset + i] = (byte)(encryptedBlock[i] ^ in[inOffset + i]);
            }
            this.shiftBuffer(out, outOffset, bsize);
        }
    }

    protected void decryptBlock(byte[] in, int inOffset, byte[] out, int outOffset, int bsize) {
        byte[] encryptedBlock = null;
        try {
            encryptedBlock = this.delegationCipher.doFinal(this.iv);
        }
        catch (IllegalBlockSizeException e) {
        }
        catch (BadPaddingException e) {
            // empty catch block
        }
        if (encryptedBlock != null) {
            for (int i = 0; i < bsize; ++i) {
                out[outOffset + i] = (byte)(encryptedBlock[i] ^ in[inOffset + i]);
            }
            this.shiftBuffer(out, outOffset, bsize);
        }
    }
}

