/*
 * Decompiled with CFR 0.152.
 */
package com.initech.provider.crypto.cipher;

import com.initech.cryptox.spec.PBEParameterSpec;
import com.initech.provider.crypto.InitechProvider;
import java.security.AlgorithmParameterGeneratorSpi;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;

public class PBEParameterGenerator
extends AlgorithmParameterGeneratorSpi {
    private SecureRandom random;
    private int saltSize;
    private byte[] salt;
    private int iterationCount;

    protected void engineInit(AlgorithmParameterSpec genParamSpec, SecureRandom random) throws InvalidAlgorithmParameterException {
        if (!(genParamSpec instanceof PBEParameterSpec)) {
            throw new InvalidAlgorithmParameterException("Not an PBEParameterSpec");
        }
        this.random = random;
        this.salt = ((PBEParameterSpec)genParamSpec).getSalt();
        this.iterationCount = ((PBEParameterSpec)genParamSpec).getIterationCount();
    }

    protected void engineInit(int size, SecureRandom random) {
        this.random = random;
        this.saltSize = size;
        this.salt = null;
        this.iterationCount = 0;
    }

    protected AlgorithmParameters engineGenerateParameters() {
        if (this.salt == null) {
            this.salt = new byte[this.saltSize];
            this.random.nextBytes(this.salt);
        }
        if (this.iterationCount == 0) {
            this.iterationCount = this.random.nextInt();
            if (this.iterationCount < 0) {
                this.iterationCount = -this.iterationCount;
            }
            this.iterationCount %= 3000;
            if (this.iterationCount < 1000) {
                this.iterationCount += 1000;
            }
        }
        try {
            AlgorithmParameters algParam = AlgorithmParameters.getInstance("PBE", InitechProvider.NAME);
            algParam.init(new PBEParameterSpec(this.salt, this.iterationCount));
            return algParam;
        }
        catch (NoSuchAlgorithmException nse) {
            throw new RuntimeException("No PBE algorithm parameter supported");
        }
        catch (Exception e) {
            throw new RuntimeException("A rude exception has occered.");
        }
    }
}

