/*
 * Decompiled with CFR 0.152.
 */
package com.initech.provider.crypto.cipher;

import com.initech.asn1.ASN1Decoder;
import com.initech.asn1.ASN1Encoder;
import com.initech.asn1.ASN1Exception;
import com.initech.asn1.BERDecoder;
import com.initech.asn1.useful.ASN1Object;
import com.initech.cryptox.AlgorithmParametersSpi;
import com.initech.cryptox.spec.PBEParameterSpec;
import com.initech.provider.AutoJCE;
import java.io.IOException;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;

public class PBEParameters
extends AlgorithmParametersSpi {
    protected byte[] salt;
    protected int iterationCount;

    public PBEParameters() {
    }

    public PBEParameters(byte[] salt, int iterationCount) {
        this.salt = salt;
        this.iterationCount = iterationCount;
    }

    protected byte[] _engineGetEncoded() throws IOException {
        try {
            return new PBEParameterData(this.salt, this.iterationCount).getEncoded();
        }
        catch (ASN1Exception ae) {
            throw new IOException(ae.toString());
        }
    }

    protected byte[] _engineGetEncoded(String s) throws IOException {
        return this._engineGetEncoded();
    }

    protected AlgorithmParameterSpec _engineGetParameterSpec(Class paramSpec) throws InvalidParameterSpecException {
        String name = paramSpec.getName();
        if (PBEParameterSpec.class.isAssignableFrom(paramSpec)) {
            return new PBEParameterSpec(this.salt, this.iterationCount);
        }
        if (javax.crypto.spec.PBEParameterSpec.class.isAssignableFrom(paramSpec)) {
            return new javax.crypto.spec.PBEParameterSpec(this.salt, this.iterationCount);
        }
        if (name.equals("com.initech.cryptox.spec.PBEParameterSpec")) {
            return new PBEParameterSpec(this.salt, this.iterationCount);
        }
        if (name.equals("javax.crypto.spec.PBEParameterSpec")) {
            return new javax.crypto.spec.PBEParameterSpec(this.salt, this.iterationCount);
        }
        throw new InvalidParameterSpecException("Not a PBEParameterSpec assignable spec");
    }

    protected void _engineInit(AlgorithmParameterSpec paramSpec) throws InvalidParameterSpecException {
        if (!((paramSpec = (AlgorithmParameterSpec)AutoJCE.toJCEX(paramSpec)) instanceof PBEParameterSpec)) {
            throw new InvalidParameterSpecException("Not a PBEParameterSpec");
        }
        this.salt = ((PBEParameterSpec)paramSpec).getSalt();
        this.iterationCount = ((PBEParameterSpec)paramSpec).getIterationCount();
    }

    protected void _engineInit(byte[] params) throws IOException {
        try {
            PBEParameterData paramData = new PBEParameterData(params);
            this.salt = paramData.getSalt();
            this.iterationCount = paramData.getIterationCount();
        }
        catch (ASN1Exception ex) {
            throw new IOException(ex.toString());
        }
    }

    protected void _engineInit(byte[] params, String format) throws IOException {
        this._engineInit(params);
    }

    protected String _engineToString() {
        return "(" + this.salt.toString() + "|--|" + this.iterationCount + ")";
    }

    class PBEParameterData
    extends ASN1Object {
        protected byte[] salt = null;
        protected int iterationCount = 0;

        public PBEParameterData(byte[] data) throws ASN1Exception {
            BERDecoder dec = new BERDecoder(data);
            this.decode(dec);
            this.encoded = (byte[])data.clone();
            this.modified = false;
        }

        public PBEParameterData(byte[] s, int it) {
            this.salt = (byte[])s.clone();
            this.iterationCount = it;
            this.modified = true;
        }

        public PBEParameterData() {
        }

        public byte[] getSalt() {
            return (byte[])this.salt.clone();
        }

        public int getIterationCount() {
            return this.iterationCount;
        }

        public void decode(ASN1Decoder dec) throws ASN1Exception {
            int id = dec.decodeSequence();
            this.salt = dec.decodeOctetString();
            this.iterationCount = dec.decodeIntegerAsInt();
            dec.endOf(id);
        }

        public void encode(ASN1Encoder enc) throws ASN1Exception {
            int id = enc.encodeSequence();
            enc.encodeOctetString(this.salt);
            enc.encodeInteger(this.iterationCount);
            enc.endOf(id);
        }
    }
}

