/*
 * Decompiled with CFR 0.152.
 */
package com.initech.provider.crypto.cipher;

import com.initech.cryptox.BadPaddingException;
import com.initech.cryptox.Cipher;
import com.initech.cryptox.CipherSpi;
import com.initech.cryptox.IllegalBlockSizeException;
import com.initech.cryptox.SecretKey;
import com.initech.cryptox.SecretKeyFactory;
import com.initech.cryptox.spec.PBEParameterSpec;
import com.initech.cryptox.spec.SecretKeySpec;
import com.initech.provider.crypto.InitechProvider;
import com.initech.provider.crypto.spec.PBES2ParameterSpec;
import com.initech.provider.pkcs.pkcs5.PBEKey;
import com.initech.provider.pkcs.pkcs5.PBKDF2;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.util.Arrays;
import javax.crypto.Mac;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.ShortBufferException;

public class PBES2
extends CipherSpi {
    protected Cipher delegationCipher;
    protected String mode;
    protected String padding;

    protected void _engineSetMode(String mode) throws NoSuchAlgorithmException {
        this.mode = mode;
    }

    protected void _engineSetPadding(String padding) throws com.initech.cryptox.NoSuchPaddingException {
        this.padding = padding;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void _engineInit(int opmode, Key pbeKey, AlgorithmParameterSpec params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        block10: {
            if (!(params instanceof PBES2ParameterSpec)) {
                throw new InvalidAlgorithmParameterException("PBES2ParameterSpec needed");
            }
            if (!(pbeKey instanceof PBEKey)) {
                throw new InvalidKeyException("PBEKey is needed");
            }
            PBES2ParameterSpec pbes2parameter = (PBES2ParameterSpec)params;
            String esAlgorithm = pbes2parameter.getAlgorithm();
            PBEParameterSpec pbeParameterSpec = pbes2parameter.getPBEParameterSpec();
            AlgorithmParameters cipherParameter = pbes2parameter.getCipherParameters();
            int dkLen = pbes2parameter.getDkLen();
            byte[] derivedKey = null;
            SecretKeySpec delegationKeySpec = null;
            try {
                Mac prfMac = Mac.getInstance(pbes2parameter.getPrfAlgoorithm(), InitechProvider.NAME);
                derivedKey = new PBKDF2((PBEKey)pbeKey, pbeParameterSpec, prfMac, dkLen).process();
                delegationKeySpec = new SecretKeySpec(derivedKey, esAlgorithm);
                SecretKeyFactory skf = SecretKeyFactory.getInstance(esAlgorithm, InitechProvider.NAME);
                SecretKey delegationKey = skf.generateSecret(delegationKeySpec);
                String cipherAlgorithm = esAlgorithm;
                this.delegationCipher = Cipher.getInstance(cipherAlgorithm, InitechProvider.NAME);
                this.delegationCipher.init(opmode, (Key)delegationKey, cipherParameter, random);
                delegationKeySpec = null;
                if (derivedKey == null) break block10;
            }
            catch (NoSuchAlgorithmException e) {
                try {
                    throw new InvalidAlgorithmParameterException(e.toString());
                    catch (InvalidKeySpecException e2) {
                        throw new InvalidAlgorithmParameterException(e2.toString());
                    }
                    catch (NoSuchPaddingException e3) {
                        throw new InvalidAlgorithmParameterException(e3.toString());
                    }
                    catch (NoSuchProviderException e4) {
                        throw new InvalidAlgorithmParameterException(e4.toString());
                    }
                }
                catch (Throwable throwable) {
                    delegationKeySpec = null;
                    if (derivedKey != null) {
                        Arrays.fill(derivedKey, (byte)0);
                    }
                    PBEKey k = (PBEKey)pbeKey;
                    k.zeroize();
                    throw throwable;
                }
            }
            Arrays.fill(derivedKey, (byte)0);
        }
        PBEKey k = (PBEKey)pbeKey;
        k.zeroize();
    }

    protected void _engineInit(int opmode, Key pbeKey, AlgorithmParameters params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        throw new InvalidAlgorithmParameterException("Need PBES2ParameterSpec!!");
    }

    protected void _engineInit(int opmode, Key pbeKey, SecureRandom random) throws InvalidKeyException {
        throw new InvalidKeyException("No default parameters for PBES2, need PBES2ParameterSpec");
    }

    protected byte[] _engineDoFinal(byte[] input, int inputOffset, int inputLen) throws IllegalBlockSizeException, BadPaddingException {
        return this.delegationCipher.doFinal(input, inputOffset, inputLen);
    }

    protected int _engineDoFinal(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) throws IllegalBlockSizeException, BadPaddingException, IllegalStateException, IllegalArgumentException, ShortBufferException {
        try {
            int n = this.delegationCipher.doFinal(input, inputOffset, inputLen, output, outputOffset);
            return n;
        }
        catch (com.initech.cryptox.ShortBufferException e) {
            throw new IllegalBlockSizeException(e.toString());
        }
    }

    protected int _engineGetBlockSize() {
        return this.delegationCipher.getBlockSize();
    }

    protected byte[] _engineGetIV() {
        return this.delegationCipher.getIV();
    }

    protected int _engineGetOutputSize(int inputLen) {
        return this.delegationCipher.getOutputSize(inputLen);
    }

    protected AlgorithmParameters _engineGetParameters() {
        return this.delegationCipher.getParameters();
    }

    protected byte[] _engineUpdate(byte[] input, int inputOffset, int inputLen) {
        return this.delegationCipher.update(input, inputOffset, inputLen);
    }

    protected int _engineUpdate(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) throws IllegalArgumentException, ShortBufferException {
        return this.delegationCipher.update(input, inputOffset, inputLen, output, outputOffset);
    }
}

