/*
 * Decompiled with CFR 0.152.
 */
package com.initech.provider.crypto.cipher;

import com.initech.cryptox.spec.IvParameterSpec;
import com.initech.cryptox.spec.PBEParameterSpec;
import com.initech.provider.AutoJCE;
import com.initech.provider.crypto.InitechProvider;
import com.initech.provider.crypto.cipher.DESKey;
import com.initech.provider.crypto.cipher.DEScbc;
import com.initech.provider.pkcs.pkcs5.PBEKey;
import com.initech.provider.pkcs.pkcs5.PBKDF1;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.NoSuchPaddingException;

public class PBEWithMD2AndDES
extends DEScbc {
    public void engineInit(int opmode, Key key, AlgorithmParameterSpec params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        byte[] deskey = new byte[8];
        byte[] iv = new byte[8];
        if (params instanceof javax.crypto.spec.PBEParameterSpec) {
            params = (AlgorithmParameterSpec)AutoJCE.toJCEX(params);
        }
        try {
            byte[] source = new PBKDF1((PBEKey)key, (PBEParameterSpec)params, MessageDigest.getInstance("MD2", InitechProvider.NAME), 16).process();
            System.arraycopy(source, 0, deskey, 0, 8);
            System.arraycopy(source, 8, iv, 0, 8);
            for (int i = 0; i < source.length; ++i) {
                source[i] = 0;
            }
        }
        catch (NoSuchAlgorithmException e) {
            throw new InvalidAlgorithmParameterException("No MD2");
        }
        catch (InvalidParameterException e) {
            throw new InvalidAlgorithmParameterException("No MD2");
        }
        catch (NoSuchProviderException e) {
            throw new InvalidAlgorithmParameterException("No " + InitechProvider.NAME);
        }
        try {
            this.engineSetPadding("PKCS5Padding");
        }
        catch (NoSuchPaddingException pe) {
            throw new InvalidAlgorithmParameterException("PKCS5Padding needed");
        }
        super.engineInit(opmode, (Key)new DESKey(deskey), new IvParameterSpec(iv), random);
    }

    public void engineInit(int opmode, Key key, SecureRandom random) throws InvalidKeyException {
        throw new InvalidKeyException("PBEParameterSpec is needed");
    }

    public void engineInit(int opmode, Key key, AlgorithmParameters params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        throw new InvalidAlgorithmParameterException("PBEParameterSpec is needed");
    }
}

