/*
 * Decompiled with CFR 0.152.
 */
package com.initech.provider.crypto.cipher;

import com.initech.cryptox.spec.IvParameterSpec;
import com.initech.cryptox.spec.PBEParameterSpec;
import com.initech.provider.AutoJCE;
import com.initech.provider.crypto.InitechProvider;
import com.initech.provider.crypto.cipher.DESedeKey;
import com.initech.provider.crypto.cipher.DESedecbc;
import com.initech.provider.crypto.pkcs12.PBKDFForPKCS12;
import com.initech.provider.pkcs.pkcs5.PBEKey;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.NoSuchPaddingException;

public class PBEWithSHAAnd3KeyTripleDES
extends DESedecbc {
    protected final int engineGetKeySize(Key key) throws InvalidKeyException {
        return 168;
    }

    public void engineInit(int opmode, Key key, AlgorithmParameterSpec params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        byte[] iv;
        byte[] deskey1 = new byte[8];
        byte[] deskey2 = new byte[8];
        byte[] deskey3 = new byte[8];
        if (params instanceof javax.crypto.spec.PBEParameterSpec) {
            params = (AlgorithmParameterSpec)AutoJCE.toJCEX(params);
        }
        try {
            PBKDFForPKCS12 pbkdf = new PBKDFForPKCS12();
            byte[] tdeskey = pbkdf.process((PBEKey)key, (PBEParameterSpec)params, MessageDigest.getInstance("SHA1", InitechProvider.NAME), 24, (byte)1);
            System.arraycopy(tdeskey, 0, deskey1, 0, 8);
            System.arraycopy(tdeskey, 8, deskey2, 0, 8);
            System.arraycopy(tdeskey, 16, deskey3, 0, 8);
            iv = pbkdf.process((PBEKey)key, (PBEParameterSpec)params, MessageDigest.getInstance("SHA1", InitechProvider.NAME), 8, (byte)2);
        }
        catch (NoSuchAlgorithmException e) {
            throw new InvalidAlgorithmParameterException("No SHA1");
        }
        catch (InvalidParameterException e) {
            throw new InvalidAlgorithmParameterException("No SHA1");
        }
        catch (NoSuchProviderException e) {
            throw new InvalidAlgorithmParameterException("No " + InitechProvider.NAME);
        }
        try {
            this.engineSetPadding("PKCS5Padding");
        }
        catch (NoSuchPaddingException pe) {
            throw new InvalidAlgorithmParameterException("PKCS5Padding needed");
        }
        super.engineInit(opmode, (Key)new DESedeKey(deskey1, deskey2, deskey3), new IvParameterSpec(iv), random);
    }

    public void engineInit(int opmode, Key key, SecureRandom random) throws InvalidKeyException {
        throw new InvalidKeyException("PBEParameterSpec is needed");
    }

    public void engineInit(int opmode, Key key, AlgorithmParameters params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        throw new InvalidAlgorithmParameterException("PBEParameterSpec is needed");
    }
}

