/*
 * Decompiled with CFR 0.152.
 */
package com.initech.provider.crypto.cipher;

import com.initech.asn1.ASN1Decoder;
import com.initech.asn1.ASN1Encoder;
import com.initech.asn1.ASN1Exception;
import com.initech.asn1.ASN1OID;
import com.initech.asn1.BERDecoder;
import com.initech.asn1.useful.ASN1Object;
import java.util.Vector;

public class PEOBEParameterData
extends ASN1Object {
    private byte[] salt;
    private int iterationCount;
    private String objectName;
    private String[] keyFactorIDs = null;

    public PEOBEParameterData(byte[] data) throws ASN1Exception {
        BERDecoder dec = new BERDecoder(data);
        this.decode(dec);
        this.encoded = (byte[])data.clone();
        this.modified = false;
    }

    public PEOBEParameterData(byte[] salt, int iterationCount, String objectName, String[] keyFactorIDs) {
        this.salt = salt;
        this.iterationCount = iterationCount;
        this.objectName = objectName;
        this.keyFactorIDs = keyFactorIDs;
    }

    public byte[] getSalt() {
        return this.salt;
    }

    public int getIterationCount() {
        return this.iterationCount;
    }

    public String getObjectName() {
        return this.objectName;
    }

    public String[] getKeyFactorID() {
        return this.keyFactorIDs;
    }

    public void encode(ASN1Encoder enc) throws ASN1Exception {
        int id = enc.encodeSequence();
        int pbeId = enc.encodeSequence();
        enc.encodeOctetString(this.salt);
        enc.encodeInteger(this.iterationCount);
        enc.endOf(pbeId);
        enc.encodeUTF8String(this.objectName);
        if (this.keyFactorIDs != null) {
            int keyFactor = enc.encodeSequence();
            for (int i = 0; i < this.keyFactorIDs.length; ++i) {
                enc.encodeObjectIdentifier(this.keyFactorIDs[i]);
            }
            enc.endOf(keyFactor);
        }
        enc.endOf(id);
    }

    public void decode(ASN1Decoder dec) throws ASN1Exception {
        int id = dec.decodeSequence();
        int pbeId = dec.decodeSequence();
        this.salt = dec.decodeOctetString();
        this.iterationCount = dec.decodeIntegerAsInt();
        dec.endOf(pbeId);
        this.objectName = dec.decodeUTF8String();
        try {
            if (!dec.nextIsOptional(16)) {
                int keyFactorId = dec.decodeSequence();
                Vector<String> tmp = new Vector<String>();
                while (!dec.endOf(keyFactorId)) {
                    ASN1OID sOid = dec.decodeObjectIdentifier();
                    tmp.add(sOid.get());
                }
                this.keyFactorIDs = new String[tmp.size()];
                this.keyFactorIDs = tmp.toArray(this.keyFactorIDs);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        dec.endOf(id);
    }
}

