/*
 * Decompiled with CFR 0.152.
 */
package com.initech.provider.crypto.cipher;

import com.initech.asn1.ASN1Decoder;
import com.initech.asn1.ASN1Encoder;
import com.initech.asn1.ASN1Exception;
import com.initech.asn1.BERDecoder;
import com.initech.asn1.useful.ASN1Object;
import com.initech.cryptox.AlgorithmParametersSpi;
import com.initech.cryptox.spec.PEOBEParameterSpec;
import com.initech.cryptox.util.Hex;
import com.initech.provider.AutoJCE;
import com.initech.provider.crypto.cipher.PEOBEParameterData;
import java.io.IOException;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;

public class PEOBEParameters
extends AlgorithmParametersSpi {
    byte[] salt;
    int iterationCount;
    String objectName;
    String[] keyFactorIDs;

    public PEOBEParameters() {
    }

    public PEOBEParameters(byte[] salt, int iterationCount, String objectName, String[] keyFactorIDs) {
        this.salt = salt;
        this.iterationCount = iterationCount;
        this.objectName = objectName;
        this.keyFactorIDs = keyFactorIDs;
    }

    protected void _engineInit(AlgorithmParameterSpec paramSpec) throws InvalidParameterSpecException {
        try {
            paramSpec = (AlgorithmParameterSpec)AutoJCE.toJCEX(paramSpec);
            if (!(paramSpec instanceof PEOBEParameterSpec)) {
                throw new InvalidParameterSpecException("Not a PEOBEParameterSpec");
            }
            PEOBEParameterSpec spec = (PEOBEParameterSpec)paramSpec;
            this.salt = spec.getSalt();
            this.iterationCount = spec.getIterationCount();
            this.objectName = spec.getObjectName();
            this.keyFactorIDs = spec.getKeyFactorIDs();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void _engineInit(byte[] params) throws IOException {
        try {
            PEOBEParameterData paramData = new PEOBEParameterData(params);
            this.salt = paramData.getSalt();
            this.iterationCount = paramData.getIterationCount();
            this.objectName = paramData.getObjectName();
            this.keyFactorIDs = paramData.getKeyFactorID();
        }
        catch (ASN1Exception e) {
            e.printStackTrace();
            throw new IOException(e.toString());
        }
    }

    protected void _engineInit(byte[] params, String format) throws IOException {
        this._engineInit(params);
    }

    protected AlgorithmParameterSpec _engineGetParameterSpec(Class paramSpec) throws InvalidParameterSpecException {
        String name = paramSpec.getName();
        if (PEOBEParameterSpec.class.isAssignableFrom(paramSpec)) {
            return new PEOBEParameterSpec(this.salt, this.iterationCount, name, this.keyFactorIDs);
        }
        throw new InvalidParameterSpecException("Not a PEOBEParameterSpec assignable spec");
    }

    protected byte[] _engineGetEncoded() throws IOException {
        try {
            return new PEOBEParameterData(this.salt, this.iterationCount, this.objectName, this.keyFactorIDs).getEncoded();
        }
        catch (ASN1Exception ae) {
            throw new IOException(ae.toString());
        }
    }

    protected byte[] _engineGetEncoded(String format) throws IOException {
        return this._engineGetEncoded();
    }

    protected String _engineToString() {
        StringBuffer buff = new StringBuffer();
        buff.append("salt: [").append(Hex.dumpHex(this.salt)).append("]\n");
        buff.append("iterationCount: [").append(this.iterationCount).append("]\n");
        buff.append("objectName: [").append(this.objectName).append("]\n");
        buff.append("keyFactorIDs: ").append("[\n");
        for (int i = 0; i < this.keyFactorIDs.length; ++i) {
            buff.append(" >> ").append(this.keyFactorIDs[i]).append("\n");
        }
        buff.append("keyFactorIDs: ").append("]\n");
        return buff.toString();
    }

    class PBEParameterData
    extends ASN1Object {
        byte[] salt;
        int iterationCount;

        public PBEParameterData(byte[] data) throws ASN1Exception {
            BERDecoder dec = new BERDecoder(data);
            this.decode(dec);
            this.encoded = (byte[])data.clone();
            this.modified = false;
        }

        public PBEParameterData(byte[] salt, int iterationCount) {
            this.salt = salt;
            this.iterationCount = iterationCount;
        }

        public byte[] getSalt() {
            return this.salt;
        }

        public int getIterationCount() {
            return this.iterationCount;
        }

        public void encode(ASN1Encoder enc) throws ASN1Exception {
            enc.encodeOctetString(this.salt);
            enc.encodeInteger(this.iterationCount);
        }

        public void decode(ASN1Decoder dec) throws ASN1Exception {
            int id = dec.decodeSequence();
            this.salt = dec.decodeOctetString();
            this.iterationCount = dec.decodeIntegerAsInt();
            dec.endOf(id);
        }
    }
}

