/*
 * Decompiled with CFR 0.152.
 */
package com.initech.provider.crypto.cipher;

import com.initech.cryptox.SecretKeyFactorySpi;
import com.initech.cryptox.spec.SecretKeySpec;
import com.initech.provider.AutoJCE;
import com.initech.provider.crypto.spec.PBEKeySpec16;
import com.initech.provider.crypto.spec.PBEKeySpec8;
import com.initech.provider.pkcs.pkcs5.PBEKey;
import java.security.InvalidKeyException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.util.Arrays;
import javax.crypto.SecretKey;
import javax.crypto.spec.PBEKeySpec;

public class PKCS5KeyFactory
extends SecretKeyFactorySpi {
    protected SecretKey engineGenerateSecret(KeySpec keySpec) throws InvalidKeySpecException {
        return this.engineGenerateSecretX(keySpec);
    }

    protected com.initech.cryptox.SecretKey engineGenerateSecretX(KeySpec keySpec) throws InvalidKeySpecException {
        if (keySpec instanceof PBEKeySpec) {
            byte[] key = PKCS5KeyFactory.getPBEKey((PBEKeySpec)keySpec);
            PBEKey pbe = new PBEKey(key);
            Arrays.fill(key, (byte)0);
            return pbe;
        }
        if (keySpec instanceof javax.crypto.spec.SecretKeySpec) {
            SecretKeySpec skspec = (SecretKeySpec)(keySpec = (KeySpec)AutoJCE.toJCEX(keySpec));
            if (!"PBE".equals(skspec.getAlgorithm())) {
                throw new InvalidKeySpecException("SecretKeySpec not for SEED");
            }
            if (!"RAW".equals(skspec.getFormat())) {
                throw new InvalidKeySpecException("Unknown encoding format in KeySpec");
            }
            byte[] key = skspec.getEncoded();
            PBEKey pbe = new PBEKey(key);
            Arrays.fill(key, (byte)0);
            return pbe;
        }
        throw new InvalidKeySpecException(keySpec.getClass().getName() + " not valid for PKCS#5 Key.");
    }

    protected KeySpec engineGetKeySpec(com.initech.cryptox.SecretKey key, Class keySpec) throws InvalidKeySpecException {
        if (key instanceof PBEKey) {
            if (SecretKeySpec.class.isAssignableFrom(keySpec)) {
                return new SecretKeySpec(key.getEncoded(), "PBE");
            }
            if (PBEKeySpec.class.isAssignableFrom(keySpec)) {
                byte[] rawKey = key.getEncoded();
                char[] charKey = new char[rawKey.length];
                for (int i = 0; i < rawKey.length; ++i) {
                    charKey[i] = (char)rawKey[i];
                }
                return new PBEKeySpec8(charKey);
            }
        }
        throw new InvalidKeySpecException("Not a PKCS#5 PBEKey");
    }

    protected SecretKey engineTranslateKey(SecretKey key) throws InvalidKeyException {
        if (!key.getAlgorithm().equals("PBE")) {
            throw new InvalidKeyException("Not a PKCS#5 PBEKey");
        }
        return new PBEKey(key.getEncoded());
    }

    protected com.initech.cryptox.SecretKey engineTranslateKey(com.initech.cryptox.SecretKey key) throws InvalidKeyException {
        if (!key.getAlgorithm().equals("PBE")) {
            throw new InvalidKeyException("Not a PKCS#5 PBEKey");
        }
        return new PBEKey(key.getEncoded());
    }

    public static byte[] getPBEKey8(PBEKeySpec pbeKeySpec) {
        char[] caPassword = pbeKeySpec.getPassword();
        byte[] byPassword = new byte[caPassword.length];
        for (int i = 0; i < caPassword.length; ++i) {
            byPassword[i] = (byte)(caPassword[i] & 0xFF);
            caPassword[i] = '\u0000';
        }
        return byPassword;
    }

    public static byte[] getPBEKey16(PBEKeySpec pbeKeySpec) {
        char[] caPassword = pbeKeySpec.getPassword();
        byte[] byPassword = new byte[caPassword.length * 2 + 2];
        for (int i = 0; i < caPassword.length; ++i) {
            byPassword[2 * i] = (byte)(caPassword[i] & 0xFF00);
            byPassword[2 * i + 1] = (byte)(caPassword[i] & 0xFF);
            caPassword[i] = '\u0000';
        }
        byPassword[byPassword.length - 1] = 0;
        byPassword[byPassword.length - 2] = 0;
        return byPassword;
    }

    public static byte[] getPBEKey(PBEKeySpec pbeKeySpec) {
        if (pbeKeySpec instanceof PBEKeySpec16) {
            return PKCS5KeyFactory.getPBEKey16(pbeKeySpec);
        }
        if (pbeKeySpec instanceof PBEKeySpec8) {
            return PKCS5KeyFactory.getPBEKey8(pbeKeySpec);
        }
        return PKCS5KeyFactory.getPBEKey8(pbeKeySpec);
    }
}

